<?php

function drivingschool_fonts_url1() {
	$font_url = '';
    if ( 'off' !== _x( 'on', 'Google font: on or off', 'drivingschool' ) ) {
        $font_url = add_query_arg( 'family', urlencode( 'Montserrat:400,700' ), "//fonts.googleapis.com/css" );
    }
    return $font_url;
}

function drivingschool_fonts_url2() {
    $font_url = '';
	if ( 'off' !== _x( 'on', 'Google font: on or off', 'drivingschool' ) ) {
        $font_url = add_query_arg( 'family', urlencode( 'Roboto:400,500,700' ), "//fonts.googleapis.com/css" );
    }
    return $font_url;
}

function drivingschool_googlemaps() {
	if(get_theme_mod('drivingschool_map_key')){
		$googlemaps = 'https://maps.googleapis.com/maps/api/js?key='.get_theme_mod('drivingschool_map_key').'"';
		return $googlemaps;
	}
}

function drivingschool_google_recaptcha_api() {
	if ( get_theme_mod( 'drivingschool_form_captcha' ) ) {
        $key = get_theme_mod( 'drivingschool_captcha_key' );
        if ( $key ) {
            $url = 'https://www.google.com/recaptcha/api.js';
            $args = array(
                'render' => $key,
            );
            $url = add_query_arg( $args, $url );
            return $url;
        }
	}
    return;
}

/**
 * Scripts and styles
 */
function drivingschool_scripts () {

	wp_enqueue_style( 'google-font-montserrat', drivingschool_fonts_url1(), array(), null );
	wp_enqueue_style( 'google-font-roboto', drivingschool_fonts_url2(), array(), null );
	
	wp_enqueue_style( 'drivingschool_app', get_template_directory_uri().'/assets/styles/app.css', array(), '1.3.1111' );
	wp_enqueue_style( 'drivingschool_style', get_template_directory_uri().'/style.css', array(), null );
	
	wp_enqueue_script('googlemaps', drivingschool_googlemaps(), array( 'jquery' ), null, true);
    
    wp_enqueue_script( 'google_recaptcha', drivingschool_google_recaptcha_api(), array( 'jquery' ), null, true);
    
	wp_enqueue_script( 'jquery-ui-datepicker' );
	wp_enqueue_script( 'jquery.formstyler', get_template_directory_uri().'/assets/scripts/jquery.formstyler.js', array( 'jquery' ), null, true );
	wp_enqueue_script( 'jquery.countdown', get_template_directory_uri().'/assets/scripts/jquery.countdown.js', array( 'jquery' ), null, true );
	wp_enqueue_script( 'jquery.magnific-popup.min', get_template_directory_uri().'/assets/scripts/jquery.magnific-popup.min.js', array( 'jquery' ), null, true );
	wp_enqueue_script( 'swiper.min', get_template_directory_uri().'/assets/scripts/swiper.min.js', array( 'jquery' ), '5.3.0', true );
	wp_enqueue_script( 'jquery.knob', get_template_directory_uri().'/assets/scripts/jquery.knob.js', array( 'jquery' ), null, true );
	wp_enqueue_script( 'imagesloaded');	
	wp_enqueue_script( 'isotope.pkgd.min', get_template_directory_uri().'/assets/scripts/isotope.pkgd.min.js', array( 'jquery' ), null, true );
	wp_enqueue_script( 'drivingschool-scripts', get_template_directory_uri().'/assets/scripts/scripts.js', array( 'jquery' ), '1.4.41', true );
	
	wp_localize_script('drivingschool-scripts', 'drivingschool_params', 
		array(
			'ajaxurl'      => admin_url('admin-ajax.php'),
			'nonce'        => wp_create_nonce('myajax-nonce'),
			'loading_text' => esc_html__('Loading...', 'drivingschool'),
			'load_text'    => esc_html__('load more', 'drivingschool'),
			'theme_uri'    => get_template_directory_uri(),
            'captcha_key'  => get_theme_mod( 'drivingschool_captcha_key' ),
		)
	);

	// Comment Reply
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
	
}
add_action( 'wp_enqueue_scripts', 'drivingschool_scripts' );

/**
 * Add admin scripts and styles
 */
function drivingschool_admin_scripts() {
	// Admin Style
	wp_enqueue_style( 'drivingschool-admin', get_template_directory_uri() . '/assets/styles/admin.css', array() );
	// Admin Scripts
	wp_enqueue_script( 'drivingschool-admin', get_template_directory_uri().'/assets/scripts/admin.js', array( 'jquery' ), null, true );
}
add_action( 'admin_enqueue_scripts', 'drivingschool_admin_scripts' );