<?php

/*

Template Name: Contacts

*/

drivingschool_on_ff();
?>
<?php get_header();  ?>
	<?php while (have_posts()) : the_post(); ?>
	<div class="head-page">
		<div class="container">
			<div class="row">
				<div class="col-md-8">
					<h1 class="title-page"><?php the_title(); ?></h1>
					<div class="breadcrumbs">
						<ul class="breadcrumbs__list">
							<li class="breadcrumbs__item">
								<a href="<?php echo esc_url( home_url('/') ); ?>" class="breadcrumbs__link"><?php esc_html_e('Index', 'drivingschool'); ?></a>
							</li>
							<?php if (drivingschool_is_subpage()) { ?>
							<li class="breadcrumbs__item">
								<a href="<?php echo get_permalink($post->post_parent); ?>" class="breadcrumbs__link"><?php echo get_the_title($post->post_parent); ?></a>
							</li>
							<?php } ?>
							<li class="breadcrumbs__item"><?php the_title(); ?></li>
						</ul>
					</div>
				</div>
				<div class="col-md-4">
					<?php get_search_form(); ?>
				</div>
			</div>
		</div>
	</div>
	<div class="content">
		<div class="address">
			<?php if( have_rows('map') ): ?>
			<div class="address__city">
				<div class="container">
					<div class="filter filter_theme_white address__filter">
						<?php $m = 0; while( have_rows('map') ) : the_row(); $m++; ?>
						<span class="filter__item<?php if($m==1){ echo " filter__item_active"; } ?>">
							<span class="filter__item-text"><?php esc_html(the_sub_field('city')); ?></span>
						</span>
						<?php endwhile; ?>
					</div>
				</div>
			</div>

			<div class="address__map" id="addressMaps">
				<?php $a = 0; while( have_rows('map') ) : the_row(); $a++; ?>
				<div id="addressMap<?php echo esc_attr($a); ?>" class="address__map-item<?php if($a == 1){ echo " active"; } ?>" data-lat="<?php esc_attr(the_sub_field('coordinate_1')); ?>" data-title="<?php echo get_sub_field('city');?>" data-lng="<?php esc_attr(the_sub_field('coordinate_2')); ?>"></div>
				<?php endwhile; ?>
			</div>

			<?php endif; ?>
			<?php if( have_rows('address') or get_post_meta($post->ID, 'email', true) != '' ) { ?>
			<div class="address__data container">
				<?php if( have_rows('address') ): ?>
				<div class="row">
					<?php while( have_rows('address') ) : the_row();  ?>
					<div class="data col-md-4">
						<div class="address__data-item">
							<span class="address__data-value"><?php esc_html(the_sub_field('text1')); ?></span>
							<span class="address__data-value"><?php esc_html(the_sub_field('text2')); ?></span>
						</div>
					</div>
					 <?php endwhile; ?>
				</div>
				<?php endif; ?>
				<?php if( get_post_meta($post->ID, 'email', true) != '' ) { ?>
				<div class="row">
					<div class="col-md-12">
						<a href="mailto:<?php echo esc_html(get_post_meta($post->ID, 'email', true)); ?>" class="address__mail"><?php echo esc_html(get_post_meta($post->ID, 'email', true)); ?></a>
					</div>
				</div>
				<?php } ?>
				<?php } ?>
			</div>
		</div>
		<?php
			if(function_exists("drivingschool_form_contacts") and get_post_meta($post->ID, 'form', true) != "no") {
				drivingschool_form_contacts();
			}
		?>
		<?php endwhile; ?>
	</div>
<?php get_footer(); ?>