<?php

/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 */
function drivingschool_setup() {
	/**
	 * Make theme available for translation.
	 */
	load_theme_textdomain( 'drivingschool', get_template_directory() . '/lang' );
	
	/**
	 * Add <title> tag.
	 */
	add_theme_support( 'title-tag' );
	
	/**
	 * Add default posts and comments RSS feed links to head.
	 */
	add_theme_support( 'automatic-feed-links' );
	
	/**
	 * Enable support custom headers
	 */
	add_theme_support( 'custom-header' );
	
	/**
	 * Enable support custom headers
	 */
	add_theme_support( 'custom-background');
	
	/**
	 * Enable support for Post Thumbnails.
	 */
	add_theme_support( 'post-thumbnails' );
	
	// Add image size
	add_image_size( 'drivingschool_footor-thumb',   124, 176, true);
	add_image_size( 'drivingschool_photo-thumb',    165, 165, true);
	add_image_size( 'drivingschool_about-thumb',    262, 262, true);
	add_image_size( 'drivingschool_ava-thumb',      70,  70,  true);
	add_image_size( 'drivingschool_posts-thumb',    190, 160, true);
	add_image_size( 'drivingschool_article-thumb',  825, 372, true);
	add_image_size( 'drivingschool_teacher-thumb',  95, 95,  true);
	add_image_size( 'drivingschool_teacher2-thumb', 251, 251, true);
	add_image_size( 'drivingschool_cars-thumb',     263, 135, true);
	
	/**
	 * Set the content width based on the theme's design and stylesheet.
	 */
	if ( !isset($content_width) ) {
		$content_width = 900;
	}

	/**
	 * Register Nav Menus locations.
	 */
	register_nav_menus( array( 
		'primary' => esc_html__( 'Main menu'  , 'drivingschool' ),
		'footer'  => esc_html__( 'Footer menu', 'drivingschool' ),
	) );
	
	/**
	 * This theme styles the visual editor to resemble the theme style,
	 * specifically font, colors, icons, and column width.
	 */
	add_editor_style( array( 'assets/styles/editor-style.css', drivingschool_fonts_url1() ) );

}
add_action( 'after_setup_theme', 'drivingschool_setup' );

/**
 * Custom nav menu css class
 */
function drivingschool_custom_nav_class($classes, $item){
	$classes[] = "nav__item";
	return $classes;
}
add_filter('nav_menu_css_class' , 'drivingschool_custom_nav_class' , 10 , 2);

/**
 * Custom wp_nav_menu
 */
function drivingschool_add_menuclass($ulclass) {
	return preg_replace('/<a /', '<a class="nav__link" ', $ulclass);
}
add_filter('wp_nav_menu', 'drivingschool_add_menuclass');

/**
 * Registers a widget area.
 */
function drivingschool_widgets_init() {
	 register_sidebar( array(  
		'name' => esc_html__('Default Sidebar', 'drivingschool'),
		'id' => "sidebar-1",
		'before_widget' => '<div class="widget %2$s">', 
		'after_widget' =>  '</div>', 
		'before_title' =>  '<div class="widget__header"><span class="widget__header-text">', 
		'after_title' =>   '</span></div>' 
	 ) );
	register_sidebar( array(  
		'name' => esc_html__('Sidebar', 'drivingschool'),
		'id' => "widget_s",
		'before_widget' => '<div class="widget %2$s">', 
		'after_widget' =>  '</div>', 
		'before_title' =>  '<div class="widget__header"><span class="widget__header-text">', 
		'after_title' =>   '</span></div>' 
	 ) );
	register_sidebar( array(  
		'name' => esc_html__('Footer', 'drivingschool'),
		'id' => "widget_f",
		'before_widget' => '<div class="footer__section col-md-3 footer-widget %2$s">', 
		'after_widget'  => '</div>', 
		'before_title'  => '<h4 class="footer__title">', 
		'after_title'   => '</h4>' 
	 ) );
}
add_action( 'widgets_init', 'drivingschool_widgets_init' );

function drivingschool_wpdocs_filter_theme_page_templates( $page_templates ) {
	if ( ! defined( 'DRIVINGSCHOOL_PLUGIN' ) ) {
		if ( isset( $page_templates['page-composer.php'] ) ) {
			unset( $page_templates['page-composer.php'] );
		}
		if ( isset( $page_templates['page-contacts.php'] ) ) {
			unset( $page_templates['page-contacts.php'] );
		}
		if ( isset( $page_templates['page-photo.php'] ) ) {
			unset( $page_templates['page-photo.php'] );
		}
		if ( isset( $page_templates['page-about.php'] ) ) {
			unset( $page_templates['page-about.php'] );
		}
		if ( isset( $page_templates['page-feature.php'] ) ) {
			unset( $page_templates['page-feature.php'] );
		}
		if ( isset( $page_templates['page-faq.php'] ) ) {
			unset( $page_templates['page-faq.php'] );
		}
		if ( isset( $page_templates['page-price.php'] ) ) {
			unset( $page_templates['page-price.php'] );
		}
		if ( isset( $page_templates['page-course.php'] ) ) {
			unset( $page_templates['page-course.php'] );
		}
		if ( isset( $page_templates['page-review.php'] ) ) {
			unset( $page_templates['page-review.php'] );
		}
	}
	return $page_templates;
}
add_filter( 'theme_page_templates', 'drivingschool_wpdocs_filter_theme_page_templates' );

/**
 * Custom template tags for this theme.
 */
require_once get_theme_file_path( '/include/cssjs.php' );
require_once get_theme_file_path( '/include/customizer.php' );
require_once get_theme_file_path( '/include/loadmore.php' );
require_once get_theme_file_path( '/include/template-tags.php' );
require_once get_theme_file_path( '/include/subscription.php' );
require_once get_theme_file_path( '/include/social.php' );

/**
 * Include the TGM_Plugin_Activation
 */
require_once get_theme_file_path( '/include/tgmpa/plugin-activation.php' );

/**
 * Remove Activation Notice for Visual Composer
 */
function drivingschool_remove_activation_notice_v_composer(){
	if(is_admin()) {
		setcookie('vchideactivationmsg', '1', strtotime('+3 years'), '/');
		setcookie('vchideactivationmsg_vc11', (defined('WPB_VC_VERSION') ? WPB_VC_VERSION : '1'), strtotime('+3 years'), '/');
	}
}
add_action('admin_init', 'drivingschool_remove_activation_notice_v_composer');