<?php 
/**
 * Template Tags
 */


//Fallback the default menu
function drivingschool_fallback_default_menu() {
	$args = array(
		'title_li' => '',
		'echo'     => false
	);
	echo '<ul class="nav__list">'.wp_list_pages( $args ).'</ul>';
}

// Custom page_css_class
function drivingschool_page_css_class( $css_class ){
	$css_class[] = "nav__item";
	return $css_class;
}
add_filter( 'page_css_class', 'drivingschool_page_css_class');

// Custom page_menu_link_attributes
function drivingschool_page_menu_link_attributes( $atts ){
	$atts['class'] = 'nav__link';
	return $atts;
}
add_filter( 'page_menu_link_attributes', 'drivingschool_page_menu_link_attributes');


function drivingschool_get_attachment_id($url) {
    global $wpdb;
    $table  = $wpdb->prefix . 'posts';
    $attachment_id = $wpdb->get_var( 
        $wpdb->prepare( "SELECT ID FROM $table WHERE guid RLIKE %s", $url ) 
    );
    return $attachment_id;
}

function drivingschool_is_subpage() {
    global $post;
    if (is_page() && $post->post_parent) {
        return $post->post_parent;
    } else {
        return false;
    }
}

function drivingschool_is_subcategory ($catid) {
    $currentcat = get_category($catid);
    if ($currentcat->parent) {
        return true;
    } else {
        return false;
    }
} 

function drivingschool_get_excerpt( $limit = '190'){
    $excerpt = get_the_content();
    $excerpt = preg_replace(" ([.*?])",'',$excerpt);
    $excerpt = strip_shortcodes($excerpt);
    $excerpt = strip_tags($excerpt);
    $excerpt = substr($excerpt, 0, $limit);
    $excerpt = substr($excerpt, 0, strripos($excerpt, " "));
	if ( $excerpt ) {
		$excerpt = $excerpt . '...';
	}
    return $excerpt;
}

function drivingschool_on_ff() {
	if ( ! defined( 'DRIVINGSCHOOL_PLUGIN' ) ) {
        esc_html_e('&quot;Driving school plugin&quot; plugin installed!', 'drivingschool');
	    die();
	}
}

function drivingschool_paginat($total = 0) {
	$big = 999999999; 
	if($total == 0) {
		global $wp_query;
		$total = $wp_query->max_num_pages;
	}
	echo '<div class="pagination">';
	echo paginate_links( array(
	    'base'    => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
	    'format'  => '?paged=%#%',
	    'current' => max( 1, get_query_var('paged') ),
	    'total'   => $total
    ));
	echo '</div>';
}

function drivingschool_has_header_info(){
	$return = false;
	if(get_theme_mod('drivingschool_logo_h') != ""){
		$return = true;
	}
	if(get_theme_mod('drivingschool_address') != ""){
		$return = true;
	}
	if(get_theme_mod('drivingschool_phone') != ""){
		$return = true;
	}
	if(function_exists("drivingschool_form_call_me") and get_theme_mod('drivingschool_call_me') != "no"){
		$return = true;
	}
	return $return;
}

function drivingschool_copyright_edit(){
	$query['autofocus[control]'] = 'drivingschool_copyright';
	$control_link = add_query_arg( $query, admin_url( 'customize.php' ) );
	echo '<a href="' . esc_url( 'https://themeforest.net/item/driving-school-wordpress-theme/20616993' ) . '">' . esc_html__('Theme development by NoxonThemes','drivingschool') . '</a>';
	if ( current_user_can( 'customize' ) ) {
		echo ' | <a href=" ' . esc_url( $control_link ) . '" target="_blank">' . esc_html__('Edit copyright here','drivingschool') . '</a>';
	}
}