<?php get_header(); ?>
	<div class="head-page">
		<div class="container">
			<div class="row">
				<div class="col-md-8">
					<h1 class="title-page"><?php bloginfo('description'); ?></h1>
				</div>
				<div class="col-md-4">
					<?php get_search_form(); ?>
				</div>
			</div>
		</div>
	</div>
	<div class="content">
		<div class="blog">
			<div class="container">
				<div class="row">

					<div class="col-md-9">
						<div class="post-list">
						<?php $i = 0; if ( have_posts() ) : while ( have_posts() ) : the_post(); $i++; ?>
							<article <?php post_class(); ?> id="post-<?php the_ID(); ?>">
								<div class="row">
                                    <?php $column = '12'; ?>
									<?php if( has_post_thumbnail() ) { ?>
									<div class="col-md-3">
										<figure class="post__fig">											
										   <a href="<?php the_permalink();?>"><?php the_post_thumbnail('drivingschool_posts-thumb'); ?></a> 
										</figure>
										<time datetime="2016-01-12" class="post__date"><?php the_time("d.m.Y"); ?></time>
									</div>
									<?php $column = '9'; } ?>
									<div class="col-md-<?php echo esc_attr( $column ); ?>">
										<?php the_title( '<h3 class="post__title"><a href="' . esc_url( get_permalink() ) . '" class="post__title-link">', '</a></h3>' );?>
										<?php if ( drivingschool_get_excerpt() ) {?>
											<p class="post__text"><?php echo drivingschool_get_excerpt(); ?></p>
										<?php } ?>
										<div class="post__meta">
											<div class="post__meta-item">
												<a href="<?php the_permalink();?>#respond" class="post__meta-comments"><?php comments_number(esc_html__("0 comments","drivingschool"),esc_html__("1 comment","drivingschool"),esc_html__("% comments","drivingschool")); ?></a>
											</div>
											<?php if( function_exists('drivingschool_postviews')){?>
												<div class="post__meta-item">
													<div class="post__meta-view"><?php drivingschool_postviews($post->ID); ?></div>
												</div>
											<?php } ?>
										</div>
									</div>
								</div>
							</article>
							<?php 
								if(get_theme_mod('drivingschool_home_subs') == "yes") {
									if(get_theme_mod('drivingschool_post') == $i) { drivingschool_subscription_display(); }

								}
								endwhile;  
								if(get_theme_mod('drivingschool_pagination') == "yes") {
							?>
							<div class="loadmore_container"> </div>
							<?php 
								if (  $wp_query->max_num_pages > 1 and get_theme_mod('thecrazy_pogination_on')!="numbers") :
								echo drivingschool_ajax_cat(
										 serialize($wp_query->query_vars),
										 (get_query_var('paged')) ? get_query_var('paged') : 1, 
										 $wp_query->max_num_pages
								); 
							?>
							<div class="post-list__more">
								<a class="btn btn_theme_blue btn_fullwidth" id="true_loadmore" href="javascript:void(0);">
									<span class="btn__text"><?php esc_html_e('load more', 'drivingschool'); ?></span>
								</a>
							</div>
							<?php 
								endif; 
								} else {
									drivingschool_paginat(); 
								}
								endif; 
							?>
						</div>
					</div>
                    
                    <?php get_sidebar(); ?>
                    
				</div>
			</div>
		</div>
	</div>
<?php get_footer();
