<?php

/*

Template Name: Feature

*/

drivingschool_on_ff();
?>
<?php get_header();  ?>
	<?php while (have_posts()) : the_post(); ?>
	<div class="head-page">
		<div class="container">
			<div class="row">
				<div class="col-md-8">
					<h1 class="title-page"><?php the_title(); ?></h1>
					<div class="breadcrumbs">
						<ul class="breadcrumbs__list">
							<li class="breadcrumbs__item">
								<a href="<?php echo esc_url( home_url('/') ); ?>" class="breadcrumbs__link"><?php esc_html_e('Index', 'drivingschool'); ?></a>
							</li>
							<?php if (drivingschool_is_subpage()) { ?>
							<li class="breadcrumbs__item">
								<a href="<?php echo get_permalink($post->post_parent); ?>" class="breadcrumbs__link"><?php echo get_the_title($post->post_parent); ?></a>
							</li>
							<?php } ?>
							<li class="breadcrumbs__item"><?php the_title(); ?></li>
						</ul>
					</div>
				</div>
				<div class="col-md-4">
					<?php get_search_form(); ?>
				</div>
			</div>
		</div>
	</div>
	<div class="content">
		<div class="text">
			<div class="container">
				<div class="row">
					<div class="col-md-12">
						<?php the_content(); ?>
					</div>
				</div>
			</div>
		</div>
		
		<?php if( have_rows('blocks') ): ?>
		<div class="feature">
			<div class="feature__list">
				<div class="container">
					<div class="feature__row-list row">
					<?php $m = 0; while( have_rows('blocks') ) : the_row(); $m++; ?>
					<?php if($m ==5) { $m = 0; ?>
					   </div></div></div>
					   <div class="feature__list"><div class="container"><div class="feature__row-list row">
				   <?php } ?>
						<div class="feature__item col-md-3">
							<div class="feature__icon">
								<svg class="<?php echo str_replace("icon_", "feature__", get_sub_field('icon')); ?>"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#<?php esc_html(the_sub_field('icon')); ?>"></use></svg>
							</div>
							<h3 class="feature__title"><?php esc_html(the_sub_field('title')); ?></h3>
							<p class="feature__desc"><?php esc_html(the_sub_field('text')); ?></p>
						</div>
				   <?php endwhile; ?> 
				   </div>
				</div>
			</div>
		</div> 
		<?php endif; ?>
		<?php endwhile; ?>
	</div>
<?php get_footer(); ?>