<?php get_header();  ?>

<?php while (have_posts()) : the_post(); ?>
	<div class="head-page">
		<div class="container">
			<div class="row">
				<div class="col-md-8">
					<h1 class="title-page"><?php the_title(); ?></h1>
					<div class="breadcrumbs">
						<ul class="breadcrumbs__list">
							<li class="breadcrumbs__item">
								<a href="<?php echo esc_url( home_url('/') ); ?>" class="breadcrumbs__link"><?php esc_html_e('Index', 'drivingschool'); ?></a>
							</li>
							<?php if (drivingschool_is_subpage()) { ?>
							<li class="breadcrumbs__item">
								<a href="<?php echo get_permalink($post->post_parent); ?>" class="breadcrumbs__link"><?php echo get_the_title($post->post_parent); ?></a>
							</li>
							<?php } ?>
							<li class="breadcrumbs__item"><?php the_title(); ?></li>
						</ul>
					</div>
				</div>
				<div class="col-md-4">
					<?php get_search_form(); ?>
				</div>
			</div>
		</div>
	</div>
	<div class="content">
		<div class="text text_bottom-m_no">
			<div class="container">
				<div class="row">
					<div class="col-md-12">
						<div class="article__body">
							<?php the_content(); ?>
							<?php 
								$args = array(
									'before'           => '<div class="page-numbers page-pagination">' . esc_html__('Pages:', 'drivingschool'),
									'after'            => '</div>',
									'link_before'      => '<span>',
									'link_after'       => '</span>'
								);					
								wp_link_pages( $args );
							?>
						</div>
					</div>
					<?php if ('open' == $post-> comment_status) { ?>
					<div class="col-md-12 mbfc">
						   <?php comments_template( '', true ); ?>
					 </div>
					 <?php } else { ?>
				</div>
			</div>
		</div>
		<div class="bottom-he"> </div>  
		<?php } ?>
		<?php endwhile; ?>
	</div>
<?php get_footer();