<?php 

get_header();

$category = get_the_category();

while (have_posts()) : the_post(); ?>
	<div class="head-page">
		<div class="container">
			<div class="row">
				<div class="col-md-8">
					<h2 class="title-page"><?php esc_html_e('Blog','drivingschool'); ?></h2>
					<div class="breadcrumbs">
						<ul class="breadcrumbs__list">
							<li class="breadcrumbs__item">
								<a href="<?php echo esc_url( home_url('/') ); ?>" class="breadcrumbs__link"><?php esc_html_e('Index', 'drivingschool'); ?></a>
							</li>
							<?php if( ! is_attachment() && has_category() ) { ?>
							    <li class="breadcrumbs__item">
								<a href="<?php echo get_category_link($category[0]->cat_ID); ?>" class="breadcrumbs__link"><?php echo  get_cat_name($category[0]->cat_ID) ?></a>
							    </li>
							<?php } ?>
							<li class="breadcrumbs__item"><?php the_title(); ?></li>
						</ul>
					</div>
				</div>
				<div class="col-md-4">
					<?php get_search_form(); ?>
				</div>
			</div>
		</div>
	</div>
	<div class="content">
		<div class="container">
			<div class="row">
        
				<article class="article col-md-9">
					<?php if( has_post_thumbnail() ) { ?>
					<figure class="article__figure">
						<?php the_post_thumbnail('drivingschool_article-thumb'); ?>
					</figure>
					<?php } else { ?>
					<div class="no_thumbnail"> </div>
					<?php }  ?>
					<header class="article__header">
						<h1 class="article__title"><?php the_title(); ?></h1>
						<div class="article__meta">
							<div class="article__meta-item">
								<div class="article__meta-comments"><?php comments_number(esc_html__("0 comments","drivingschool"),esc_html__("1 comment","drivingschool"),esc_html__("% comments","drivingschool")); ?></div>
							</div>
							<?php if( function_exists('drivingschool_postviews')){?>
								<div class="article__meta-item">
									<div class="article__meta-view"><?php drivingschool_postviews($post->ID); ?></div>
								</div>
							<?php } ?>
						</div>
					</header>
					<div class="article__body">
						<?php the_content(); ?>
						<?php 
							$args = array(
								'before'           => '<div class="page-numbers page-pagination">' . esc_html__('Pages:', 'drivingschool'),
								'after'            => '</div>',
								'link_before'      => '<span>',
								'link_after'       => '</span>'
							);					
							wp_link_pages( $args );
						?>
						<?php if( has_tag() ) { ?>
							<p class="post-tags"><?php the_tags(); ?></p>
						<?php } ?>
					</div>
					
					 <?php 
						if(get_theme_mod('drivingschool_post_subs') == "yes") {
							drivingschool_subscription_display('subscribe_article');
						}
					 	if ( comments_open() || get_comments_number() ) :
							comments_template( '', true );
						endif;
					?>
				</article>
                
                <?php get_sidebar(); ?>

			</div>
		</div>
	</div>
	<?php endwhile; ?>
<?php get_footer();
