<?php

  // Namespace
  namespace BMI\Plugin\Dashboard;

  // Exit on direct access
  if (!defined('ABSPATH')) exit;

  if (!function_exists('bmi_get_config')) {
    function bmi_get_config($setting, $configpath = false) {

      if ($configpath == false && defined('BMI_CONFIG_PATH')) {
        $configpath = BMI_CONFIG_PATH;
      }

      // Load default and additional
      $defaults = json_decode(file_get_contents(BMI_CONFIG_DEFAULT));

      // Result default
      if (isset($defaults->{$setting}))
        $result = $defaults->{$setting};
      else $result = array();

      // Load user config
      if (file_exists($configpath) && defined('BMI_CONFIG_STATUS') && BMI_CONFIG_STATUS) {

        // Get file contents
        $bmi_config_contents = file_get_contents($configpath);
        if (defined('BMI_CONFIG_PHP') && BMI_CONFIG_PHP) {
          $bmi_config_contents = substr($bmi_config_contents, 8);
        }
        
        $bmi_config_json = json_decode($bmi_config_contents);

        // If config is correct set it
        if (json_last_error() == JSON_ERROR_NONE) {

          // Setting exist?
          if (isset($bmi_config_json->{$setting})) {

            // Get result
            $result = $bmi_config_json->{$setting};

          }

        }

      }

      // Replace exceptions
      if ($setting == 'STORAGE::LOCAL::PATH' && $result == 'default') {
        $result = BMI_BACKUPS_DEFAULT;
      }

      // Replace backshashes
      if ($setting == 'STORAGE::LOCAL::PATH') {
        $result = str_replace('\\\\', DIRECTORY_SEPARATOR, $result);
        $result = str_replace('\\', DIRECTORY_SEPARATOR, $result);
        $result = str_replace('/', DIRECTORY_SEPARATOR, $result);
      }

      // Return setting
      return $result;

    }
  }

  if (!function_exists('bmi_set_config')) {
    function bmi_set_config($setting, $value) {

      // Load default and additional
      if (file_exists(BMI_CONFIG_PATH)) {

        // Get file contents
        $bmi_config_contents = file_get_contents(BMI_CONFIG_PATH);
        if (defined('BMI_CONFIG_PHP') && BMI_CONFIG_PHP) {
          $bmi_config_contents = substr($bmi_config_contents, 8);
        }
        
        $bmi_config_json = json_decode($bmi_config_contents);

        // Result default
        $default = bmi_get_config($setting);

        // If config is correct set it
        if (!(json_last_error() == JSON_ERROR_NONE)) {

          // Setting refill base
          $bmi_config_json = json_decode(json_encode(array()));

        }

        // Allow empty
        $allow_empty = ['OTHER:CLI:PATH'];

        // Check if setting is not empty
        if (isset($value) && (!is_string($value) || (in_array($setting, $allow_empty) || strlen(trim($value)) > 0))) {

          // Set new setting
          @$bmi_config_json->{$setting} = $value;

        } else return false;

        // Write edited settings
        if (defined('BMI_CONFIG_PHP') && BMI_CONFIG_PHP) {
          file_put_contents(BMI_CONFIG_PATH, "<?php //" . json_encode($bmi_config_json));
        } else {
          file_put_contents(BMI_CONFIG_PATH, json_encode($bmi_config_json));
        }
        
        return true;

      }

      return false;

    }
  }

  if (!function_exists('bmi_try_checked')) {
    function bmi_try_checked($setting, $reversed = false) {

      if (!$reversed) {

        if (bmi_get_config($setting) == 'true' || bmi_get_config($setting) === true) {
          echo ' checked';
        } else return false;

      } else {

        if (bmi_get_config($setting) == 'true' || bmi_get_config($setting) === true) {
          return false;
        } else {
          echo ' checked';
        }

      }

    }
  }

  if (!function_exists('bmi_try_value')) {
    function bmi_try_value($setting) {

      $res = bmi_get_config($setting);
      if ($res !== false) {
        echo ' value="' . sanitize_text_field($res) . '"';
      } else echo '';

    }
  }

  function bmi_try_convert_old_to_new_config(&$bmi_initial_config_filepath, &$bmi_initial_config_dirpath, $init = true) {
    
    $newConfigStaticPath = BMI_STATIC_PHP_CONFIG;
    if (file_exists($newConfigStaticPath)) {
      $configContents = file_get_contents(BMI_STATIC_PHP_CONFIG);
      if (strpos($configContents, "<?php //[]") !== false) {
        unlink(BMI_STATIC_PHP_CONFIG);
      }
    }
    
    if (file_exists($newConfigStaticPath)) {
      
      if (!defined('BMI_CONFIG_PHP')) define('BMI_CONFIG_PHP', true);
      if (!defined('BMI_CONFIG_STATUS')) define('BMI_CONFIG_STATUS', true);
      if (!defined('BMI_CONFIG_PATH')) define('BMI_CONFIG_PATH', $newConfigStaticPath);
      if (!defined('BMI_INITIAL_CONFIG_PATH')) define('BMI_INITIAL_CONFIG_PATH', $bmi_initial_config_filepath);
      
      $localStoragePath = bmi_get_config('STORAGE::LOCAL::PATH', $newConfigStaticPath);
      if ($localStoragePath == "default") $localStoragePath = BMI_BACKUPS_DEFAULT;
      
      if (!(is_readable($localStoragePath) && is_dir($localStoragePath))) {
        $localStoragePath = WP_CONTENT_DIR . DIRECTORY_SEPARATOR . 'backup-migration-' . bmi_config_random_string(10);
        bmi_set_config('STORAGE::LOCAL::PATH', $localStoragePath);
      }
      
      if (basename($localStoragePath) == 'backup-migration') {
        $current_patch = get_option('bmi_hotfixes', array());
        $key = array_search('BMI_D20_M07_01', $current_patch);
        if ($key !== false) unset($current_patch[$key]);
        update_option('bmi_hotfixes', $current_patch);
      }
      
      if (!defined('BMI_BACKUPS_ROOT')) define('BMI_BACKUPS_ROOT', $localStoragePath);
      if (!defined('BMI_CONFIG_DIR')) define('BMI_CONFIG_DIR', $localStoragePath);
      if (!defined('BMI_BACKUPS')) define('BMI_BACKUPS', $localStoragePath . DIRECTORY_SEPARATOR . 'backups');
      if (!defined('BMI_STAGING')) define('BMI_STAGING', $localStoragePath . DIRECTORY_SEPARATOR . 'staging');
      if (!defined('BMI_TMP')) define('BMI_TMP', BMI_BACKUPS_ROOT . DIRECTORY_SEPARATOR . 'tmp');
      
      $bmi_initial_config_dirpath = $localStoragePath;
      $bmi_initial_config_filepath = $newConfigStaticPath;
      
      return true;
      
    } else {
      
      if (file_exists($bmi_initial_config_filepath)) {
        file_put_contents($newConfigStaticPath, "<?php //" . file_get_contents($bmi_initial_config_filepath));
        @unlink($bmi_initial_config_filepath);
        if ($init) bmi_try_convert_old_to_new_config($bmi_initial_config_filepath, $bmi_initial_config_dirpath, false);
        $bmi_initial_config_filepath = $newConfigStaticPath;
      }
      
      return false;
      
    }
    
  }
  
  function bmi_config_random_string($max = 16) {

    $bank = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $bank .= 'abcdefghijklmnopqrstuvwxyz';
    $bank .= '0123456789';

    $str = str_shuffle($bank);

    while (is_numeric($str[0])) {
      $str = str_shuffle($bank);
    }

    $str = substr($str, 0, $max);

    return $str;

  }
  
  function bmi_render_default_config($bmi_initial_config_filepath, $bmi_initial_config_dirpath) {
    
    if (!file_exists(dirname($bmi_initial_config_filepath)) && !is_dir(dirname($bmi_initial_config_filepath))) {
      @mkdir(dirname($bmi_initial_config_filepath), 0755, true);
    }

    @copy(BMI_CONFIG_DEFAULT, $bmi_initial_config_filepath);
    bmi_try_convert_old_to_new_config($bmi_initial_config_filepath, $bmi_initial_config_dirpath);
    
    if (!defined('BMI_CONFIG_STATUS')) define('BMI_CONFIG_STATUS', true);
    if (!defined('BMI_CONFIG_PATH')) define('BMI_CONFIG_PATH', $bmi_initial_config_filepath);
    if (!defined('BMI_CONFIG_DIR')) define('BMI_CONFIG_DIR', dirname($bmi_initial_config_filepath));
    
  }

  $bmi_initial_config_filepath = WP_CONTENT_DIR . DIRECTORY_SEPARATOR . 'backup-migration' . DIRECTORY_SEPARATOR . 'config.json';
  $bmi_initial_config_dirpath = dirname($bmi_initial_config_filepath);
  $bmi_database_config_dirpath = get_option('BMI::STORAGE::LOCAL::PATH', false);

  if ($bmi_database_config_dirpath != false && dirname($bmi_database_config_dirpath) != $bmi_initial_config_dirpath) {
    $bmi_initial_config_filepath = $bmi_database_config_dirpath . DIRECTORY_SEPARATOR . 'config.json';
    $bmi_initial_config_dirpath = dirname($bmi_initial_config_filepath);
  }

  // Get config and parse it
  if (file_exists(BMI_STATIC_PHP_CONFIG)) {
    
    $bmi_php_config = bmi_try_convert_old_to_new_config($bmi_initial_config_filepath, $bmi_initial_config_dirpath);
    
  } elseif (file_exists($bmi_initial_config_filepath)) {
    
    // Convert config
    $bmi_php_config = bmi_try_convert_old_to_new_config($bmi_initial_config_filepath, $bmi_initial_config_dirpath);

    // Get file contents
    $bmi_config_contents = file_get_contents($bmi_initial_config_filepath);
    if (defined('BMI_CONFIG_PHP') && BMI_CONFIG_PHP) {
      $bmi_config_contents = substr($bmi_config_contents, 8);
    }
    
    $bmi_config_json = json_decode($bmi_config_contents);

    // If config is correct set it
    if (json_last_error() == JSON_ERROR_NONE) {
      
      $localStoragePath = BMI_BACKUPS_ROOT;
      if ($bmi_database_config_dirpath == false || $bmi_database_config_dirpath != $localStoragePath) {
        $prev_path = dirname(BMI_INITIAL_CONFIG_PATH);
        $prev_path_backups = dirname(BMI_INITIAL_CONFIG_PATH) . DIRECTORY_SEPARATOR . 'backups';

        if (file_exists($prev_path_backups) && is_dir($prev_path_backups)) {
          $scanned_directory_backups = array_diff(scandir($prev_path_backups), ['..', '.']);
          foreach ($scanned_directory_backups as $i => $file) {
            if (file_exists($prev_path . DIRECTORY_SEPARATOR . $file) && !is_dir($prev_path . DIRECTORY_SEPARATOR . $file)) {
              rename($prev_path . DIRECTORY_SEPARATOR . $file, $localStoragePath . DIRECTORY_SEPARATOR . $file);
            }
          }
          if ($prev_path != $localStoragePath && sizeof(scandir($prev_path_backups)) <= 2) {
            @rmdir($prev_path_backups);
          }
        }

        if (file_exists($prev_path) && is_dir($prev_path)) {
          $scanned_directory = array_diff(scandir($prev_path), ['..', '.']);
          foreach ($scanned_directory as $i => $file) {
            if (file_exists($prev_path . DIRECTORY_SEPARATOR . $file) && !is_dir($prev_path . DIRECTORY_SEPARATOR . $file)) {
              rename($prev_path . DIRECTORY_SEPARATOR . $file, $localStoragePath . DIRECTORY_SEPARATOR . $file);
            }
          }
          if ($localStoragePath != $prev_path && sizeof(scandir($prev_path)) <= 2) { 
            @rmdir($prev_path);
          }
        }

        update_option('BMI::STORAGE::LOCAL::PATH', $localStoragePath);
      }

    } else bmi_render_default_config($bmi_initial_config_filepath, $bmi_initial_config_dirpath);

  } else bmi_render_default_config($bmi_initial_config_filepath, $bmi_initial_config_dirpath);
