<?php

  // Namespace
  namespace BMI\Plugin\Dashboard;

  // Exit on direct access
  if (!defined('ABSPATH')) exit;
  
  $bmiGDriveBackupTooltip = 'Google Drive';
  if (!defined('BMI_PRO_INC')) {
    $bmiGDriveBackupTooltip = __('%sNever lose a backup by also saving it on Google Drive!%s%sUpgrade to %sPremium%s today%s%s%sWe made it really affordable!%s', 'backup-backup');
    $bmiGDriveBackupTooltip = sprintf($bmiGDriveBackupTooltip, '<div class="bmi-center-text">', '<br>', '<a href="' . BMI_AUTHOR_URI . '" target="_blank">', '<span class="bmi-premium-bg-stars">', '</span>', '</a>', '<br>', '<b>', '</b>', '</div>');
  }

?>

<table>
  <tr class="br_tr_template">
    <td>
      <label class="br_label" for="">
        <input class="br_checkbox" id="" type="checkbox">
        <span class="br_date">---</span>
      </label>
    </td>
    <td class="br_name tooltip-html" tooltip="example.com" data-top="5">---</td>
    <td class="br_size">---</td>
    <td class="br_stroage center">
      <div class="cf<?php echo (defined('BMI_PRO_INC')) ? ' br_wrapper_storage' : '' ?>">
        <div<?php echo (defined('BMI_PRO_INC')) ? ' class="left"' : '' ?>>

          <svg class="list-storage-img strg-local tooltip" tooltip="<?php _e('Local Storage', 'backup-backup') ?>" data-top="5">
            <use xlink:href="<?php echo $this->get_asset('images', 'local-server-2.svg#img') ?>"></use>
          </svg>

          <svg class="list-storage-img strg-gdrive tooltip-html" tooltip="<?php echo esc_attr( $bmiGDriveBackupTooltip ); ?>" data-top="5">
            <use xlink:href="<?php echo $this->get_asset('images', 'google-drive-mono.svg#img') ?>"></use>
          </svg>

        </div>
        <?php if (defined('BMI_PRO_INC')): ?>
        <div class="right">

          <svg class="list-storage-img strg-suc tooltip" tooltip="<?php _e('Backup is stored on: Google Drive & Local Storage.', 'backup-backup') ?>" data-top="5">
            <use xlink:href="<?php echo $this->get_asset('images', 'list-success.svg#img') ?>"></use>
          </svg>

          <svg class="list-storage-img strg-warn img-red tooltip" tooltip="<?php _e('There was an error during upload to: Google Drive.', 'backup-backup') ?>" data-top="5" style="display: none;">
            <use xlink:href="<?php echo $this->get_asset('images', 'list-warning.svg#img') ?>"></use>
          </svg>

          <svg class="list-storage-img strg-ong ongoing tooltip" tooltip="<?php _e('Upload to Google Drive in progress:', 'backup-backup') ?>" data-top="5" style="display: none;">
            <use xlink:href="<?php echo $this->get_asset('images', 'list-ongoing.svg#img') ?>"></use>
          </svg>

          <svg class="list-storage-img strg-wait tooltip" tooltip="<?php _e('Backup is queued for upload.', 'backup-backup') ?>" data-top="5" style="display: none;">
            <use xlink:href="<?php echo $this->get_asset('images', 'list-waiting.svg#img') ?>"></use>
          </svg>

        </div>
      </div>
      <?php endif; ?>
    </td>
    <td class="center">
      <div class="brow_lock">
        <img class="tooltip bc-unlocked-btn hoverable" tooltip="<?php _e('Lock backup files', 'backup-backup') ?>" src="<?php echo $this->get_asset('images', 'unlocked-min.svg'); ?>" alt="image">
        <img class="tooltip bc-locked-btn hoverable" tooltip="<?php _e('Unlock backup files', 'backup-backup') ?>" src="<?php echo $this->get_asset('images', 'lock-min.svg'); ?>" alt="image">
      </div>
    </td>
    <td>
      <div class="brow_subactions">
        <a href="#" class="bc-download-btn hoverable nodec untab" tabindex="-1" download>
          <img class="tooltip" tooltip="<?php _e('Download the backup file. Click on it downloads it', 'backup-backup') ?>" src="<?php echo $this->get_asset('images', 'download-min.png'); ?>" alt="image">
        </a>
        <img class="tooltip bc-url-btn hoverable untab" tabindex="-1" tooltip="<?php _e('Copy link to backup file for super-quick migration', 'backup-backup') ?>" src="<?php echo $this->get_asset('images', 'link-min.png'); ?>" alt="image">
        <a href="#" class="bc-logs-btn hoverable nodec untab" tabindex="-1" download>
          <img class="tooltip" tooltip="<?php _e('Download log file which was created at time of backup', 'backup-backup') ?>" src="<?php echo $this->get_asset('images', 'log-min.svg'); ?>" alt="image">
        </a>
      </div>
    </td>
    <td>
      <div class="stg-restore-btn hoverable tooltip-html" tooltip="<?php _e('Spin up a staging site with this backup.<br />Click on it to learn more.', 'backup-backup') ?>">
        <img src="<?php echo $this->get_asset('images', 'stg-restore-btn.svg'); ?>" width="12px" alt="image">
        <?php _e('Staging', 'backup-backup') ?>
      </div>
      <div class="restore-btn hoverable tooltip" tooltip="<?php _e('Restore this backup on this site', 'backup-backup') ?>">
        <img src="<?php echo $this->get_asset('images', 'restore-min.svg'); ?>" width="12px" alt="image">
        <?php _e('Restore', 'backup-backup') ?>
      </div>
    </td>
    <td><img class="tooltip bc-remove-btn hoverable" tooltip="<?php _e('Delete this backup', 'backup-backup') ?>" src="<?php echo $this->get_asset('images', 'red-close-min.svg'); ?>" alt="image"></td>
  </tr>
</table>
