<?php

function course2_shortcode($atts, $content = null ) {
    extract( shortcode_atts( array(
		'title' => '',
		'course' => '',
    ), $atts ) );
	if(!empty($atts['course'])) {
	    $course = vc_param_group_parse_atts( $atts['course'] );
	} else { $course = ''; }
    
    ob_start();
?>
		<div class="course course_theme_bgi">
			<div class="container">
                <?php if($title != "") { ?>
				<h2 class="title course__title">
					<span class="title__mark"><?php echo $title; ?></span>
				</h2>
                <?php } if($content != "") { ?>
				<p class="desc course__desc"><?php echo $content; ?></p>
                <?php } if(!empty($course)) {  ?>
				<div class="course__slider">
                    <?php 
				    $ac1 = 0; foreach ( $course as $c_value ) { $ac1++;
					if(!empty($c_value['picture'])) {
						    $picture = wp_get_attachment_image_src($c_value['picture'],'full', true);
					} else { $picture[0] = ''; $form_picture[0] = ''; }
					if(!empty($c_value['pictureform'])) {
							$form_picture = wp_get_attachment_image_src($c_value['pictureform'],'drivingschool_about-thumb', true);
					} else { $form_picture[0] = ''; }
					if(!empty($c_value['form_icon'])) {
						    $form_icon = wp_get_attachment_image_src($c_value['form_icon'],'full', true);
					} else { $form_icon[0] = ''; }
					if(!empty($c_value['texts'] )) { 
					    $texts = vc_param_group_parse_atts( $c_value['texts'] );
					} else { $texts = ''; }
				    ?>
					<div class="course__slider-item<?php if($ac1==1) { echo " active"; } ?>">
						<div style="background-image:url(<?php echo $picture[0]; ?>)" class="course__slider-item-before"></div>
						<div class="row">
							<div class="course__card col-md-9">
								<div class="card">
									<div class="card__head">
										<h3 class="card__name"><?php if(!empty($c_value['name'])) { echo $c_value['name']; } ?></h3>
										<div class="card__period"><?php if(!empty($c_value['duration'])) { echo $c_value['duration']; } ?></div>
									</div>
									<div class="card__body">
                                        <?php if(!empty($texts)) {  ?>
										<ul class="card__feature">
                                            <?php  foreach ( $texts as $t_value ) { ?>
											 <?php if(!empty($t_value['text'])) { ?><li class="card__feature-item"><?php  echo $t_value['text']; ?></li><?php } ?>
                                            <?php } ?>
										</ul>
                                        <?php } ?>
									</div>
									<div class="card__footer">
										<div class="row">
											<div class="card__price col-md-6">
                                                <?php if(!empty($c_value['automatic'])) { ?>
												<div class="card__price-item">
													<span class="card__price-value"><?php echo $c_value['automatic']; ?> </span><?php esc_html_e('Automatic', 'drivingschool-plugin'); ?></div>
                                                <?php } if(!empty($c_value['mechanics'])) { ?>
												<div class="card__price-item">
													<span class="card__price-value"><?php echo $c_value['mechanics']; ?> </span><?php esc_html_e('Mechanics', 'drivingschool-plugin'); ?></div>
                                                <?php }  ?>
											</div>
											<div class="card__btn-wrap col-md-6">
                                                <?php if($c_value['form'] != 'no') {   ?>
												<a class="btn card__btn popup-protect-btn" href="#">
													<span class="btn__text"><?php esc_html_e('buy now', 'drivingschool-plugin'); ?></span>
                                                    <div class="data-form" data-title="<?php if(!empty($c_value['name'])) { echo $c_value['name']; } ?>" data-duration="<?php if(!empty($c_value['duration'])) { echo $c_value['duration']; } ?>" data-icon="<?php echo $form_icon[0]; ?>" data-img="<?php echo esc_url($form_picture[0]); ?>"> </div>
												</a>
                                                <?php if(!empty($texts)) {  ?>
                                                   <ul class="data-form form-li"> 
                                                   <?php  foreach ( $texts as $t_value ) { ?>
                                                       <?php if(!empty($t_value['text'])) { ?><li class="popup_protect__list-item"><?php  echo $t_value['text']; ?></li><?php } ?>
                                                   <?php } ?> 
                                                   </ul>
                                                <?php } ?> 
                                                <?php } ?> 
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
                    <?php }  ?>                   
			</div>
            <?php }  if(!empty($course)) { ?>
			<div class="filter course__filter">
                <?php  $ac2 = 0; foreach ( $course as $c_value ) { $ac2++; ?>
				<span class="filter__item<?php if($ac2==1) { echo " filter__item_active"; } ?>">
					<span class="filter__item-text"><?php if(!empty($c_value['name'])) { echo $c_value['name']; } ?></span>
				</span>
                 <?php }  ?>
			</div>
            <?php }  ?>
		</div>
		</div>
        <?php drivingschool_form_course(); ?>
<?php
    $output = ob_get_contents();
	ob_end_clean();
	return $output;
}

add_shortcode('course2', 'course2_shortcode');
add_action( 'vc_before_init', 'course2_integrateWithVC' );
function course2_integrateWithVC() {
    vc_map( array(
        "name" => esc_html__("Course 2","drivingschool-plugin"),
        "base" => "course2",
        "category" => esc_html__('Shortcodes "DrivingSchool"','drivingschool-plugin'),
        "params" => array(
		     array(
                "type" => "",
                "heading" => '<a target="_blank" href="'.esc_url( home_url() ).'/wp-content/plugins/drivingschool-plugin/composer/scrin/s14.png">'.esc_html__('Аppearance of block','drivingschool-plugin').'</a>',
                "param_name" => "scrin_vot",
                "value" => ""
             ),
			 array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Title","drivingschool-plugin"),
                "param_name" => "title",
                "value" => ""
            ),
			array(
                "type" => "textarea",
                "class" => "",
                "heading" => esc_html__("Text","drivingschool-plugin"),
                "param_name" => "content",
                "value" => ""
            ),
			array(
                'type' => 'param_group',
                'value' => '',
			    'heading' => esc_html__("Course","drivingschool-plugin"),
                'param_name' => 'course',
                'params' => array(
					array(
                        "type" => "textfield",
                        "class" => "",
                        "heading" => esc_html__("Name","drivingschool-plugin"),
                        "param_name" => "name",
                        "value" => ""
                   ),
				   array(
                        "type" => "textfield",
                        "class" => "",
                        "heading" => esc_html__("Automatic","drivingschool-plugin"),
                        "param_name" => "automatic",
                        "value" => ""
                   ),
				   array(
                        "type" => "textfield",
                        "class" => "",
                        "heading" => esc_html__("Mechanics","drivingschool-plugin"),
                        "param_name" => "mechanics",
                        "value" => ""
                   ),
				   array(
                        "type" => "textfield",
                        "class" => "",
                        "heading" => esc_html__("Duration","drivingschool-plugin"),
                        "param_name" => "duration",
                        "value" => ""
                   ),
				   array(
                       "type" => "dropdown",
                       "class" => "",
                       "heading" => esc_html__("Form","drivingschool-plugin"),
                       "param_name" => "form",
                       "value" => array(
				           "yes" => "Yes",
					       "no" => "No",
				       )
                   ),
				   array(
                      'type' => 'param_group',
                      'value' => '',
			          'heading' => esc_html__("Texts","drivingschool-plugin"),
                      'param_name' => 'texts',
                      'params' => array(
					       array(
                               "type" => "textfield",
                               "class" => "",
                               "heading" => esc_html__("Text","drivingschool-plugin"),
                               "param_name" => "text",
                               "value" => ""
                           ),
			           )
                   ),
				   array(
                     'type' => 'attach_image',
                     'value' => '',
                     'heading' => esc_html__("Picture","drivingschool-plugin"),
                     'param_name' => 'picture',
                  ),
				  array(
                     'type' => 'attach_image',
                     'value' => '',
                     'heading' => esc_html__("Picture - Form","drivingschool-plugin"),
                     'param_name' => 'pictureform',
                  ),
				  array(
                     'type' => 'attach_image',
                     'value' => '',
                     'heading' => esc_html__("Form icon","drivingschool-plugin"),
                     'param_name' => 'form_icon',
                  ),
					
			    )
            ),	

        )
    ));
}

?>