<?php

function gallery1_shortcode($atts, $content = null ) {
    extract( shortcode_atts( array(
		'title1' => '',
		'title2' => '',
		'picture' => '',
		'filter' => '',
    ), $atts ) );
	$thumb_url = wp_get_attachment_image_src($picture,'full', true);
	if(!empty($atts['filter'])) {
	$filter = vc_param_group_parse_atts( $atts['filter'] );
	 } else { $filter = ''; }
	 if(!empty($atts['images'])) {
	$images = vc_param_group_parse_atts( $atts['images'] );
	 } else { $images = ''; }
    
    ob_start();
	
?>
		<div class="gallery">
			<div class="gallery__container container"<?php if($picture != '') { ?>  style="background: url(<?php echo $thumb_url[0]; ?>) 0 0 no-repeat;"<?php } ?>>
                <?php if($title1 != "" or $title2 != "") { ?><h2 class="title gallery__title"><?php if($title1 != "") { ?><span class="title__mark"><?php echo $title1; ?> </span><?php  } echo $title2; ?></h2>
                <?php } if($content != "") { ?>
				<p class="desc"><?php echo $content; ?></p>
               <?php } ?>
          <?php if(!empty($filter)) {  ?>
		  <div class="filter gallery__filter">
					<span data-filter=".gallery__list-item" class="filter__item filter__item_active">
						<span class="filter__item-text">All</span>
					</span>
                    <?php  foreach ( $filter as $f_value ) { ?>
                    <?php if(!empty($f_value['name'])) { ?>
					<span data-filter=".gallery__list-item_<?php echo esc_html(str_replace(array(' ',',','.','-'), '', $f_value['name'])); ?>" class="filter__item">
						<span class="filter__item-text"><?php echo $f_value['name']; ?></span>
					</span>
                    <?php } } ?>
			</div>
            <?php } if(!empty($images)) { ?>
			<div class="gallery__list row">
                <?php  
				    foreach ( $images as $i_value ) { 
					if(!empty($i_value['picture'])) {
						$picture_thumb = wp_get_attachment_image_src($i_value['picture'],'drivingschool_about-thumb', true);
						$picture_full = wp_get_attachment_image_src($i_value['picture'],'full', true);
				?>
				<div class="gallery__list-item gallery__list-item_<?php if(!empty($i_value['name'])) {  echo esc_html(str_replace(array(' ',',','.','-'), '', $i_value['name'])); } ?> col-xs-6 col-md-3">
					<figure class="gallery__fig">
						<a href="<?php echo $picture_full[0]; ?>" class="gallery__fig-link">
							<img src="<?php echo $picture_thumb[0]; ?>" alt="<?php if(!empty($i_value['name'])) { echo $i_value['name']; } ?>" />
						</a>
					</figure>
				</div>
                <?php } } ?> 
			</div>
            <?php }  ?>
		</div>
		</div>
<?php
    $output = ob_get_contents();
	ob_end_clean();
	return $output;
}

add_shortcode('gallery1', 'gallery1_shortcode');
add_action( 'vc_before_init', 'gallery1_integrateWithVC' );
function gallery1_integrateWithVC() {
    vc_map( array(
        "name" => esc_html__("Gallery","drivingschool-plugin"),
        "base" => "gallery1",
        "category" => esc_html__('Shortcodes "DrivingSchool"','drivingschool-plugin'),
        "params" => array(
		     array(
                "type" => "",
                "heading" => '<a target="_blank" href="'.esc_url( home_url() ).'/wp-content/plugins/drivingschool-plugin/composer/scrin/s9.png">'.esc_html__('Аppearance of block','drivingschool-plugin').'</a>',
                "param_name" => "scrin_vot",
                "value" => ""
             ),
			 array(
                 'type' => 'attach_image',
                 'value' => '',
                 'heading' => esc_html__("Background picture","drivingschool-plugin"),
                 'param_name' => 'picture',
             ),
			 array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Title 1","drivingschool-plugin"),
                "param_name" => "title1",
                "value" => ""
            ),
			 array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Title 2","drivingschool-plugin"),
                "param_name" => "title2",
                "value" => ""
            ),
			array(
                "type" => "textarea",
                "class" => "",
                "heading" => esc_html__("Text","drivingschool-plugin"),
                "param_name" => "content",
                "value" => ""
            ),
			array(
                'type' => 'param_group',
                'value' => '',
			    'heading' => esc_html__("Filter","drivingschool-plugin"),
                'param_name' => 'filter',
                'params' => array(
					array(
                        "type" => "textfield",
                        "class" => "",
                        "heading" => esc_html__("Name","drivingschool-plugin"),
                        "param_name" => "name",
                        "value" => ""
                   ),

			    )
            ),	
			array(
                'type' => 'param_group',
                'value' => '',
			    'heading' => esc_html__("Images","drivingschool-plugin"),
                'param_name' => 'images',
                'params' => array(
					array(
                        "type" => "textfield",
                        "class" => "",
                        "heading" => esc_html__("Name filter","drivingschool-plugin"),
                        "param_name" => "name",
                        "value" => ""
                   ),
				   array(
                       'type' => 'attach_image',
                       'value' => '',
                       'heading' => esc_html__("Picture","drivingschool-plugin"),
                       'param_name' => 'picture',
                   ),

			    )
            ),	

        )
    ));
}

?>