<?php

function price1_shortcode($atts, $content = null ) {
   
	extract( shortcode_atts( array(
	    'title' => '',
		'text' => '',
		'picture' => '',
		'name1' => '',
		'price1' => '',
		'discount1' => '',
		'description1' => '',
		'name2' => '',
		'price2' => '',
		'discount2' => '',
		'description2' => '',
		'name3' => '',
		'price3' => '',
		'discount3' => '',
		'description3' => '',
		'name4' => '',
		'price4' => '',
		'discount4' => '',
		'description4' => '',
    ), $atts ) );
	$thumb_url = wp_get_attachment_image_src($picture,'full', true);
	if(!empty($atts['description1'])) {
	$description1 = vc_param_group_parse_atts( $atts['description1'] );
	} else { $description1= ''; }
	if(!empty($atts['description2'])) {
	$description2 = vc_param_group_parse_atts( $atts['description2'] );
	} else { $description2 = ''; }
	if(!empty($atts['description3'])) {
	$description3 = vc_param_group_parse_atts( $atts['description3'] );
	} else { $description3 = ''; }
	if(!empty($atts['description4'])) {
	$description4 = vc_param_group_parse_atts( $atts['description4'] );
	} else { $description4 = ''; }
	
	$best = 2;
	if( isset( $atts['best'] ) ) {
		$best = $atts['best'];
	}
	$cols = 3;
	if( isset( $atts['cols'] ) ) {
		$cols = $atts['cols'];
	}

	$prices_arr = [];
	for ($i = 1; $i <= 4; $i++) {
		if( isset( $atts['name' . $i ] ) && $atts['name' . $i ] ) {
			$name        = $atts['name' . $i ];
			$price       = '';
			$discount    = '';
			$description = '';
			if( isset( $atts['price' . $i ] ) ) {
				$price = $atts['price' . $i ];
			}
			if( isset( $atts['discount' . $i ] ) ) {
				$discount = $atts['discount' . $i ];
			}
			if( isset( $atts['description' . $i ] ) ) {
				$description = vc_param_group_parse_atts( $atts['description' . $i ] );
			}
			$prices_arr[] = array(
				'order'       => $i,
				'name'        => $name,
				'price'       => $price,
				'discount'    => $discount,
				'description' => $description,
			);
		}
	}

    ob_start();
?>
		<div class="price price_index"<?php if($picture != '') { ?> style="background: #f9fafb url(<?php echo $thumb_url[0]; ?>) bottom no-repeat;"<?php } ?>>
			<div class="container">
                <?php if($title != "") { ?>
				<h2 class="title price__title">
					<span class="title__mark"><?php echo $title; ?></span>
				</h2>
                <?php } ?>
				<?php if($text != "") { ?>
					<p class="desc"><?php echo $text; ?></p>
				<?php } ?>
				<div class="price-table">
					<div class="price-table__list row">
						<?php if( $prices_arr ) { ?>
							<?php foreach( $prices_arr as $item ) {?>
								<?php 
								$col_class = 'col-md-4';
								$item_class = 'price-table__item';
								$data_active = 'no';
								if ( $best == $item['order'] ) {
									$item_class .= ' price-table__item_best';
									$data_active = 'yes';
								}
								if ( $cols == 1 ) {
									$col_class = 'col-md-12';
								} else if ( $cols == 2 ) {
									$col_class = 'col-md-6';
								} else if ( $cols == 3 ) {
									$col_class = 'col-md-4';
								} else if ( $cols == 4 ) {
									$col_class = 'col-lg-3 col-sm-6';
								}
						
								?>
								<div class="<?php echo esc_attr($col_class);?>">
									<div class="<?php echo esc_attr( $item_class );?>">
										<?php if ( $best == $item['order'] ) {?>
											<div class="price-table__best">
												<svg class="price-table__star"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_star"></use></svg> <?php esc_html_e('bestsellers', 'drivingschool-plugin'); ?>
												<svg class="price-table__star"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_star"></use></svg>
											</div>
										<?php } ?>
										<div class="price-table__value"><?php echo $item['price']; if( $item['discount'] ) { ?> <span class="price-table__discount"><?php echo $item['discount']; ?></span><?php } ?></div>
										<h3 class="price-table__name"><?php echo $item['name']; ?></h3>
										<?php if( ! empty( $item['description'] ) ) {  ?>
											<ul class="price-table__feature-list">
												<?php foreach ( $item['description'] as $desc ) {
												if( ! empty( $desc['text'] ) ) { ?>
													<li class="price-table__feature-item"><?php echo $desc['text'];?></li>
												<?php } } ?>
											</ul>
										<?php } ?>
										<a class="btn price-table__btn popup-bestsellers-btn" href="#">
											<span class="btn__text"><?php esc_html_e('send request', 'drivingschool-plugin'); ?></span>
											<div class="data-form" data-price="<?php echo $item['price']; ?>" data-name="<?php echo $item['name']; ?>" data-active="<?php echo esc_attr($data_active);?>"> </div>
										</a>
										<?php if ( $best == $item['order'] ) {?>
											<div class="price-table__stars">
												<svg class="price-table__star"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_star"></use></svg>
												<svg class="price-table__star"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_star"></use></svg>
												<svg class="price-table__star"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_star"></use></svg>
											</div>
										<?php } ?>
									</div>
								</div>
							<?php } ?>
						<?php } ?>
						
						
						<?php /*
						<?php if($name1 != '') { ?> 
						<div class="col-md-4">
							<div class="price-table__item">
								<div class="price-table__value"><?php echo $price1; if($discount1 != '') { ?> <span class="price-table__discount"><?php echo $discount1; ?></span><?php } ?></div>
								<h3 class="price-table__name"><?php echo $name1; ?></h3>
                                <?php if(!empty($description1)) {  ?>
								<ul class="price-table__feature-list">
                                    <?php  foreach ( $description1 as $d1_value ) { if(!empty($d1_value['text'])) { ?>
									<li class="price-table__feature-item"><?php echo $d1_value['text'];?></li>
                                    <?php }} ?>
								</ul>
                                <?php } ?>
								<a class="btn price-table__btn popup-bestsellers-btn" href="#">
									<span class="btn__text"><?php esc_html_e('send request', 'drivingschool-plugin'); ?></span>
                                    <div class="data-form" data-price="<?php echo $price1; ?>" data-name="<?php echo $name1; ?>" data-active="no"> </div>
								</a>
							</div>
						</div>
                        <?php } if($name2 != '') { ?>
						<div class="col-md-4">
							<div class="price-table__item price-table__item_best">
								<div class="price-table__best">
									<svg class="price-table__star"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_star"></use></svg> <?php esc_html_e('bestsellers', 'drivingschool-plugin'); ?>
									<svg class="price-table__star"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_star"></use></svg>
								</div>
								<div class="price-table__value"><?php echo $price2; if($discount2 != '') { ?> <span class="price-table__discount"><?php echo $discount2; ?></span><?php } ?></div>
								<h3 class="price-table__name"><?php echo $name2; ?></h3>
                                <?php if(!empty($description2)) {  ?>
								<ul class="price-table__feature-list">
                                    <?php  foreach ( $description2 as $d2_value ) { if(!empty($d2_value['text'])) { ?>
									<li class="price-table__feature-item"><?php echo $d2_value['text'];?></li>
                                    <?php }} ?>
								</ul>
                                <?php } ?>
								<a class="btn price-table__btn popup-bestsellers-btn" href="#">
									<span class="btn__text"><?php esc_html_e('send request', 'drivingschool-plugin'); ?></span>
                                    <div class="data-form" data-price="<?php echo $price2; ?>" data-name="<?php echo $name2; ?>" data-active="yes"> </div>
								</a>
								<div class="price-table__stars">
									<svg class="price-table__star"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_star"></use></svg>
									<svg class="price-table__star"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_star"></use></svg>
									<svg class="price-table__star"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_star"></use></svg>
								</div>
							</div>
						</div>
                        <?php } if($name3 != '') { ?>
						<div class="col-md-4">
							<div class="price-table__item">
								<div class="price-table__value"><?php echo $price3; if($discount3 != '') { ?> <span class="price-table__discount"><?php echo $discount3; ?></span><?php } ?></div>
								<h3 class="price-table__name"><?php echo $name3; ?></h3>
                                <?php if(!empty($description3)) {  ?>
								<ul class="price-table__feature-list">
                                    <?php  foreach ( $description3 as $d3_value ) { if(!empty($d3_value['text'])) { ?>
									<li class="price-table__feature-item"><?php echo $d3_value['text'];?></li>
                                    <?php }} ?>
								</ul>
                                <?php } ?>
								<a class="btn price-table__btn popup-bestsellers-btn" href="#">
									<span class="btn__text"><?php esc_html_e('send request', 'drivingschool-plugin'); ?></span>
                                    <div class="data-form" data-price="<?php echo $price3; ?>" data-name="<?php echo $name3; ?>" data-active="no"> </div>
								</a>
							</div>
						</div>
						<?php } if($name4 != '') { ?>
						<div class="col-md-4">
							<div class="price-table__item">
								<div class="price-table__value"><?php echo $price4; if($discount4 != '') { ?> <span class="price-table__discount"><?php echo $discount4; ?></span><?php } ?></div>
								<h3 class="price-table__name"><?php echo $name4; ?></h3>
                                <?php if(!empty($description4)) {  ?>
								<ul class="price-table__feature-list">
                                    <?php  foreach ( $description4 as $d4_value ) { if(!empty($d4_value['text'])) { ?>
									<li class="price-table__feature-item"><?php echo $d4_value['text'];?></li>
                                    <?php }} ?>
								</ul>
                                <?php } ?>
								<a class="btn price-table__btn popup-bestsellers-btn" href="#">
									<span class="btn__text"><?php esc_html_e('send request', 'drivingschool-plugin'); ?></span>
                                    <div class="data-form" data-price="<?php echo $price4; ?>" data-name="<?php echo $name4; ?>" data-active="no"> </div>
								</a>
							</div>
						</div>
                        <?php } ?>
						*/?>
					</div>
				</div>
			</div>
		</div>
        <?php if(function_exists("drivingschool_form_plan")) { drivingschool_form_plan(); } ?>
<?php
    $output = ob_get_contents();
	ob_end_clean();
	return $output;

}

add_shortcode('price1', 'price1_shortcode');
add_action( 'vc_before_init', 'price1_integrateWithVC' );
function price1_integrateWithVC() {
    vc_map( array(
        "name" => esc_html__("Price","drivingschool-plugin"),
        "base" => "price1",
        "category" => esc_html__('Shortcodes "DrivingSchool"','drivingschool-plugin'),
        "params" => array(
		     array(
                "type" => "",
                "heading" => '<a target="_blank" href="'.esc_url( home_url() ).'/wp-content/plugins/drivingschool-plugin/composer/scrin/s6.png">'.esc_html__('Аppearance of block','drivingschool-plugin').'</a>',
                "param_name" => "scrin_vot",
                "value" => ""
             ),
			 array(
                 'type' => 'attach_image',
                 'heading' => esc_html__("Background picture","drivingschool-plugin"),
                 'param_name' => 'picture',
             ),
			 array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Title","drivingschool-plugin"),
                "param_name" => "title",
                "value" => ""
            ),
			array(
                "type" => "textarea",
                "class" => "",
                "heading" => esc_html__("Text","drivingschool-plugin"),
                "param_name" => "text",
                "value" => ""
            ),
			array(
				'type'             => 'dropdown',
				'heading'          => esc_html__("Select best item","drivingschool-plugin"),
				'value'            => array(
					1,
					2,
					3,
					4
				),
				'param_name'       => 'best',
				'std'              => '2',
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'dropdown',
				'heading'          => esc_html__("Select columns count","drivingschool-plugin"),
				'value'            => array(
					1,
					2,
					3,
					4
				),
				'param_name'       => 'cols',
				'std'              => '3',
				'edit_field_class' => 'vc_col-sm-6',
			),
			// Price table 1
			array(
                'type' => '',
                'heading' => '<h2>' . esc_html__('Price Table 1','drivingschool-plugin') . '</h2>',
                'param_name' => 'heading_1',
				"holder" => "div",
  				"edit_field_class" => "vc_column-separator",
             ),
			array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Name 1","drivingschool-plugin"),
                "param_name" => "name1",
                "value" => ""
            ),
			array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Price 1","drivingschool-plugin"),
                "param_name" => "price1",
                "value" => ""
            ),
			array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Discount 1","drivingschool-plugin"),
                "param_name" => "discount1",
                "value" => ""
            ),
			 array(
                'type' => 'param_group',
                'value' => '',
			    'heading' => esc_html__("Description 1","drivingschool-plugin"),
                'param_name' => 'description1',
                'params' => array(
					array(
                        "type" => "textfield",
                        "class" => "",
                        "heading" => esc_html__("Text","drivingschool-plugin"),
                        "param_name" => "text",
                        "value" => ""
                   ),
			    )
            ),
			// Price table 2
			array(
                'type' => '',
                'heading' => '<h2>' . esc_html__('Price Table 2','drivingschool-plugin') . '</h2>',
                'param_name' => 'heading_2',
				"holder" => "div",
  				"edit_field_class" => "vc_column-separator",
             ),
			array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Name 2","drivingschool-plugin"),
                "param_name" => "name2",
                "value" => ""
            ),
			array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Price 2","drivingschool-plugin"),
                "param_name" => "price2",
                "value" => ""
            ),
			array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Discount 2","drivingschool-plugin"),
                "param_name" => "discount2",
                "value" => ""
            ),
			 array(
                'type' => 'param_group',
                'value' => '',
			    'heading' => esc_html__("Description 2","drivingschool-plugin"),
                'param_name' => 'description2',
                'params' => array(
					array(
                        "type" => "textfield",
                        "class" => "",
                        "heading" => esc_html__("Text","drivingschool-plugin"),
                        "param_name" => "text",
                        "value" => ""
                   ),
			    )
            ),
			// Price table 3
			array(
                'type' => '',
                'heading' => '<h2>' . esc_html__('Price Table 3','drivingschool-plugin') . '</h2>',
                'param_name' => 'heading_3',
				"holder" => "div",
  				"edit_field_class" => "vc_column-separator",
             ),
			array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Name 3","drivingschool-plugin"),
                "param_name" => "name3",
                "value" => ""
            ),
			array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Price 3","drivingschool-plugin"),
                "param_name" => "price3",
                "value" => ""
            ),
			array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Discount 3","drivingschool-plugin"),
                "param_name" => "discount3",
                "value" => ""
            ),
			 array(
                'type' => 'param_group',
                'value' => '',
			    'heading' => esc_html__("Description 3","drivingschool-plugin"),
                'param_name' => 'description3',
                'params' => array(
					array(
                        "type" => "textfield",
                        "class" => "",
                        "heading" => esc_html__("Text","drivingschool-plugin"),
                        "param_name" => "text",
                        "value" => ""
                   ),
			    )
            ),
			// Price table 4
			array(
                'type' => '',
                'heading' => '<h2>' . esc_html__('Price Table 4','drivingschool-plugin') . '</h2>',
                'param_name' => 'heading_4',
				"holder" => "div",
  				"edit_field_class" => "vc_column-separator",
             ),
			array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Name 4","drivingschool-plugin"),
                "param_name" => "name4",
                "value" => ""
            ),
			array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Price 4","drivingschool-plugin"),
                "param_name" => "price4",
                "value" => ""
            ),
			array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Discount 4","drivingschool-plugin"),
                "param_name" => "discount4",
                "value" => ""
            ),
			 array(
                'type' => 'param_group',
                'value' => '',
			    'heading' => esc_html__("Description 4","drivingschool-plugin"),
                'param_name' => 'description4',
                'params' => array(
					array(
                        "type" => "textfield",
                        "class" => "",
                        "heading" => esc_html__("Text","drivingschool-plugin"),
                        "param_name" => "text",
                        "value" => ""
                   ),
			    )
            ),

        )
    ));
}
