<?php

if ( !defined('ABSPATH') ) {
	require_once( dirname( __FILE__ ) . '/../../../wp-load.php' );
}

add_action( 'init', 'drivingschool_review' );
function drivingschool_review() {
register_post_type( 'review', array(
  'labels' => array(
    'name' => esc_html__("Reviews","drivingschool-plugin"),
    'singular_name' => 'review',
   ),
  'description' => esc_html__("Review","drivingschool-plugin"),
  'public' => true,
  'menu_icon' => 'dashicons-format-chat', 
  'menu_position' => 22,
  'supports' => array( 'title' ),
  'exclude_from_search' => false,
  'show_in_admin_bar'   => false,
  'show_in_nav_menus'   => false,
  'publicly_queryable'  => false,
  'query_var'           => false,
  'rewrite'             => array( "slug" => false )
));
}

/* Add count of pending reviews to menu */
function drivingschool_js_admin2(){
	$args = array(
		'post_type'      => 'review',
		'posts_per_page' => -1,
		'post_status'    => 'pending',
	);
	$st_query = new WP_Query( $args );
    
    $st = 0;
	if ( $st_query->have_posts() ) {
		$st = $st_query->post_count;
	}
	wp_reset_postdata();

	$status_script = 'jQuery(document).ready(function(jQuery){ 
		var countR = ' . $st . ';
		console.log(countR);
        jQuery(\'#menu-posts-review .wp-menu-name\').append(\' <span class="update-plugins count-\'+countR+\'"><span class="plugin-count">\'+countR+\'</span></span>\');
    });';

	wp_add_inline_script( 'jquery', $status_script );
}
add_action( 'admin_enqueue_scripts', 'drivingschool_js_admin2');


function drivingschool_settings_reviews_menu_item()
{
    add_submenu_page('edit.php?post_type=review',esc_html__("Reviews settings","drivingschool-plugin"),esc_html__("Reviews settings","drivingschool-plugin"), 'edit_theme_options', 'feedback_settings','drivingschool_feedback_settings_admin');
}
add_action('admin_menu', 'drivingschool_settings_reviews_menu_item');

function drivingschool_feedback_settings_admin()
{
    global $_POST;
	$ste = 0;
	if(isset($_POST['ste'])) {
		$ste = htmlspecialchars($_POST['ste']);
		set_theme_mod ('drivingschool_moderate_reviews', $ste);
	}
	if(get_theme_mod('drivingschool_moderate_reviews') == '') {
		set_theme_mod ('drivingschool_moderate_reviews', 'yes');
	}

?>
<div style="padding:20px;background-color:white;margin-bottom: 2px;margin-left: 15px;margin-right: 15px;margin-top: 5px;">
    <h2><?php esc_html_e('Feedback settings', 'drivingschool-plugin'); ?></h2>
    <form action="" method="post">
        <table border="0">
            <tbody>
                <tr> 
                    <td colspan="2">
                    <strong><?php esc_html_e('Moderate reviews:', 'drivingschool-plugin'); ?></strong>
                    <select style="width:50px;" name="ste">
                        <option <?php if(get_theme_mod('drivingschool_moderate_reviews') == 'yes') { ?>selected="selected"<?php } ?> value="yes"><?php esc_html_e('Yes', 'drivingschool-plugin'); ?></option>
                        <option <?php if(get_theme_mod('drivingschool_moderate_reviews') ==  'no') { ?>selected="selected"<?php } ?> value="no"><?php esc_html_e('No', 'drivingschool-plugin'); ?></option>
                    </select>
                    </td>
                </tr>
                <tr>
                    <td colspan="2">
                    <input type="submit" class='btn btn-primary primary' value="<?php esc_html_e('Update', 'drivingschool-plugin') ?>"/>
                    </td>
                </tr>
            </tbody>
        </table>
    </form>
</div>
<?php
}
?>