<?php


class OpeningHoursWidget extends WP_Widget {
	function __construct() {
		parent::__construct(
			'true_top_widget1', 
			esc_html__("Opening Hours","drivingschool-plugin"),
			array( 'description' => esc_html__("Opening Hours - Driving School","drivingschool-plugin") ) 
		);
	}
 
	public function widget( $args, $instance ) {
		$title = apply_filters( 'widget_title', $instance['title'] );
		if ( isset( $instance[ 'day1' ] ) ) { $day1 = $instance[ 'day1' ]; }
		if ( isset( $instance[ 'time1' ] ) ) { $time1 = $instance[ 'time1' ]; }
		if ( isset( $instance[ 'day2' ] ) ) { $day2 = $instance[ 'day2' ]; }
		if ( isset( $instance[ 'time2' ] ) ) { $time2 = $instance[ 'time2' ]; }
		if ( isset( $instance[ 'day3' ] ) ) { $day3 = $instance[ 'day3' ]; }
		if ( isset( $instance[ 'time3' ] ) ) { $time3 = $instance[ 'time3' ]; }
		if ( isset( $instance[ 'day4' ] ) ) { $day4 = $instance[ 'day4' ]; }
		if ( isset( $instance[ 'time4' ] ) ) { $time4 = $instance[ 'time4' ]; }
		if ( isset( $instance[ 'day5' ] ) ) { $day5 = $instance[ 'day5' ]; }
		if ( isset( $instance[ 'time5' ] ) ) { $time5 = $instance[ 'time5' ]; }
		if ( isset( $instance[ 'day6' ] ) ) { $day6 = $instance[ 'day6' ]; }
		if ( isset( $instance[ 'time6' ] ) ) { $time6 = $instance[ 'time6' ]; }
		if ( isset( $instance[ 'day7' ] ) ) { $day7 = $instance[ 'day7' ]; }
		if ( isset( $instance[ 'time7' ] ) ) { $time7 = $instance[ 'time7' ]; }
		
		echo $args['before_widget'];
		if ( ! empty( $title ) ) { echo $args['before_title'] . wp_kses_post( $title ) . $args['after_title']; };
		
		if( isset( $instance[ 'day1' ] )) {
		     echo '<div class="footer__hours-item">
			           <div class="footer__hours-day">'.$day1.'</div>
				       <div class="footer__hours-separ"></div>
				       <div class="footer__hours-time">'.$time1.'</div>
			       </div>';
		}
		if( isset( $instance[ 'day2' ] )) {
		     echo '<div class="footer__hours-item">
			           <div class="footer__hours-day">'.$day2.'</div>
				       <div class="footer__hours-separ"></div>
				       <div class="footer__hours-time">'.$time2.'</div>
			       </div>';
		}
		if( isset( $instance[ 'day3' ] )) {
		     echo '<div class="footer__hours-item">
			           <div class="footer__hours-day">'.$day3.'</div>
				       <div class="footer__hours-separ"></div>
				       <div class="footer__hours-time">'.$time3.'</div>
			       </div>';
		}
		if( isset( $instance[ 'day4' ] )) {
		     echo '<div class="footer__hours-item">
			           <div class="footer__hours-day">'.$day4.'</div>
				       <div class="footer__hours-separ"></div>
				       <div class="footer__hours-time">'.$time4.'</div>
			       </div>';
		}
		if( isset( $instance[ 'day5' ] )) {
		     echo '<div class="footer__hours-item">
			           <div class="footer__hours-day">'.$day5.'</div>
				       <div class="footer__hours-separ"></div>
				       <div class="footer__hours-time">'.$time5.'</div>
			       </div>';
		}
		if( isset( $instance[ 'day6' ] )) {
		     echo '<div class="footer__hours-item">
			           <div class="footer__hours-day">'.$day6.'</div>
				       <div class="footer__hours-separ"></div>
				       <div class="footer__hours-time">'.$time6.'</div>
			       </div>';
		}
		if( isset( $instance[ 'day7' ] )) {
		     echo '<div class="footer__hours-item">
			           <div class="footer__hours-day">'.$day7.'</div>
				       <div class="footer__hours-separ"></div>
				       <div class="footer__hours-time">'.$time7.'</div>
			       </div>';
		}
		
		echo $args['after_widget'];
					
	
	}
	public function form( $instance ) {
		if ( isset( $instance[ 'title' ] ) ) { $title = $instance[ 'title' ]; } else { $title = ''; }
		if ( isset( $instance[ 'day1' ] ) ) { $day1 = $instance[ 'day1' ]; } else { $day1 = ''; }
		if ( isset( $instance[ 'time1' ] ) ) { $time1 = $instance[ 'time1' ]; } else { $time1 = ''; }
		if ( isset( $instance[ 'day2' ] ) ) { $day2 = $instance[ 'day2' ]; } else { $day2 = ''; }
		if ( isset( $instance[ 'time2' ] ) ) { $time2 = $instance[ 'time2' ]; } else { $time2 = ''; }
		if ( isset( $instance[ 'day3' ] ) ) { $day3 = $instance[ 'day3' ]; } else { $day3 = ''; }
		if ( isset( $instance[ 'time3' ] ) ) { $time3 = $instance[ 'time3' ]; } else { $time3 = ''; }
		if ( isset( $instance[ 'day4' ] ) ) { $day4 = $instance[ 'day4' ]; } else { $day4 = ''; }
		if ( isset( $instance[ 'time4' ] ) ) { $time4 = $instance[ 'time4' ]; } else { $time4 = ''; }
		if ( isset( $instance[ 'day5' ] ) ) { $day5 = $instance[ 'day5' ]; } else { $day5 = ''; }
		if ( isset( $instance[ 'time5' ] ) ) { $time5 = $instance[ 'time5' ]; } else { $time5 = ''; }
		if ( isset( $instance[ 'day6' ] ) ) { $day6 = $instance[ 'day6' ]; } else { $day6 = ''; }
		if ( isset( $instance[ 'time6' ] ) ) { $time6 = $instance[ 'time6' ]; } else { $time6 = ''; }
		if ( isset( $instance[ 'day7' ] ) ) { $day7 = $instance[ 'day7' ]; } else { $day7 = ''; }
		if ( isset( $instance[ 'time7' ] ) ) { $time7 = $instance[ 'time7' ]; } else { $time7 = ''; }
		
		echo '<p><label for="'.$this->get_field_id( 'title' ).'">'.esc_html__("Title:","drivingschool-plugin").'</label>';
		echo '<input class="widefat" id="'.$this->get_field_id( 'title' ).'" name="'.$this->get_field_name( 'title' ).'" type="text" value="'.esc_attr( $title ).'" /></p>';
		
		echo '<input class="widefat" id="'.$this->get_field_id( 'day1' ).'" name="'.$this->get_field_name( 'day1' ).'" type="text" value="'.esc_attr( $day1 ).'" /></p>';
		echo '<p><label for="'.$this->get_field_id( 'time1' ).'">'.esc_html__("Time 1:","drivingschool-plugin").'</label>';
		echo '<input class="widefat" id="'.$this->get_field_id( 'time1' ).'" name="'.$this->get_field_name( 'time1' ).'" type="text" value="'.esc_attr( $time1 ).'" /></p>';
		echo '<p><label for="'.$this->get_field_id( 'day2' ).'">'.esc_html__("Day 2:","drivingschool-plugin").'</label>';
		echo '<input class="widefat" id="'.$this->get_field_id( 'day2' ).'" name="'.$this->get_field_name( 'day2' ).'" type="text" value="'.esc_attr( $day2 ).'" /></p>';
		echo '<p><label for="'.$this->get_field_id( 'time2' ).'">'.esc_html__("Time 2:","drivingschool-plugin").'</label>';
		echo '<input class="widefat" id="'.$this->get_field_id( 'time2' ).'" name="'.$this->get_field_name( 'time2' ).'" type="text" value="'.esc_attr( $time2 ).'" /></p>';
		echo '<p><label for="'.$this->get_field_id( 'day3' ).'">'.esc_html__("Day 3:","drivingschool-plugin").'</label>';
		echo '<input class="widefat" id="'.$this->get_field_id( 'day3' ).'" name="'.$this->get_field_name( 'day3' ).'" type="text" value="'.esc_attr( $day3 ).'" /></p>';
		echo '<p><label for="'.$this->get_field_id( 'time3' ).'">'.esc_html__("Time 3:","drivingschool-plugin").'</label>';
		echo '<input class="widefat" id="'.$this->get_field_id( 'time3' ).'" name="'.$this->get_field_name( 'time3' ).'" type="text" value="'.esc_attr( $time3 ).'" /></p>';
		echo '<p><label for="'.$this->get_field_id( 'day4' ).'">'.esc_html__("Day 4:","drivingschool-plugin").'</label>';
		echo '<input class="widefat" id="'.$this->get_field_id( 'day4' ).'" name="'.$this->get_field_name( 'day4' ).'" type="text" value="'.esc_attr( $day4 ).'" /></p>';
		echo '<p><label for="'.$this->get_field_id( 'time4' ).'">'.esc_html__("Time 4:","drivingschool-plugin").'</label>';
		echo '<input class="widefat" id="'.$this->get_field_id( 'time4' ).'" name="'.$this->get_field_name( 'time4' ).'" type="text" value="'.esc_attr( $time4 ).'" /></p>';
		echo '<p><label for="'.$this->get_field_id( 'day5' ).'">'.esc_html__("Day 5:","drivingschool-plugin").'</label>';
		echo '<input class="widefat" id="'.$this->get_field_id( 'day5' ).'" name="'.$this->get_field_name( 'day5' ).'" type="text" value="'.esc_attr( $day5 ).'" /></p>';
		echo '<p><label for="'.$this->get_field_id( 'time5' ).'">'.esc_html__("Time 5:","drivingschool-plugin").'</label>';
		echo '<input class="widefat" id="'.$this->get_field_id( 'time5' ).'" name="'.$this->get_field_name( 'time5' ).'" type="text" value="'.esc_attr( $time5 ).'" /></p>';
		echo '<p><label for="'.$this->get_field_id( 'day6' ).'">'.esc_html__("Day 6:","drivingschool-plugin").'</label>';
		echo '<input class="widefat" id="'.$this->get_field_id( 'day6' ).'" name="'.$this->get_field_name( 'day6' ).'" type="text" value="'.esc_attr( $day6 ).'" /></p>';
		echo '<p><label for="'.$this->get_field_id( 'time6' ).'">'.esc_html__("Time 6:","drivingschool-plugin").'</label>';
		echo '<input class="widefat" id="'.$this->get_field_id( 'time6' ).'" name="'.$this->get_field_name( 'time6' ).'" type="text" value="'.esc_attr( $time6 ).'" /></p>';
		echo '<p><label for="'.$this->get_field_id( 'day7' ).'">'.esc_html__("Day 7:","drivingschool-plugin").'</label>';
		echo '<input class="widefat" id="'.$this->get_field_id( 'day7' ).'" name="'.$this->get_field_name( 'day7' ).'" type="text" value="'.esc_attr( $day7 ).'" /></p>';
		echo '<p><label for="'.$this->get_field_id( 'time7' ).'">'.esc_html__("Time 7:","drivingschool-plugin").'</label>';
		echo '<input class="widefat" id="'.$this->get_field_id( 'time7' ).'" name="'.$this->get_field_name( 'time7' ).'" type="text" value="'.esc_attr( $time7 ).'" /></p>';
	}
	public function update( $new_instance, $old_instance ) {
	    $instance = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['day1'] = ( ! empty( $new_instance['day1'] ) ) ? strip_tags( $new_instance['day1'] ) : '';
		$instance['time1'] = ( ! empty( $new_instance['time1'] ) ) ? strip_tags( $new_instance['time1'] ) : '';
		$instance['day2'] = ( ! empty( $new_instance['day2'] ) ) ? strip_tags( $new_instance['day2'] ) : '';
		$instance['time2'] = ( ! empty( $new_instance['time2'] ) ) ? strip_tags( $new_instance['time2'] ) : '';
		$instance['day3'] = ( ! empty( $new_instance['day3'] ) ) ? strip_tags( $new_instance['day3'] ) : '';
		$instance['time3'] = ( ! empty( $new_instance['time3'] ) ) ? strip_tags( $new_instance['time3'] ) : '';
		$instance['day4'] = ( ! empty( $new_instance['day4'] ) ) ? strip_tags( $new_instance['day4'] ) : '';
		$instance['time4'] = ( ! empty( $new_instance['time4'] ) ) ? strip_tags( $new_instance['time4'] ) : '';
		$instance['day5'] = ( ! empty( $new_instance['day5'] ) ) ? strip_tags( $new_instance['day5'] ) : '';
		$instance['time5'] = ( ! empty( $new_instance['time5'] ) ) ? strip_tags( $new_instance['time5'] ) : '';
		$instance['day6'] = ( ! empty( $new_instance['day6'] ) ) ? strip_tags( $new_instance['day6'] ) : '';
		$instance['time6'] = ( ! empty( $new_instance['time6'] ) ) ? strip_tags( $new_instance['time6'] ) : '';
		$instance['day7'] = ( ! empty( $new_instance['day7'] ) ) ? strip_tags( $new_instance['day7'] ) : '';
		$instance['time7'] = ( ! empty( $new_instance['time7'] ) ) ? strip_tags( $new_instance['time7'] ) : '';
		return $instance;
	}
}


class CategoriesWidget extends WP_Widget {
	function __construct() {
		parent::__construct(
			'true_top_widget2', 
			esc_html__("Categories","drivingschool-plugin"),
			array( 'description' => esc_html__("Categories - Driving School","drivingschool-plugin") ) 
		);
	}
 
	public function widget( $args, $instance ) {
		$title = apply_filters( 'widget_title', $instance['title'] );
		if ( isset( $instance[ 'exclude' ] ) ) { $exclude = $instance[ 'exclude' ]; }
		$excludeq = '';
		
		echo $args['before_widget'];
		if ( ! empty( $title ) ) { echo $args['before_title'] . wp_kses_post( $title ) . $args['after_title']; };
		
		echo '<ul class="blog-category__list">';
		if(isset( $instance[ 'exclude' ] )) {
			$excludeq = 'exclude='.$exclude;
		}
		$categories =  get_categories($excludeq);
		foreach ($categories as $category) {
			$option = '<li class="blog-category__item">
					       <a href="'.get_category_link( $category->term_id  ).'" class="blog-category__link">
						       <span class="blog-category__name">'.$category->name.'</span>
							   <span class="blog-category__count">'.$category->category_count.'</span>
					       </a>
					  </li>';
		    echo $option;
		}
		echo '</ul>';
		
		echo $args['after_widget'];
					
	
	}
	public function form( $instance ) {
		if ( isset( $instance[ 'title' ] ) ) { $title = $instance[ 'title' ]; } else { $title = ''; }
		if ( isset( $instance[ 'exclude' ] ) ) { $exclude = $instance[ 'exclude' ]; } else { $exclude = ''; }
		
		echo '<p><label for="'.$this->get_field_id( 'title' ).'">'.esc_html__("Title:","drivingschool-plugin").'</label>';
		echo '<input class="widefat" id="'.$this->get_field_id( 'title' ).'" name="'.$this->get_field_name( 'title' ).'" type="text" value="'.esc_attr( $title ).'" /></p>';
		echo '<p><label for="'.$this->get_field_id( 'exclude' ).'">'.esc_html__("Exclude a category (ID separated by a comma)","drivingschool-plugin").'</label>';
		echo '<input class="widefat" id="'.$this->get_field_id( 'exclude' ).'" name="'.$this->get_field_name( 'exclude' ).'" type="text" value="'.esc_attr( $exclude ).'" /></p>';
	}
	public function update( $new_instance, $old_instance ) {
	    $instance = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['exclude'] = ( ! empty( $new_instance['exclude'] ) ) ? strip_tags( $new_instance['exclude'] ) : '';
		return $instance;
	}
}



class RecentPostsWidget extends WP_Widget {
	function __construct() {
		parent::__construct(
			'true_top_widget3', 
			esc_html__("Recent Posts","drivingschool-plugin"),
			array( 'description' => esc_html__("Recent Posts - Driving School","drivingschool-plugin") ) 
		);
	}
 
	public function widget( $args, $instance ) {
		$title = apply_filters( 'widget_title', $instance['title'] );
		$excludee = $instance[ 'excludee' ];
		if ( isset( $instance[ 'number' ] ) ) { $number = $instance[ 'number' ]; }
		$excludeq = 999999999999999999999999999999999999999999999999999;
		$numberq = 2;
		if( $excludee != '' ) {
			$excludeq = $excludee;
		}
		if(isset( $instance[ 'number' ] )) {
			$numberq = $number;
		}
		echo $args['before_widget'];
		if ( ! empty( $title ) ) { echo $args['before_title'] . wp_kses_post( $title ) . $args['after_title']; };
		
		$widget_query = new WP_Query(array('cat' => $excludeq, 'posts_per_page' => $numberq)); 
		while($widget_query->have_posts()) : $widget_query->the_post(); 
		    echo '<article class="footer__post">
				      <a href="'.get_the_permalink().'" class="footer__post-wrap">
					      <h5 class="footer__post-title">'.get_the_title() .'</h5>
						  <p class="footer__text">'.drivingschool_get_excerpt(80).'</p>
					  </a>
				  </article>';
	   endwhile; wp_reset_postdata();
	   if($excludee != '') {
	       echo '<a href="'.get_category_link( $excludeq  ).'" class="footer__more">
		            '.esc_html__("See all posts","drivingschool-plugin").'
			        <svg class="footer__more-icon"><use xlink:href="'.get_template_directory_uri().'/assets/images/icon.svg#icon_right"></use></svg>
		         </a>';
	   }
		echo $args['after_widget'];
					
	
	}
	public function form( $instance ) {
		if ( isset( $instance[ 'title' ] ) ) { $title = $instance[ 'title' ]; } else { $title = ''; }
		if ( isset( $instance[ 'excludee' ] ) ) { $excludee = $instance[ 'excludee' ]; } else { $excludee = ''; }
		if ( isset( $instance[ 'number' ] ) ) { $number = $instance[ 'number' ]; } else { $number = ''; }
		
		echo '<p><label for="'.$this->get_field_id( 'title' ).'">'.esc_html__("Title:","drivingschool-plugin").'</label>';
		echo '<input class="widefat" id="'.$this->get_field_id( 'title' ).'" name="'.$this->get_field_name( 'title' ).'" type="text" value="'.esc_attr( $title ).'" /></p>';
		echo '<p><label for="'.$this->get_field_id( 'excludee' ).'">'.esc_html__("ID categories","drivingschool-plugin").'</label>';
		echo '<input class="widefat" id="'.$this->get_field_id( 'excludee' ).'" name="'.$this->get_field_name( 'excludee' ).'" type="number" value="'.esc_attr( $excludee ).'" /></p>';
		echo '<p><label for="'.$this->get_field_id( 'number' ).'">'.esc_html__("Number of posts","drivingschool-plugin").'</label>';
		echo '<input class="widefat" id="'.$this->get_field_id( 'number' ).'" name="'.$this->get_field_name( 'number' ).'" type="number" value="'.esc_attr( $number ).'" /></p>';
	}
	public function update( $new_instance, $old_instance ) {
	    $instance = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['excludee'] = ( ! empty( $new_instance['excludee'] ) ) ? strip_tags( $new_instance['excludee'] ) : '';
		$instance['number'] = ( ! empty( $new_instance['number'] ) ) ? strip_tags( $new_instance['number'] ) : '';
		return $instance;
	}
}


function drivingschool_true_top_posts_widget_load() {
	register_widget( 'OpeningHoursWidget' );
	register_widget( 'CategoriesWidget' );
	register_widget( 'RecentPostsWidget' );
}
add_action( 'widgets_init', 'drivingschool_true_top_posts_widget_load' );


?>