<?php
/**
 * Thrive Themes - https://thrivethemes.com
 *
 * @package thrive-automator
 */

namespace TVE\Dashboard\Automator;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Silence is golden!
}

/**
 * Class Utils
 */
class Elementor_Utils {

	public static function elementor_exists() {
		return class_exists( 'ElementorPro\Plugin', false );
	}

	public static function elementor_form_hook_setup() {
		if ( static::elementor_exists() ) {
			add_action( Elementor_Form_Submit::get_wp_hook(), static function ( $form_record ) {
				if ( ! empty( $_POST['form_id'] ) ) {
					do_action( static::create_dynamic_trigger( Elementor_Form_Submit::get_wp_hook(), strtolower( trim( preg_replace( '/[^A-Za-z0-9-]+/', '-', $_POST['form_id'] ) ) ) ), [ $form_record ] );
				}
			} );
		}
	}

	public static function get_elementor_posts() {
		$args = array(
			'post_type'  => [ 'page', 'elementor_library', 'post' ],
			'meta_query' => array(
				array(
					'key'     => '_elementor_data',
					'value'   => 'form',
					'compare' => 'LIKE',
				)
			)
		);
		header( 'Content-type: text/html' );

		return ( new \WP_Query( $args ) )->get_posts();
	}

	public static function should_load_elementor_files( $load, $filename ) {

		if ( strpos( basename( $filename, '.php' ), '-elementor-' ) !== false && ! static::elementor_exists() ) {
			$load = false;
		}

		return $load;
	}

	public static function create_dynamic_trigger( $prefix, $id ) {
		return $prefix . '_' . $id;
	}

}

add_filter( 'td_automator_should_load_file', [ Elementor_Utils::class, 'should_load_elementor_files' ], 10, 2 );
