<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimal-ui">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="imagetoolbar" content="no">
	<meta name="msthemecompatible" content="no">
	<meta name="cleartype" content="on">
	<meta name="HandheldFriendly" content="True">
	<meta name="format-detection" content="telephone=no">
	<meta name="format-detection" content="address=no">
	<meta name="theme-color" content="#ffffff">
	<meta name="apple-mobile-web-app-capable" content="yes">
	<meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<?php if(get_theme_mod('drivingschool_upper_block_h') != "no") { ?>
	<div class="bar-social">
		<div class="container">
			<div class="row">
				<div class="col-md-6 hidden-xs">
					<p class="bar-social__text"><?php echo esc_html(get_theme_mod('drivingschool_text_h')); ?></p>
				</div>
				<div class="col-md-6">
					<?php if(function_exists('drivingschool_social_list')) {
						echo drivingschool_social_list();
					} ?>
				</div>
			</div>
		</div>
	</div>
<?php } ?>
	<div class="header">
		<div class="header__row container">
			<div class="row">
				<?php
					$col_class = 'col-md-7';
					if(function_exists("drivingschool_form_call_me") and get_theme_mod('drivingschool_call_me') != "no") {
						$col_class = 'col-md-5';
					}
				?>
				<div class="<?php echo esc_attr( $col_class );?>">
					<div class="logo">
						<a href="<?php echo esc_url( home_url('/') ); ?>" class="logo__link">
							<?php if(get_theme_mod('drivingschool_logo_h') != "") { ?>
								<img src="<?php echo esc_url(get_theme_mod('drivingschool_logo_h')); ?>" alt="<?php bloginfo('name'); ?>">
							<?php } else { ?>
								<img src="<?php echo get_theme_file_uri( '/assets/images/logo.png' );?>" alt="<?php bloginfo('name'); ?>">
							<?php } ?>
						</a>
					</div>
				</div>
				<div class="header__contact col-md-3">
					<?php if(get_theme_mod('drivingschool_address') != "") { ?>
					<div class="header__address"><svg class="header__pin"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_pin"></use></svg><?php echo esc_html(get_theme_mod('drivingschool_address')); ?></div>
					<?php } ?>
				</div>
				<div class="header__contact col-md-2">
					<?php if(get_theme_mod('drivingschool_phone') != "") { ?>
					<a href="tel:<?php echo esc_html(str_replace(array(' ', '(' , ')', '-'), '', get_theme_mod('drivingschool_phone'))); ?>" class="header__phone"><svg class="header__phone-icon"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_phone"></use></svg><?php echo esc_html(get_theme_mod('drivingschool_phone')); ?></a>
					<?php } ?>
				</div>
				<?php if(function_exists("drivingschool_form_call_me") and get_theme_mod('drivingschool_call_me') != "no") { ?>
					<div class="header__contact col-md-2">
						<a class="btn header__callback" href="#">
							<span class="btn__text"><?php esc_html_e('Call me','drivingschool');?></span>
						</a>
					</div>
				<?php } ?>
			</div>
		</div>

		<div class="nav">
			<div class="nav__btn-wrap">
				<button class="btn nav__btn" type="button">
					<span class="btn__text">
						<span class="nav__icon"></span>
					</span>
				</button>
			</div>
			<div class="nav__body container">
				<div class="nav__inner">
					<div class="nav__close"></div>
					<?php wp_nav_menu( array(
						'theme_location' => 'primary',
						'fallback_cb'    => 'drivingschool_fallback_default_menu',
						'container'      => false,
						'items_wrap'     => '<ul class="nav__list">%3$s</ul>'
					)); ?>
				</div>
			</div>
		</div>

	</div>