<?php 
function drivingschool_subscription_display($template = '') { 
    if(get_theme_mod('drivingschool_url_subs') != "") {    
?>
	<div class="subscribe <?php echo esc_attr($template); ?>">
		<div class="subscribe__head"<?php if(get_theme_mod('drivingschool_background_subs') != "") { ?> style="background: url(<?php echo esc_url(get_theme_mod('drivingschool_background_subs')); ?>) center 0 no-repeat !important;  background-size: cover !important;"<?php } ?>>
			<?php if(get_theme_mod('drivingschool_title_subs') != "") { ?>
			<div class="subscribe__title"><?php echo esc_html(get_theme_mod('drivingschool_title_subs')); ?></div>
			<?php } ?>
			<div class="subscribe__desc"><?php echo esc_html(get_theme_mod('drivingschool_text_subs')); ?></div>
		</div>
		<div class="subscribe__body">
			<form action="<?php echo esc_url(get_theme_mod('drivingschool_url_subs')); ?>" method="post" name="mc-embedded-subscribe-form" id="subscription-form" target="_blank">
				<div class="form__row row">
					<div class="form__row-mobile col-md-7 col-md-offset-1">
						<div class="control-group control-group_fullwidth">
							<span class="control-remark control-group__item">
								<svg class="control-remark__icon"><use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_mail"></use></svg>
							</span>
							<span class="inp">
								<span class="inp__box">
									<input class="inp__control" type="email" name="EMAIL" placeholder="<?php esc_html_e('Enter your E-Mail', 'drivingschool'); ?>" required />
								</span>
							</span>
						</div>
					</div>
					<div class="col-md-3">
						<button class="btn btn_fullwidth" name="subscribe" type="submit">
							<span class="btn__text"><?php esc_html_e('subscribee', 'drivingschool'); ?></span>
						</button>
					</div>
				</div>
			</form>
		</div>
	</div>
<?php 
	}
}