<?php

/*

Template Name: About us

*/

drivingschool_on_ff();
?>
<?php get_header();  ?>
	<?php while (have_posts()) : the_post(); ?>
	<div class="head-page">
		<div class="container">
			<div class="row">
				<div class="col-md-8">
					<h1 class="title-page"><?php the_title(); ?></h1>
					<div class="breadcrumbs">
						<ul class="breadcrumbs__list">
							<li class="breadcrumbs__item">
								<a href="<?php echo esc_url( home_url('/') ); ?>" class="breadcrumbs__link"><?php esc_html_e('Index', 'drivingschool'); ?></a>
							</li>
							<?php if (drivingschool_is_subpage()) { ?>
							<li class="breadcrumbs__item">
								<a href="<?php echo get_permalink($post->post_parent); ?>" class="breadcrumbs__link"><?php echo get_the_title($post->post_parent); ?></a>
							</li>
							<?php } ?>
							<li class="breadcrumbs__item"><?php the_title(); ?></li>
						</ul>
					</div>
				</div>
				<div class="col-md-4">
					<?php get_search_form(); ?>
				</div>
			</div>
		</div>
	</div>
	<div class="content">
		<div class="text text_bottom-m_no">
			<div class="container">
				<div class="row">
					<div class="col-md-12">
						<div class="article__body">
							<?php the_content(); ?>
						</div>
					</div>
				</div>
			</div>
		</div>
		<?php if( have_rows('blocks') ): ?>
		<div class="categoryes">
			<?php 
				$m = 0; while( have_rows('blocks') ) : the_row(); $m++; 
				$thumb_url = wp_get_attachment_image_src(get_sub_field('picture'),'drivingschool_about-thumb', true);
			?>
			<div class="categoryes__item">
				<div class="container">
					<div class="row">
						<?php if(get_sub_field('picture') != '') { ?>
						<div class="col-md-3 <?php if($m==2) { echo " col-md-push-9"; } ?>">
							<figure class="categoryes__fig">
								<img src="<?php echo esc_url($thumb_url[0]); ?>" alt="<?php esc_html(the_sub_field('title')); ?>" />
							</figure>
						</div>
						<?php } ?>
						<div class="col-md-9<?php if($m==2) { echo " col-md-pull-3"; $m  = 0;} ?>">
							<h2 class="categoryes__name"><?php esc_html(the_sub_field('title')); ?></h2>
							<p class="categoryes__desc"><?php esc_html(the_sub_field('text')); ?></p>
							<?php if(get_sub_field('link') != '') { ?>
							<a class="btn categoryes__more" href="<?php esc_url(the_sub_field('link')); ?>">
								<span class="btn__text"><?php esc_html_e('More Info', 'drivingschool'); ?></span>
							</a>
							<?php } ?>
						</div>
					</div>
				</div>
			</div>
			<?php endwhile; ?> 
		</div>  
		<?php endif; ?>
		<?php endwhile; ?>
	</div>
<?php get_footer(); ?>