<?php

/*

Template Name: Photo

*/

drivingschool_on_ff();
?>
<?php get_header();  ?>
	<?php while (have_posts()) : the_post(); ?>
	<div class="head-page">
		<div class="container">
			<div class="row">
				<div class="col-md-8">
					<h1 class="title-page"><?php the_title(); ?></h1>
					<div class="breadcrumbs">
						<ul class="breadcrumbs__list">
							<li class="breadcrumbs__item">
								<a href="<?php echo esc_url( home_url('/') ); ?>" class="breadcrumbs__link"><?php esc_html_e('Index', 'drivingschool'); ?></a>
							</li>
							<?php if (drivingschool_is_subpage()) { ?>
							<li class="breadcrumbs__item">
								<a href="<?php echo get_permalink($post->post_parent); ?>" class="breadcrumbs__link"><?php echo get_the_title($post->post_parent); ?></a>
							</li>
							<?php } ?>
							<li class="breadcrumbs__item"><?php the_title(); ?></li>
						</ul>
					</div>
				</div>
				<div class="col-md-4">
					<?php get_search_form(); ?>
				</div>
			</div>
		</div>
	</div>
	<div class="content">
		<?php if( have_rows('blocks') ): while( have_rows('blocks') ) :  the_row(); ?>
		<div class="photo">
			<div class="container">
				<?php if(get_sub_field('title') != '') { ?>
				<h2 class="title">
					<span class="title__mark"><?php esc_html(the_sub_field('title')); ?></span>
				</h2>
				<?php } ?>
				<?php if( have_rows('photo') ): ?>
				<ul class="photo__list row">
					<?php 
						while( have_rows('photo') ) : the_row(); 
						$picture = get_sub_field('picture');
					?>
					<li class="photo__list-item col-xs-4 col-md-2">
						<a href="<?php echo esc_url($picture['url']); ?>" class="photo__thumb">
							<img src="<?php echo esc_url($picture['sizes']['drivingschool_photo-thumb']); ?>" alt="<?php echo esc_html($picture['alt']); ?>" />
						</a>
					</li>
					<?php endwhile; ?>
				</ul>
				<?php endif; ?>
			</div>
		</div>
		<?php endwhile; endif; ?>
		<?php endwhile; ?>
	</div>
<?php get_footer(); ?>