<?php
/**
 * 
 */
class qcbmdna88_Custom_Fields
{
	
	function __construct()
	{
		add_action('wp_nav_menu_item_custom_fields', [$this, 'nav_menu_item_custom_fields'], 10, 5);
		add_action('wp_update_nav_menu_item', [$this, 'wp_update_nav_menu_item'], 10, 3);
	}

	function nav_menu_item_custom_fields( $item_id, $item, $depth, $args, $id ){
			wp_nonce_field( 'qc_btn_menu_meta_nonce', '_qc_btn_menu_meta_nonce_name' );
			//General Options
			$button_bg = get_post_meta($item_id, 'qc-btn-menu-button-bg', true) ? get_post_meta($item_id, 'qc-btn-menu-button-bg', true) : '';
			$button_color = get_post_meta($item_id, 'qc-btn-menu-button-color', true) ? get_post_meta($item_id, 'qc-btn-menu-button-color', true) : '';
			$button_hover_bg = get_post_meta($item_id, 'qc-btn-menu-button-hover-bg', true) ? get_post_meta($item_id, 'qc-btn-menu-button-hover-bg', true) : '';
			$button_hover_color = get_post_meta($item_id, 'qc-btn-menu-button-hover-color', true) ? get_post_meta($item_id,'qc-btn-menu-button-hover-color', true) : '';
			$button_icon = get_post_meta($item_id, 'qc-btn-menu-button-icon', true) ? get_post_meta($item_id,'qc-btn-menu-button-icon', true) : '';
		?>
			<div class="description description-wide qc-btn-menu-d-flex">
				<div class="menu-item-btn-fields qc-btn-menu-w-50">
					<label class="qc-btn-menu-d-block" for="qc-btn-menu-button-color">
					<?php echo esc_html__( 'Button Color:', 'qc-btn-menu'); ?>
					</label>
					<input type="text" name="qc-btn-menu-button-color-<?php echo esc_attr($item_id); ?>" value="<?php echo esc_attr($button_color); ?>" class="qc-button-menu-color" />
				</div>

				<div class="menu-item-btn-fields qc-btn-menu-w-50 qc-btn-menu-d-flex qc-btn-menu-d-flex-end">
					<label class="qc-btn-menu-d-block" for="qc-btn-menu-button-hover-color">
					<?php echo esc_html__( 'Button Hover Color:','qc-btn-menu'); ?>
					</label>
					<input type="text" id="qc-btn-menu-button-hover-color" name="qc-btn-menu-button-hover-color-<?php echo esc_attr($item_id); ?>" value="<?php echo esc_attr($button_hover_color); ?>" class="qc-button-menu-color" />
				</div>

				<div class="menu-item-btn-fields qc-btn-menu-w-50">
					<label class="qc-btn-menu-d-block" for="qc-btn-menu-button-bg">
					<?php echo esc_html__( 'Button Background:', 'qc-btn-menu'); ?>
					</label>
					<input type="text" id="qc-btn-menu-button-bg" name="qc-btn-menu-button-bg-<?php echo esc_attr($item_id); ?>" value="<?php echo esc_attr($button_bg); ?>" class="qc-button-menu-color" />
				</div>

				<div class="menu-item-btn-fields qc-btn-menu-w-50 qc-btn-menu-d-flex qc-btn-menu-d-flex-end">
					<label class="qc-btn-menu-d-block" for="qc-btn-menu-button-hover-bg">
					<?php echo esc_html__( 'Button Hover Background:', 'qc-btn-menu'); ?>
					</label>
					<input type="text" id="qc-btn-menu-button-hover-bg" name="qc-btn-menu-button-hover-bg-<?php echo esc_attr($item_id); ?>" value="<?php echo esc_attr($button_hover_bg); ?>" class="qc-button-menu-color" />
				</div>

				<div class="menu-item-btn-fields">
					<label class="qc-btn-menu-d-block" for="qc-btn-menu-button-bg">
					<?php echo esc_html__( 'Button Icon:', 'qc-btn-menu'); ?>
					</label>
					<div class="qc-btn-menu-icon-container">
						<span class="icon-preview <?php if( $button_icon ){ echo esc_html__('button', 'qc-btn-menu'); } ?>" data-toggle="tooltip" title="" data-original-title="Preview of selected Icon">
	                        <i id="qc_btn_menu_IconPreview-<?php echo esc_attr($item_id); ?>" class="<?php if( $button_icon ){ echo esc_attr($button_icon); } ?>"></i>
	                    </span>
						<input type="text" id="button-icon-field-<?php echo esc_attr($item_id); ?>" name="qc-btn-menu-button-icon-<?php echo esc_attr($item_id); ?>" value="<?php if( $button_icon ){ echo esc_attr($button_icon); } ?>" class="qc-button-menu-iconpicker-field-<?php echo esc_attr($item_id); ?>" />
						<button type="button" id="button-icon-picker-<?php echo esc_attr($item_id); ?>" name="button-icon-picker-<?php echo esc_attr($item_id); ?>" class="qc-button-menu-iconpicker button button-primary" data-iconpicker-input=".qc-button-menu-iconpicker-field-<?php echo esc_attr($item_id); ?>" data-iconpicker-preview="i#qc_btn_menu_IconPreview-<?php echo esc_attr($item_id); ?>" ><?php echo esc_html__('Choose Icon', 'qc-btn-menu'); ?></button>
					</div>
				</div>

			</div>
		<?php
	}

	public function wp_update_nav_menu_item($menu_id, $menu_item_db_id, $menu_item_data){
		// Verify this came from our screen and with proper authorization.
		if ( ! isset( $_POST['_qc_btn_menu_meta_nonce_name'] ) || ! wp_verify_nonce( $_POST['_qc_btn_menu_meta_nonce_name'], 'qc_btn_menu_meta_nonce' ) ) {
			return $menu_id;
		}

		if ( isset( $_POST['qc-btn-menu-button-color-'.$menu_item_db_id]  ) ) {
			$sanitized_data = sanitize_text_field( $_POST['qc-btn-menu-button-color-'.$menu_item_db_id] );
			update_post_meta( $menu_item_db_id, 'qc-btn-menu-button-color', $sanitized_data );
		}

		if ( isset( $_POST['qc-btn-menu-button-hover-color-'.$menu_item_db_id]  ) ) {
			$sanitized_data = sanitize_text_field( $_POST['qc-btn-menu-button-hover-color-'.$menu_item_db_id] );
			update_post_meta( $menu_item_db_id, 'qc-btn-menu-button-hover-color', $sanitized_data );
		}

		if ( isset( $_POST['qc-btn-menu-button-bg-'.$menu_item_db_id]  ) ) {
			$sanitized_data = sanitize_text_field( $_POST['qc-btn-menu-button-bg-'.$menu_item_db_id] );
			update_post_meta( $menu_item_db_id, 'qc-btn-menu-button-bg', $sanitized_data );
		}

		if ( isset( $_POST['qc-btn-menu-button-hover-bg-'.$menu_item_db_id]  ) ) {
			$sanitized_data = sanitize_text_field( $_POST['qc-btn-menu-button-hover-bg-'.$menu_item_db_id] );
			update_post_meta( $menu_item_db_id, 'qc-btn-menu-button-hover-bg', $sanitized_data );
		}

		if ( isset( $_POST['qc-btn-menu-button-icon-'.$menu_item_db_id]  ) ) {
			$sanitized_data = sanitize_text_field( $_POST['qc-btn-menu-button-icon-'.$menu_item_db_id] );
			update_post_meta( $menu_item_db_id, 'qc-btn-menu-button-icon', $sanitized_data );
		}

		
	}
}

new qcbmdna88_Custom_Fields();