<?php
if( !class_exists('qcbmdna88_Admin_Pages') ){
	/**
	 * Register All Admin Pages from Here
	 */
	class qcbmdna88_Admin_Pages
	{

		private static $instance;

		public static function getInstance() {

	        if (!isset(self::$instance)) {
	            self::$instance = new qcbmdna88_Admin_Pages();
	            self::$instance->init();
	        }
	        return self::$instance;
	    }
		
		function __construct() {
			add_action( 'admin_init', array($this, 'register_setting') ); 
			add_action('admin_menu', array($this, 'menu_page'));

		}

		public function init(){
			if ((!empty($_GET["page"])) && ($_GET["page"] == "qc_duplicate_button_menu")) {

	        	add_action('admin_init', array($this, 'qc_button_menu_save_options'));
	        }

		}

		public function menu_page(){
			global $submenu;
			add_menu_page(
				esc_html__('Button Menu', 'qc-btn-menu'),
				esc_html__('Button Menu', 'qc-btn-menu'),
				'manage_options',
				'qc_button_menu',
				array($this, 'menu_page_callback'),
				'dashicons-menu',
				25
			);
			add_submenu_page(
				'qc_button_menu',
				esc_html__('Duplicate Menu', 'qc-btn-menu'),
				esc_html__('Duplicate Menu', 'qc-btn-menu'),
				'manage_options',
				'qc_duplicate_button_menu',
				array($this, 'qc_button_menu_duplicate_options_screen')
			);

		}

		public function qc_button_menu_duplicate_options_screen(){

			$qc_btn_nav_menus = wp_get_nav_menus();

		?>
		    <div class="wrap">
		        <div id="icon-options-general" class="icon32"><br /></div>
		            <h2><?php esc_html_e( 'Duplicate Menu', 'qc-btn-menu' ); ?></h2>

		            <?php 

		            if ( ! empty( $_POST ) && wp_verify_nonce( $_POST['qc_btn_menu_qc_btn_duplicate_menu_nonce'], 'qc_btn_duplicate_menu_nonce' ) ) : 

		                $new_menu_id = get_option('qc_button_menu_new_id');
		                update_option('qc_button_menu_new_id', '');
		            ?>

		                <div id="message" class="updated"><p>
		                    <?php if ( $new_menu_id ) : ?>
		                        <?php esc_html_e( 'Menu Duplicated', 'qc-btn-menu' ) ?>. <a href="nav-menus.php?action=edit&amp;menu=<?php echo absint( $new_menu_id ); ?>"><?php esc_html_e( 'View', 'qc-btn-menu' ) ?></a>
		                    <?php else: ?>
		                        <?php esc_html_e( 'There was a problem duplicating your menu. No action was taken.', 'qc-btn-menu' ) ?>.
		                    <?php endif; ?>
		                </p></div>

		            <?php endif; ?>


		            <?php if ( empty( $qc_btn_nav_menus ) ) : ?>
		                <p><?php esc_html_e( "You haven't created any Menus yet.", 'qc-btn-menu' ); ?></p>
		            <?php else: ?>
		                <form method="post" action="">
		                    <?php wp_nonce_field( 'qc_btn_duplicate_menu_nonce','qc_btn_menu_qc_btn_duplicate_menu_nonce' ); ?>
		                    <table class="form-table">
		                        <tr valign="top">
		                            <th scope="row">
		                                <label for="qc_btn_menu_name"><?php esc_html_e( 'Duplicate this menu', 'qc-btn-menu' ); ?>:</label>
		                            </th>
		                            <td>
		                                <select name="qc_btn_menu_name">
		                                    <?php foreach ( (array) $qc_btn_nav_menus as $qc_btn_nav_menu ) : ?>
		                                        <option value="<?php echo esc_attr($qc_btn_nav_menu->term_id) ?>">
		                                            <?php echo esc_html( $qc_btn_nav_menu->name); ?>
		                                        </option>
		                                    <?php endforeach; ?>
		                                </select>
		                                <span style="display:inline-block; padding:0 10px;"><?php esc_html_e( 'and call it', 'qc-btn-menu' ); ?></span>
		                                <input name="qc_btn_new_menu_name" type="text" id="qc_btn_new_menu_name" value="" class="regular-text" />
		                            </td>
		                    </table>
		                    <p class="submit">
		                        <input type="submit" name="submit" id="submit" class="button-primary" value="Duplicate Menu" />
		                    </p>
		                </form>
		            <?php endif; ?>
		        </div>


		<?php 
			
		}

	    public function qc_button_menu_save_options(){


		if (isset($_POST['_wp_http_referer']) && $_POST['_wp_http_referer']) {


			wp_verify_nonce( $_POST['qc_btn_menu_qc_btn_duplicate_menu_nonce'], 'qc_btn_duplicate_menu_nonce' );


				if ( (isset($_GET['page']) && $_GET['page'] == 'qc_duplicate_button_menu' ) && isset($_POST['submit'])) {

				
					$id        		= intval( $_POST['qc_btn_menu_name'] );
					$name    		= sanitize_text_field( $_POST['qc_btn_new_menu_name'] );
		
					if ( empty( $id ) || empty( $name ) ) {
						return false;
					}

					$qc_btn_menu_name 			= wp_get_nav_menu_object( $id );
					$qc_btn_menu_name_items 	= wp_get_nav_menu_items( $id );
					$new_id 					= wp_create_nav_menu( $name );

					if ( ! $new_id ) {
						return false;
					}

					$rel = array();

					$i = 1;
					foreach ( $qc_btn_menu_name_items as $menu_item ) {
						$args = array(
							'menu-item-db-id'       => $menu_item->db_id,
							'menu-item-object-id'   => $menu_item->object_id,
							'menu-item-object'      => $menu_item->object,
							'menu-item-position'    => $i,
							'menu-item-type'        => $menu_item->type,
							'menu-item-title'       => $menu_item->title,
							'menu-item-url'         => $menu_item->url,
							'menu-item-description' => $menu_item->description,
							'menu-item-attr-title'  => $menu_item->attr_title,
							'menu-item-target'      => $menu_item->target,
							'menu-item-classes'     => implode( ' ', $menu_item->classes ),
							'menu-item-xfn'         => $menu_item->xfn,
							'menu-item-status'      => $menu_item->post_status
						);

						$parent_id = wp_update_nav_menu_item( $new_id, 0, $args );

						$rel[$menu_item->db_id] = $parent_id;

						// did it have a parent? if so, we need to update with the NEW ID
						if ( $menu_item->menu_item_parent ) {
							$args['menu-item-parent-id'] = $rel[$menu_item->menu_item_parent];
							$parent_id = wp_update_nav_menu_item( $new_id, $parent_id, $args );
						}

						// allow developers to run any custom functionality they'd like
						do_action( 'duplicate_menu_item', $menu_item, $args );

						$i++;
					}

					if (isset($new_id)) {
						update_option('qc_button_menu_new_id', $new_id);
					}

					return $new_id;


				}
			}
		}

		public function menu_page_callback(){
			require_once('templates/main-admin-menu.php');
		}

		public function register_setting() {
		    register_setting( 'qc_btn_menu_settings_options', 'qc-btn-menu-container-bg' );
		    register_setting( 'qc_btn_menu_settings_options', 'qc-btn-menu-button-bg');
		    register_setting( 'qc_btn_menu_settings_options', 'qc-btn-menu-button-color');
		    register_setting( 'qc_btn_menu_settings_options', 'qc-btn-menu-button-hover-bg');
		    register_setting( 'qc_btn_menu_settings_options', 'qc-btn-menu-button-hover-color');

		  
		    register_setting( 'qc_btn_menu_settings_options', 'qc-btn-menu-submenu-icon');
		    // Animation
		    register_setting( 'qc_btn_menu_settings_options', 'qc-btn-menu-submenu-visible-animation');
		    register_setting( 'qc_btn_menu_settings_options', 'qc-btn-menu-hover-animation');
		    register_setting( 'qc_btn_menu_settings_options', 'qc-btn-menu-button-style');
				
		}

	}

}

qcbmdna88_Admin_Pages::getInstance();