<?php
	//General Options
	$container_bg = get_option('qc-btn-menu-container-bg') ? get_option('qc-btn-menu-container-bg') : '#f5f5f5';
	$button_bg = get_option('qc-btn-menu-button-bg') ? get_option('qc-btn-menu-button-bg') : '#fff';
	$button_color = get_option('qc-btn-menu-button-color') ? get_option('qc-btn-menu-button-color') : '#000';
	$button_hover_bg = get_option('qc-btn-menu-button-hover-bg') ? get_option('qc-btn-menu-button-hover-bg') : '#e9e9e9';
	$button_hover_color = get_option('qc-btn-menu-button-hover-color') ? get_option('qc-btn-menu-button-hover-color') : '#000';
	
	
	$submenu_animation = get_option('qc-btn-menu-submenu-visible-animation') ? get_option('qc-btn-menu-submenu-visible-animation') : '';
	$submenu_icon = get_option('qc-btn-menu-submenu-icon') ? get_option('qc-btn-menu-submenu-icon') : 'fas fa-arrow-right';
	$btn_hover_animation = get_option('qc-btn-menu-hover-animation') ? get_option('qc-btn-menu-hover-animation') : 'qc-btn-hover-anim-default';
	$btn_menu_style = get_option('qc-btn-menu-button-style') ? get_option('qc-btn-menu-button-style') : 'qcbm-menu-style-default';
		
?>
<div class="wrap" id="tabs" >
	<h1><?php echo esc_html__('Button Menu', 'qc-btn-menu'); ?></h1>

	
	<ul class="nav-tab-wrapper qc-btn-menu_nav_container">
		<li style="margin-bottom:0px"><a class="nav-tab qc-btn-menu_click_handle nav-tab-active" href="#tab-1"><?php echo esc_html__('General Settings','qc-btn-menu') ?></a></li>
		<li style="margin-bottom:0px"><a class="nav-tab qc-btn-menu_click_handle" href="#tab-2"><?php echo esc_html__('Help','qc-btn-menu') ?></a></li>
	</ul>
	<form action="options.php" method="post">
		<?php settings_fields( 'qc_btn_menu_settings_options' ); ?>
		
		<div class="nav-tab-content" id="tab-1">
			<table class="form-table qc-btn-menu-d-block" id="style">
				<tbody>
					<tr>
						<th scope="row">
							<label for="qc-btn-menu-container-bg"><?php echo esc_html__('Container Background:', 'qc-btn-menu'); ?></label>
						</th>
						<td>
							<input type="text" id="qc-btn-menu-container-bg" name="qc-btn-menu-container-bg" value="<?php echo esc_attr($container_bg); ?>" class="qc-button-menu-color" />
						</td>
					</tr>
					<tr>
						<th scope="row">
							<label for="qc-btn-menu-button-bg"><?php echo esc_html__('Button Background:', 'qc-btn-menu'); ?></label>
						</th>
						<td>
							<input type="text" id="qc-btn-menu-button-bg" name="qc-btn-menu-button-bg" value="<?php echo esc_attr($button_bg); ?>" class="qc-button-menu-color" />
						</td>
					</tr>
					<tr>
						<th scope="row">
							<label for="qc-btn-menu-button-hover-bg"><?php echo esc_html__('Button Hover Background:', 'qc-btn-menu'); ?></label>
						</th>
						<td>
							<input type="text" id="qc-btn-menu-button-hover-bg" name="qc-btn-menu-button-hover-bg" value="<?php echo esc_attr($button_hover_bg); ?>" class="qc-button-menu-color" />
						</td>
					</tr>
					<tr>
						<th scope="row">
							<label for="qc-btn-menu-button-color"><?php echo esc_html__('Button Color:', 'qc-btn-menu'); ?></label>
						</th>
						<td>
							<input type="text" id="qc-btn-menu-button-color" name="qc-btn-menu-button-color" value="<?php echo esc_attr($button_color); ?>" class="qc-button-menu-color" />
						</td>
					</tr>
					<tr>
						<th scope="row">
							<label for="qc-btn-menu-button-hover-color"><?php echo esc_html__('Button Hover Color:', 'qc-btn-menu'); ?></label>
						</th>
						<td>
							<input type="text" id="qc-btn-menu-button-hover-color" name="qc-btn-menu-button-hover-color" value="<?php echo esc_attr($button_hover_color); ?>" class="qc-button-menu-color" />
						</td>
					</tr>


					<tr>
						<th scope="row">
							<label for="qc-btn-menu-submenu-icon"><?php echo esc_html__('Subemnu Icon:', 'qc-btn-menu'); ?></label>
						</th>
						<td>
							<div class="qc-btn-menu-icon-container">
			                    <input type="text" id="button-icon-field" name="qc-btn-menu-submenu-icon" value="<?php if( $submenu_icon ){ echo esc_attr($submenu_icon); } ?>" class="qc-button-menu-iconpicker-field" />
								<span class="icon-preview <?php if( $submenu_icon ){ echo esc_html__('button', 'qc-btn-menu'); } ?>" data-toggle="tooltip" title="" data-original-title="Preview of selected Icon">
			                        <i id="qc_btn_menu_IconPreview" class="<?php if( $submenu_icon ){ echo esc_attr($submenu_icon); } ?>"></i>
			                    </span>
								<button type="button" id="button-icon-picker" name="button-icon-picker" class="qc-button-menu-iconpicker button button-primary" data-iconpicker-input=".qc-button-menu-iconpicker-field" data-iconpicker-preview="i#qc_btn_menu_IconPreview" ><?php echo esc_html__('Choose Icon', 'qc-btn-menu'); ?></button>
							</div>
						</td>
					</tr>
					<tr>
						<th scope="row">
							<label for="qc-btn-menu-button-hover-animation"><?php echo esc_html__('Button Hover Animation:', 'qc-btn-menu'); ?></label>
						</th>
						<td>
							<select name="qc-btn-menu-hover-animation">
								<option <?php selected( $btn_hover_animation, 'qc-btn-hover-anim-default'); ?> value="qc-btn-hover-anim-default"><?php echo esc_html__('Default', 'qc-btn-menu'); ?></option>
								<option <?php selected( $btn_hover_animation, 'hvr-sweep-to-right'); ?> value="hvr-sweep-to-right"><?php echo esc_html__('Sweep to Right', 'qc-btn-menu'); ?></option>
								<option <?php selected( $btn_hover_animation, 'hvr-sweep-to-left'); ?> value="hvr-sweep-to-left"><?php echo esc_html__('Sweep to Left', 'qc-btn-menu'); ?></option>
								<option <?php selected( $btn_hover_animation, 'hvr-sweep-to-bottom'); ?> value="hvr-sweep-to-bottom"><?php echo esc_html__('Sweep to Bottom', 'qc-btn-menu'); ?></option>
								<option <?php selected( $btn_hover_animation, 'hvr-sweep-to-top'); ?> value="hvr-sweep-to-top"><?php echo esc_html__('Sweep to Top', 'qc-btn-menu'); ?></option>
								<option <?php selected( $btn_hover_animation, 'hvr-bounce-to-right'); ?> value="hvr-bounce-to-right"><?php echo esc_html__('Bounce to Right', 'qc-btn-menu'); ?></option>
								<option <?php selected( $btn_hover_animation, 'hvr-bounce-to-left'); ?> value="hvr-bounce-to-left"><?php echo esc_html__('Bounce to Left', 'qc-btn-menu'); ?></option>
								<option <?php selected( $btn_hover_animation, 'hvr-bounce-to-bottom'); ?> value="hvr-bounce-to-bottom"><?php echo esc_html__('Bounce to Bottom', 'qc-btn-menu'); ?></option>
								<option <?php selected( $btn_hover_animation, 'hvr-bounce-to-top'); ?> value="hvr-bounce-to-top"><?php echo esc_html__('Bounce to Top', 'qc-btn-menu'); ?></option>
								<option <?php selected( $btn_hover_animation, 'hvr-radial-out'); ?> value="hvr-radial-out"><?php echo esc_html__('Radial Out', 'qc-btn-menu'); ?></option>
								<option <?php selected( $btn_hover_animation, 'hvr-radial-in'); ?> value="hvr-radial-in"><?php echo esc_html__('Radial In', 'qc-btn-menu'); ?></option>
								<option <?php selected( $btn_hover_animation, 'hvr-rectangle-in'); ?> value="hvr-rectangle-in"><?php echo esc_html__('Rectangle In', 'qc-btn-menu'); ?></option>
								<option <?php selected( $btn_hover_animation, 'hvr-rectangle-out'); ?> value="hvr-rectangle-out"><?php echo esc_html__('Rectangle Out', 'qc-btn-menu'); ?></option>
								<option <?php selected( $btn_hover_animation, 'hvr-shutter-in-horizontal'); ?> value="hvr-shutter-in-horizontal"><?php echo esc_html__('Shutter In Horizontal', 'qc-btn-menu'); ?></option>
								<option <?php selected( $btn_hover_animation, 'hvr-shutter-out-horizontal'); ?> value="hvr-shutter-out-horizontal"><?php echo esc_html__('Shutter Out Horizontal', 'qc-btn-menu'); ?></option>
								<option <?php selected( $btn_hover_animation, 'hvr-shutter-in-vertical'); ?> value="hvr-shutter-in-vertical"><?php echo esc_html__('Shutter In Vertical', 'qc-btn-menu'); ?></option>
								<option <?php selected( $btn_hover_animation, 'hvr-shutter-out-vertical'); ?> value="hvr-shutter-out-vertical"><?php echo esc_html__('Shutter Out Vertical', 'qc-btn-menu'); ?></option>
							</select>
						</td>
					</tr>
					<tr>
						<th scope="row">
							<label for="qc-btn-menu-container-bg"><?php echo esc_html__('Submenu Visible Animation:'); ?></label>
						</th>
						<td>
							<select name="qc-btn-menu-submenu-visible-animation">
								<option><?php echo esc_html__('Select an Option', 'qc-btn-menu'); ?></option>
								<optgroup label="Attention seekers">
							    	<option <?php selected( $submenu_animation, 'bounce'); ?> value="bounce"><?php echo esc_html__('bounce', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'flash'); ?> value="flash"><?php echo esc_html__('flash', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'pulse'); ?> value="pulse"><?php echo esc_html__('pulse', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'rubberBand'); ?> value="rubberBand"><?php echo esc_html__('rubberBand', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'shakeX'); ?> value="shakeX"><?php echo esc_html__('shakeX', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'shakeY'); ?> value="shakeY"><?php echo esc_html__('shakeY', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'headShake'); ?> value="headShake"><?php echo esc_html__('headShake', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'swing'); ?> value="swing"><?php echo esc_html__('swing', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'tada'); ?> value="tada"><?php echo esc_html__('tada', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'wobble'); ?> value="wobble"><?php echo esc_html__('wobble', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'jello'); ?> value="jello"><?php echo esc_html__('jello', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'heartBeat'); ?> value="heartBeat"><?php echo esc_html__('heartBeat', 'qc-btn-menu'); ?></option>
							    </optgroup>
							    <optgroup label="Back entrances">
							    	<option <?php selected( $submenu_animation, 'backInDown'); ?> value="backInDown"><?php echo esc_html__('backInDown', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'backInLeft'); ?> value="backInLeft"><?php echo esc_html__('backInLeft', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'backInRight'); ?> value="backInRight"><?php echo esc_html__('backInRight', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'backInUp'); ?> value="backInUp"><?php echo esc_html__('backInUp', 'qc-btn-menu'); ?></option>
							    </optgroup>
							    <optgroup label="Back exits">
							    	<option <?php selected( $submenu_animation, 'backOutDown'); ?> value="backOutDown"><?php echo esc_html__('backOutDown', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'backOutLeft'); ?> value="backOutLeft"><?php echo esc_html__('backOutLeft', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'backOutRight'); ?> value="backOutRight"><?php echo esc_html__('backOutRight', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'backOutUp'); ?> value="backOutUp"><?php echo esc_html__('backOutUp', 'qc-btn-menu'); ?></option>
							    </optgroup>
							    <optgroup label="Bouncing entrances">
							    	<option <?php selected( $submenu_animation, 'bounceIn'); ?> value="bounceIn"><?php echo esc_html__('bounceIn', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'bounceInDown'); ?> value="bounceInDown"><?php echo esc_html__('bounceInDown', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'bounceInLeft'); ?> value="bounceInLeft"><?php echo esc_html__('bounceInLeft', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'bounceInRight'); ?> value="bounceInRight"><?php echo esc_html__('bounceInRight', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'bounceInUp'); ?> value="bounceInUp"><?php echo esc_html__('bounceInUp', 'qc-btn-menu'); ?></option>
							    </optgroup>
							    <optgroup label="Bouncing exits">
							    	<option <?php selected( $submenu_animation, 'bounceOut'); ?> value="bounceOut"><?php echo esc_html__('bounceOut', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'bounceOutDown'); ?> value="bounceOutDown"><?php echo esc_html__('bounceOutDown', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'bounceOutLeft'); ?> value="bounceOutLeft"><?php echo esc_html__('bounceOutLeft', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'bounceOutRight'); ?> value="bounceOutRight"><?php echo esc_html__('bounceOutRight', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'bounceOutUp'); ?> value="bounceOutUp"><?php echo esc_html__('bounceOutUp', 'qc-btn-menu'); ?></option>
							    </optgroup>
							    <optgroup label="Fading entrances">
							    	<option <?php selected( $submenu_animation, 'fadeIn'); ?> value="fadeIn"><?php echo esc_html__('fadeIn', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'fadeInDown'); ?> value="fadeInDown"><?php echo esc_html__('fadeInDown', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'fadeInDownBig'); ?> value="fadeInDownBig"><?php echo esc_html__('fadeInDownBig', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'fadeInLeft'); ?> value="fadeInLeft"><?php echo esc_html__('fadeInLeft', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'fadeInLeftBig'); ?> value="fadeInLeftBig"><?php echo esc_html__('fadeInLeftBig', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'fadeInRight'); ?> value="fadeInRight"><?php echo esc_html__('fadeInRight', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'fadeInRightBig'); ?> value="fadeInRightBig"><?php echo esc_html__('fadeInRightBig', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'fadeInUp'); ?> value="fadeInUp"><?php echo esc_html__('fadeInUp', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'fadeInUpBig'); ?> value="fadeInUpBig"><?php echo esc_html__('fadeInUpBig', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'fadeInTopLeft'); ?> value="fadeInTopLeft"><?php echo esc_html__('fadeInTopLeft', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'fadeInTopRight'); ?> value="fadeInTopRight"><?php echo esc_html__('fadeInTopRight', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'fadeInBottomLeft'); ?> value="fadeInBottomLeft"><?php echo esc_html__('fadeInBottomLeft', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'fadeInBottomRight'); ?> value="fadeInBottomRight"><?php echo esc_html__('fadeInBottomRight', 'qc-btn-menu'); ?></option>
							    </optgroup>
							    <optgroup label="Fading exits">
							    	<option <?php selected( $submenu_animation, 'fadeOut'); ?> value="fadeOut"><?php echo esc_html__('fadeOut', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'fadeOutDown'); ?> value="fadeOutDown"><?php echo esc_html__('fadeOutDown', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'fadeOutDownBig'); ?> value="fadeOutDownBig"><?php echo esc_html__('fadeOutDownBig', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'fadeOutLeft'); ?> value="fadeOutLeft"><?php echo esc_html__('fadeOutLeft', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'fadeOutLeftBig'); ?> value="fadeOutLeftBig"><?php echo esc_html__('fadeOutLeftBig', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'fadeOutRight'); ?> value="fadeOutRight"><?php echo esc_html__('fadeOutRight', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'fadeOutRightBig'); ?> value="fadeOutRightBig"><?php echo esc_html__('fadeOutRightBig', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'fadeOutUp'); ?> value="fadeOutUp"><?php echo esc_html__('fadeOutUp', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'fadeOutUpBig'); ?> value="fadeOutUpBig"><?php echo esc_html__('fadeOutUpBig', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'fadeOutTopLeft'); ?> value="fadeOutTopLeft"><?php echo esc_html__('fadeOutTopLeft', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'fadeOutTopRight'); ?> value="fadeOutTopRight"><?php echo esc_html__('fadeOutTopRight', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'fadeOutBottomRight'); ?> value="fadeOutBottomRight"><?php echo esc_html__('fadeOutBottomRight', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'fadeOutBottomLeft'); ?> value="fadeOutBottomLeft"><?php echo esc_html__('fadeOutBottomLeft', 'qc-btn-menu'); ?></option>
							    </optgroup>
							    <optgroup label="Flippers">
							    	<option <?php selected( $submenu_animation, 'flip'); ?> value="flip"><?php echo esc_html__('flip', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'flipInX'); ?> value="flipInX"><?php echo esc_html__('flipInX', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'flipInY'); ?> value="flipInY"><?php echo esc_html__('flipInY', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'flipOutX'); ?> value="flipOutX"><?php echo esc_html__('flipOutX', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'flipOutY'); ?> value="flipOutY"><?php echo esc_html__('flipOutY', 'qc-btn-menu'); ?></option>
							    </optgroup>
							    <optgroup label="Lightspeed">
							    	<option <?php selected( $submenu_animation, 'lightSpeedInRight'); ?> value="lightSpeedInRight"><?php echo esc_html__('lightSpeedInRight', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'lightSpeedInLeft'); ?> value="lightSpeedInLeft"><?php echo esc_html__('lightSpeedInLeft', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'lightSpeedOutRight'); ?> value="lightSpeedOutRight"><?php echo esc_html__('lightSpeedOutRight', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'lightSpeedOutLeft'); ?> value="lightSpeedOutLeft"><?php echo esc_html__('lightSpeedOutLeft', 'qc-btn-menu'); ?></option>
							    </optgroup>
							    <optgroup label="Rotating entrances">
							    	<option <?php selected( $submenu_animation, 'rotateIn'); ?> value="rotateIn">rotateIn</option>
									<option <?php selected( $submenu_animation, 'rotateInDownLeft'); ?> value="rotateInDownLeft"><?php echo esc_html__('rotateInDownLeft', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'rotateInDownRight'); ?> value="rotateInDownRight"><?php echo esc_html__('rotateInDownRight', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'rotateInUpLeft'); ?> value="rotateInUpLeft"><?php echo esc_html__('rotateInUpLeft', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'rotateInUpRight'); ?> value="rotateInUpRight"><?php echo esc_html__('rotateInUpRight', 'qc-btn-menu'); ?></option>
							    </optgroup>
							    <optgroup label="Rotating exits">
							    	<option <?php selected( $submenu_animation, 'rotateOut'); ?> value="rotateOut"><?php echo esc_html__('rotateOut', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'rotateOutDownLeft'); ?> value="rotateOutDownLeft"><?php echo esc_html__('rotateOutDownLeft', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'rotateOutDownRight'); ?> value="rotateOutDownRight"><?php echo esc_html__('rotateOutDownRight', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'rotateOutUpLeft'); ?> value="rotateOutUpLeft"><?php echo esc_html__('rotateOutUpLeft', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'rotateOutUpRight'); ?> value="rotateOutUpRight"><?php echo esc_html__('rotateOutUpRight', 'qc-btn-menu'); ?></option>
							    </optgroup>
							    <optgroup label="Specials">
							    	<option <?php selected( $submenu_animation, 'hinge'); ?> value="hinge"><?php echo esc_html__('hinge', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'jackInTheBox'); ?> value="jackInTheBox"><?php echo esc_html__('jackInTheBox', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'rollIn'); ?> value="rollIn"><?php echo esc_html__('rollIn', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'rollOut'); ?> value="rollOut"><?php echo esc_html__('rollOut', 'qc-btn-menu'); ?></option>
							    </optgroup>
							    <optgroup label="Zooming entrances">
							    	<option <?php selected( $submenu_animation, 'zoomIn'); ?> value="zoomIn"><?php echo esc_html__('zoomIn', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'zoomInDown'); ?> value="zoomInDown"><?php echo esc_html__('zoomInDown', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'zoomInLeft'); ?> value="zoomInLeft"><?php echo esc_html__('zoomInLeft', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'zoomInRight'); ?> value="zoomInRight"><?php echo esc_html__('zoomInRight', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'zoomInUp'); ?> value="zoomInUp"><?php echo esc_html__('zoomInUp', 'qc-btn-menu'); ?></option>
							    </optgroup>
							    <optgroup label="Sliding entrances">
							    	<option <?php selected( $submenu_animation, 'slideInDown'); ?> value="slideInDown"><?php echo esc_html__('slideInDown', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'slideInLeft'); ?> value="slideInLeft"><?php echo esc_html__('slideInLeft', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'slideInRight'); ?> value="slideInRight"><?php echo esc_html__('slideInRight', 'qc-btn-menu'); ?></option>
									<option <?php selected( $submenu_animation, 'slideInUp'); ?> value="slideInUp"><?php echo esc_html__('slideInUp', 'qc-btn-menu'); ?></option>
							    </optgroup>
							</select>
						</td>
					</tr>
					<tr>
						<th scope="row">
							<label for="qc-btn-menu-button-style"><?php echo esc_html__('Style:', 'qc-btn-menu'); ?></label>
						</th>
						<td>
							<select name="qc-btn-menu-button-style">
								<option <?php selected( $btn_menu_style, 'qcbm-menu-style-default'); ?> value="qcbm-menu-style-default"><?php echo esc_html__('Default', 'qc-btn-menu'); ?></option>
								<option <?php selected( $btn_menu_style, 'qcbm-menu-style-1'); ?> value="qcbm-menu-style-1"><?php echo esc_html__('Style-1', 'qc-btn-menu'); ?></option>
							</select>
						</td>
					</tr>
		


				</tbody>
			</table>
		</div>
		<div class="nav-tab-content" id="tab-2">
			<?php require_once(QC_MB_PATH . 'admin/templates/help.php');?>
		</div>
		<p class="submit">
			<input type="submit" name="submit" id="submit" class="button button-primary" value="<?php echo esc_attr__('Save Changes', 'qc-btn-menu'); ?>">
		</p>
	</form>
</div>