<?php
/**
* Plugin Name: Button Menu - Pro
* Plugin URI: https://www.quantumcloud.com/
* Description: Button Menu
* Version: 1.3.0
* Author: QuantumCloud
* Author URI: https://www.quantumcloud.com/
* Requires at least: 4.6
* Tested up to: 5.9
* Text Domain: qc-btn-menu
* Domain Path: /lang/
* License: GPL2
*
*/

defined('ABSPATH') or die("No direct script access!");


/**
 * Main Class
 */
class QC_Button_Menu
{
	public $item_style = '';
	
	function __construct()
	{
		define( 'QC_MB_VERSION', '1.2.0' );
		define( 'QC_MB_PATH', plugin_dir_path(__FILE__) );
		define( 'QC_MB_URL', plugin_dir_url(__FILE__) );

		add_action('wp_enqueue_scripts', [$this, 'scripts_n_styles'] );
		add_action('admin_enqueue_scripts', [$this, 'admin_scripts_n_styles'] );
		add_action('nav_menu_link_attributes', [$this, 'nav_menu_link_attributes'], 10, 4 );


		add_action('wp_footer', [$this, 'footer_styles'], 10, 4 );
		add_filter('walker_nav_menu_start_el', [$this, 'add_description_to_menu'], 10, 4);
		add_action('nav_menu_submenu_css_class', [$this, 'overrideSubmenuClasses']);

		add_action( 'admin_notices', [ $this, 'button_menu_pro_not_connected_notice' ] );
			
		$this->includes();


		$this->shortcodes();
    	

	}

	public function admin_scripts_n_styles(){
		wp_enqueue_style( 'wp-color-picker' );

		wp_enqueue_style('qc-fontawesome-picker', QC_MB_URL . 'assets/vendors/fontawesome/css/all.min.css', array(), QC_MB_VERSION, 'all');
		wp_enqueue_style('qc-btn-menu-iconpicker', QC_MB_URL . 'assets/vendors/icon-picker/iconpicker-1.5.0.css', array(), QC_MB_VERSION, 'all');
		wp_enqueue_style('qc-menu-button', QC_MB_URL . 'assets/css/admin-style.css', array(), QC_MB_VERSION, 'all');
			

    	wp_enqueue_script( 'wp-color-picker');
    	
   
		wp_enqueue_script('qc-btn-menu-iconpicker', QC_MB_URL . 'assets/vendors/icon-picker/iconpicker-1.5.0.js', array('jquery'), QC_MB_VERSION, false);
			

		wp_enqueue_script('qc-menu-button', QC_MB_URL . 'assets/js/admin-scripts.js', array('jquery', 'jquery-ui-tabs'), QC_MB_VERSION, false);

		
		wp_enqueue_script('qc-menu-button-iconpicker', QC_MB_URL . 'assets/js/admin-icon-scripts.js', array('jquery'), QC_MB_VERSION, false);
		wp_localize_script( 'qc-menu-button', 'qc_menu_button', array(
			'plugin_url' => QC_MB_URL
		));
			
	}



	public function button_menu_pro_not_connected_notice(){

		global $pagenow, $typenow;

		if ( (isset( $_REQUEST['page'] ) && ($_REQUEST['page'] == 'qc_button_menu' || $_REQUEST['page'] == 'button_menu_license_settings') )  || ( $pagenow == 'plugins.php' )  ) {

		       ?>
		            <div id="message" class="error">
		                <p>
		                    <?php
		                    printf(
		                        __('Hi! Your license for  %s Button Menu - Pro %s is not active. Please enter a valid %s license key %s to receive automatic updates, premium support  and front end functionality.', 'dna88-wp-notice'),
		                        '<strong>',
		                        '</strong>',
		                        '<a href="'.esc_url( admin_url('admin.php?page=button_menu_license_settings') ).'" >',
		                        '</a>'
		                    );
		                    ?>
		                </p>
		            </div>
		    <?php 
		    
		}

	}

	public function scripts_n_styles(){
		$container_bg = get_option('qc-btn-menu-container-bg') ? get_option('qc-btn-menu-container-bg') : '#f5f5f5';
		$button_bg = get_option('qc-btn-menu-button-bg') ? get_option('qc-btn-menu-button-bg') : '#fff';
		$button_color = get_option('qc-btn-menu-button-color') ? get_option('qc-btn-menu-button-color') : '#000';

		$button_hover_bg = get_option('qc-btn-menu-button-hover-bg') ? get_option('qc-btn-menu-button-hover-bg') : '#e9e9e9';
		$button_hover_color = get_option('qc-btn-menu-button-hover-color') ? get_option('qc-btn-menu-button-hover-color') : '#000';
		$style = "
                .qc-menu-button-container{
                        background: {$container_bg};
                }
                .qc-menu-button-container li a{
                        background: {$button_bg};
                        color: {$button_color};
                }
                .qc-menu-button-container li a:hover{
					color: {$button_hover_color};
				}
				.qc-menu-button-container li a:before{
					background: {$button_hover_bg};
				}";

		
		wp_register_style( 'qc-menu-button',  QC_MB_URL . 'assets/css/style.css', array(), QC_MB_VERSION, 'all');
		wp_add_inline_style( 'qc-menu-button', $style );
		wp_register_style('qc-btn-menu-fontawesome', QC_MB_URL . 'assets/vendors/fontawesome/css/all.min.css', array(), QC_MB_VERSION, 'all');
		wp_register_style('qc-btn-menu-tooltip', QC_MB_URL . 'assets/vendors/tooltipster/css/tooltipster.bundle.min.css', array(), QC_MB_VERSION, 'all');
		wp_register_style('qc-btn-menu-hover', QC_MB_URL . 'assets/vendors/hover-css/css/hover.css', array(), QC_MB_VERSION, 'all');
		wp_register_style('qc-btn-menu-animate', QC_MB_URL . 'assets/vendors/animate-css/animate.min.css', array(), QC_MB_VERSION, 'all');

		wp_register_script('qc-menu-button-tooltip', QC_MB_URL . 'assets/vendors/tooltipster/js/tooltipster.bundle.min.js', array('jquery'), QC_MB_VERSION, false);
		wp_register_script('qc-menu-button', QC_MB_URL . 'assets/js/scripts.js', array('jquery'), QC_MB_VERSION, false);
		
	}

	public function includes(){
		if( is_admin() ){
			require_once(QC_MB_PATH . 'admin/settings/settings-page.php');
		}

		require_once(QC_MB_PATH . 'admin/custom-fields/menu-item-fields.php');
			
	}

	public function shortcodes(){

			
		add_shortcode( 'qc-button-menu', [$this, 'qc_button_menu_shortcode'] );
    	

	}

	public function qc_button_menu_shortcode($attr){

		
		$menu_list = wp_get_nav_menu_object($attr['menu']);
		$menu_id = $menu_list->term_id;
		$breadcrumb = (isset($attr['breadcrumb']) && $attr['breadcrumb'] === 'true') ? true: true;


				
		$attr = shortcode_atts( array(
			'menu'			=>	$menu_id,
			'container' 		=> '',
			'style' 		=> $attr['style'],
			'menu_class' 		=> 'qc-btn-menu-ul',
			'description' 		=> 'true',
			'show_breadcrumb' 	=> $breadcrumb,
			'breadcrumb_separator' 	=> '/',
			'menu_align' 		=> $attr['menu_align'],
		), $attr );
		wp_enqueue_style('qc-menu-button');

		$container_class = 'qc-menu-button-container';
		if(
			array_key_exists('menu_align', $attr) &&
			in_array($attr['menu_align'], array('left', 'center', 'right'))
		){
			$attr['menu_class'] .= ' pd-menu-align-'.$attr['menu_align'];
		}

		if( $attr['description'] == 'true' ){		
			wp_enqueue_style('qc-btn-menu-tooltip-borderless', QC_MB_URL . 'assets/vendors/tooltipster/css/plugins/tooltipster/sideTip/themes/tooltipster-sideTip-borderless.min.css', array(), QC_MB_VERSION, 'all');
			wp_enqueue_style('qc-btn-menu-tooltip-light', QC_MB_URL . 'assets/vendors/tooltipster/css/plugins/tooltipster/sideTip/themes/tooltipster-sideTip-light.min.css', array(), QC_MB_VERSION, 'all');
			wp_enqueue_style('qc-btn-menu-tooltip-noir', QC_MB_URL . 'assets/vendors/tooltipster/css/plugins/tooltipster/sideTip/themes/tooltipster-sideTip-noir.min.css', array(), QC_MB_VERSION, 'all');
			wp_enqueue_style('qc-btn-menu-tooltip-punk', QC_MB_URL . 'assets/vendors/tooltipster/css/plugins/tooltipster/sideTip/themes/tooltipster-sideTip-punk.min.css', array(), QC_MB_VERSION, 'all');
			wp_enqueue_style('qc-btn-menu-tooltip-shadow', QC_MB_URL . 'assets/vendors/tooltipster/css/plugins/tooltipster/sideTip/themes/tooltipster-sideTip-shadow.min.css', array(), QC_MB_VERSION, 'all');
			wp_enqueue_style('qc-btn-menu-tooltip');
			wp_enqueue_script('qc-menu-button-tooltip');
		}

		wp_enqueue_style('qc-btn-menu-animate');
		wp_enqueue_style('qc-btn-menu-hover');
		wp_enqueue_style('qc-btn-menu-fontawesome');

		wp_enqueue_script('qc-menu-button');
		ob_start();
		$btn_menu_style = get_option('qc-btn-menu-button-style') ? get_option('qc-btn-menu-button-style') : 'qc-menu-style-default';

		$style_name = isset($attr['style']) ? $attr['style'] : '';

		$style = apply_filters('dna88_button_menu_pro_set_style_name', $style_name ) ?  apply_filters('dna88_button_menu_pro_set_style_name',$style_name) : $btn_menu_style;

		//var_dump($style);
		//wp_die();

		if($style == 'qc-menu-style-1'){
			require( QC_MB_PATH . 'templates/shortcode-1.php' );

		}else{

			require( QC_MB_PATH . 'templates/shortcode.php' );
		}
		return ob_get_clean();
			
	}

	public function nav_menu_link_attributes( $atts, $item, $args, $depth ){
		
		if( preg_match('/\bqc-btn-menu-ul\b/', $args->menu_class) ){
			$item_id = $item->ID;
			$button_bg = get_post_meta($item_id, 'qc-btn-menu-button-bg', true) ? get_post_meta($item_id, 'qc-btn-menu-button-bg', true) : '#fff';
			$button_color = get_post_meta($item_id, 'qc-btn-menu-button-color', true) ? get_post_meta($item_id, 'qc-btn-menu-button-color', true) : '#000';
			$button_hover_bg = get_post_meta($item_id, 'qc-btn-menu-button-hover-bg', true) ? get_post_meta($item_id, 'qc-btn-menu-button-hover-bg', true) : '#e9e9e9';
			$button_hover_color = get_post_meta($item_id,'qc-btn-menu-button-hover-color', true) ? get_post_meta($item_id,'qc-btn-menu-button-hover-color', true) : '#000';
			$button_icon = get_post_meta($item_id, 'qc-btn-menu-button-icon', true) ? get_post_meta($item_id,'qc-btn-menu-button-icon', true) : '';

			$btn_hover_animation = get_option('qc-btn-menu-hover-animation') ? get_option('qc-btn-menu-hover-animation') : 'qc-btn-hover-anim-default';
			$submenu_icon = get_option('qc-btn-menu-submenu-icon') ? get_option('qc-btn-menu-submenu-icon') : 'fas fa-arrow-right';

			$atts['class'] = 'qc-btn-menu-link qc-btn-menu-tooltip qc-btn-menu-link-'.$item_id;

			$atts['data-link-item-id'] = $item_id;

			if( $btn_hover_animation ){
				$atts['class'] .= ' '.$btn_hover_animation;
			}

			if (in_array('menu-item-has-children', $item->classes)) {
			    $atts['data-submenu-indicator'] = $submenu_icon;
			}

			if( get_post_meta($item_id, 'qc-btn-menu-button-color', true) ){
				$this->item_style .= ".qc-menu-button-container .qc-btn-menu-ul li a.qc-btn-menu-link-".$item_id."{ background: {$button_bg}; color: {$button_color}; }";
			}

			if( $button_icon ){
				$atts['data-qc-btn-icon'] = $button_icon;
			}
			$atts['data-tooltip-content'] = '#qc-btn-menu-desc-'.$item_id;
    

			if( get_post_meta($item_id, 'qc-btn-menu-button-color', true) ){
				$this->item_style .= ".qc-menu-button-container .qc-btn-menu-ul li a.qc-btn-menu-link-".$item_id.":hover{ color: {$button_hover_color};}";
			}

			if( get_post_meta($item_id, 'qc-btn-menu-button-hover-bg', true) ){
				$this->item_style .= ".qc-menu-button-container .qc-btn-menu-ul li a.qc-btn-menu-link-".$item_id.":before{ background: {$button_hover_bg}; }";
			}
		}
	

		return $atts;
	}

	public function footer_styles(){
		
		wp_register_style( 'qc-btn-menu-shortcode-css', false );
		wp_enqueue_style( 'qc-btn-menu-shortcode-css' );
		wp_add_inline_style( 'qc-btn-menu-shortcode-css', $this->item_style );
			
	}

	public function add_description_to_menu($item_output, $item, $depth, $args) {
		
	   	if (strlen($item->description) > 0 ) {
	      // append description after link
	      $item_output .= sprintf('<div class="tooltip_templates"><div id="%s" class="qc-btn-menu-description">%s</div></div>', esc_attr('qc-btn-menu-desc-'.$item->ID), esc_html($item->description));
	   	}   
			
	   return $item_output;
	}

	public function overrideSubmenuClasses( $classes ) {
		
		$submenu_animation = get_option('qc-btn-menu-submenu-visible-animation') ? get_option('qc-btn-menu-submenu-visible-animation') : '';
		if( isset($submenu_animation) && !empty($submenu_animation) ){
			$class = 'animate__animated animate__'.$submenu_animation;
			$classes[] = $class;
		}
			
	    return $classes;
	}
}

new QC_Button_Menu();



if( !function_exists('dna88_button_menu_pro_set_style_name') ){
add_filter('dna88_button_menu_pro_set_style_name', 'dna88_button_menu_pro_set_style_name', 10, 1);
function dna88_button_menu_pro_set_style_name($style){

        if( $style == 'Default' || $style == 'default'){
             return 'qc-menu-style-default';
        }
        if($style == 'style 1' || $style == 'style-1' || $style == 'Style-1'){
             return 'qc-menu-style-1';
        }

}

}