<?php

function cars1_shortcode($atts, $content = null ) {
    extract( shortcode_atts( array(
		'title' => '',
		'cars' => '',
    ), $atts ) );
	if(!empty($atts['cars'])) {
	    $car = vc_param_group_parse_atts( $atts['cars'] );
	} else { $cars = ''; }
    
    ob_start();
?>
		<div class="cars cars_type_section">
			<div class="container">
                <?php if($title != "") { ?>
				<h2 class="title">
					<span class="title__mark"><?php echo $title; ?></span>
				</h2>
                <?php } if(!empty($car)) {  ?>
				<div class="row">
                    <?php 
					    foreach ( $car as $c_value ) { 
						$thumb_url = wp_get_attachment_image_src($c_value['picture'],'drivingschool_cars-thumb', true);
					?>
					<div class="col-md-3">
                        <?php if(!empty($c_value['picture'])) { ?>
						<div class="cars__fig">
							<img src="<?php echo $thumb_url[0]; ?>" alt="<?php if(!empty($c_value['name'])) { echo $c_value['name']; } ?>" />
						</div>
                        <?php } ?>
						<div class="cars__name"><?php if(!empty($c_value['name'])) { echo $c_value['name']; } ?></div>
						<div class="cars__rating">
                         <?php if($c_value['rating'] >= 1) { ?>
							<svg class="cars__rating-icon"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_star"></use></svg>
                         <?php } if($c_value['rating'] >= 2) { ?>
							<svg class="cars__rating-icon"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_star"></use></svg>
                         <?php } if($c_value['rating'] >= 3) { ?>
							<svg class="cars__rating-icon"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_star"></use></svg>
                         <?php } if($c_value['rating'] >= 4) { ?>
							<svg class="cars__rating-icon"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_star"></use></svg>
                         <?php } if($c_value['rating'] >= 5) { ?>
							<svg class="cars__rating-icon"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_star"></use></svg>
                         <?php } ?>
						</div>
						<div class="cars__transmission"><?php echo $c_value['transmission']; ?></div>
					</div>
                    <?php }  ?>
				</div>
                <?php }  ?>
			</div>
		</div>
<?php
    $output = ob_get_contents();
	ob_end_clean();
	return $output;
}

add_shortcode('cars1', 'cars1_shortcode');
add_action( 'vc_before_init', 'cars1_integrateWithVC' );
function cars1_integrateWithVC() {
    vc_map( array(
        "name" => esc_html__("Cars","drivingschool-plugin"),
        "base" => "cars1",
        "category" => esc_html__('Shortcodes "DrivingSchool"','drivingschool-plugin'),
        "params" => array(
		     array(
                "type" => "",
                "heading" => '<a target="_blank" href="'.esc_url( home_url() ).'/wp-content/plugins/drivingschool-plugin/composer/scrin/s17.png">'.esc_html__('Аppearance of block','drivingschool-plugin').'</a>',
                "param_name" => "scrin_vot",
                "value" => ""
             ),
			 array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Title","drivingschool-plugin"),
                "param_name" => "title",
                "value" => ""
            ),
			array(
                'type' => 'param_group',
                'value' => '',
			    'heading' => esc_html__("Cars","drivingschool-plugin"),
                'param_name' => 'cars',
                'params' => array(
					array(
                        "type" => "textfield",
                        "class" => "",
                        "heading" => esc_html__("Name","drivingschool-plugin"),
                        "param_name" => "name",
                        "value" => ""
                   ),
				   array(
                 'type' => 'attach_image',
                 'value' => '',
                 'heading' => esc_html__("Picture","drivingschool-plugin"),
                 'param_name' => 'picture',
             ),
				   
				    array(
                "type" => "dropdown",
                "class" => "",
                "heading" => esc_html__("Rating","drivingschool-plugin"),
                "param_name" => "rating",
                "value" => array(
				     "5" => "5",
					 "4" => "4",
					 "3" => "3",
					 "2" => "2",
					 "1" => "1",
				)
             ),
			  array(
                "type" => "dropdown",
                "class" => "",
                "heading" => esc_html__("Transmission","drivingschool-plugin"),
                "param_name" => "transmission",
                "value" => array(
				     "Mechanics" => "mechanics",
					 "Automat" => "automat",
				)
             ),

			    )
            ),	

        )
    ));
}

?>