<?php

function video1_shortcode($atts, $content = null ) {
    extract( shortcode_atts( array(
		'title1' => '',
		'title2' => '',
		'picture' => '',
		'video' => '',
    ), $atts ) );
	$thumb_url = wp_get_attachment_image_src($picture,'full', true);
    
    ob_start();
?>
		<div class="video"<?php if($picture != '') { ?> style="background: url(<?php echo $thumb_url[0]; ?>) 50% no-repeat; background-size: cover;"<?php } ?>>
			<div class="container">
				<div class="video__body">
                    <?php if($video != "") { ?>
					<a href="<?php echo $video; ?>" class="video__body-inner">
						<span class="video__play">
							<svg class="video__play-icon"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_play"></use></svg>
						</span>
                         <?php if($title1 != "" or $title2 != "") { ?><h2 class="title video__title"><?php if($title1 != "") { ?><span class="title__mark"><?php echo $title1; ?> </span><?php  } echo $title2; ?></h2>
                        <?php } if($content != "") { ?>
						<p class="desc video__desc"><?php echo $content; ?></p>
                        <?php } ?>
					</a>
                    <?php } ?>
				</div>
			</div>
		</div>
<?php
    $output = ob_get_contents();
	ob_end_clean();
	return $output;
}

add_shortcode('video1', 'video1_shortcode');
add_action( 'vc_before_init', 'video1_integrateWithVC' );
function video1_integrateWithVC() {
    vc_map( array(
        "name" => esc_html__("Video","drivingschool-plugin"),
        "base" => "video1",
        "category" => esc_html__('Shortcodes "DrivingSchool"','drivingschool-plugin'),
        "params" => array(
		     array(
                "type" => "",
                "heading" => '<a target="_blank" href="'.esc_url( home_url() ).'/wp-content/plugins/drivingschool-plugin/composer/scrin/s10.png">'.esc_html__('Аppearance of block','drivingschool-plugin').'</a>',
                "param_name" => "scrin_vot",
                "value" => ""
             ),
			 array(
                 'type' => 'attach_image',
                 'value' => '',
                 'heading' => esc_html__("Background picture","drivingschool-plugin"),
                 'param_name' => 'picture',
             ),
			 array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Title 1","drivingschool-plugin"),
                "param_name" => "title1",
                "value" => ""
            ),
			array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Title 2","drivingschool-plugin"),
                "param_name" => "title2",
                "value" => ""
            ),
			array(
                "type" => "textarea",
                "class" => "",
                "heading" => esc_html__("Text","drivingschool-plugin"),
                "param_name" => "content",
                "value" => ""
            ),
			array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Link vidio","drivingschool-plugin"),
                "param_name" => "video",
                "value" => ""
            ),
			

        )
    ));
}

?>