<?php
if (function_exists("register_field_group")) {
	register_field_group(array(
		'id' => 'acf_feedback-settings',
		'title' => esc_html__('Feedback settings', 'drivingschool-plugin'),
		'fields' => array(
			array(
				'key' => 'field_58ea1c802169a',
				'label' => esc_html__('Feedback', 'drivingschool-plugin'),
				'name' => 'feedback',
				'type' => 'textarea',
				'default_value' => '',
				'placeholder' => '',
				'maxlength' => '',
				'rows' => 5,
				'formatting' => 'html'
			),
			array(
				'key' => 'field_58ea1cb12169b',
				'label' => esc_html__('Email', 'drivingschool-plugin'),
				'name' => 'email',
				'type' => 'text',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => ''
			),
			array(
				'key' => 'field_58ea1cda2169c',
				'label' => esc_html__('Rating', 'drivingschool-plugin'),
				'name' => 'rating',
				'type' => 'text',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => ''
			),
			array(
				'key' => 'field_58ea1e47ea11e',
				'label' => esc_html__('Avatar', 'drivingschool-plugin'),
				'name' => 'avatar',
				'type' => 'image',
				'save_format' => 'id',
				'preview_size' => 'thumbnail',
				'library' => 'all'
			)
		),
		'location' => array(
			array(
				array(
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'review',
					'order_no' => 0,
					'group_no' => 0
				)
			)
		),
		'options' => array(
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array()
		),
		'menu_order' => 1
	));
	register_field_group(array(
		'id' => 'acf_template-about-us',
		'title' => esc_html__('Template "About us"', 'drivingschool-plugin'),
		'fields' => array(
			array(
				'key' => 'field_58e61ff6e1ff3',
				'label' => esc_html__('Blocks', 'drivingschool-plugin'),
				'name' => 'blocks',
				'type' => 'repeater',
				'sub_fields' => array(
					array(
						'key' => 'field_58e62002e1ff4',
						'label' => esc_html__('Title', 'drivingschool-plugin'),
						'name' => 'title',
						'type' => 'text',
						'required' => 1,
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => ''
					),
					array(
						'key' => 'field_58e62019e1ff5',
						'label' => esc_html__('Text', 'drivingschool-plugin'),
						'name' => 'text',
						'type' => 'textarea',
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'maxlength' => '',
						'rows' => 4,
						'formatting' => 'html'
					),
					array(
						'key' => 'field_58e62030e1ff6',
						'label' => esc_html__('Link', 'drivingschool-plugin'),
						'name' => 'link',
						'type' => 'text',
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => ''
					),
					array(
						'key' => 'field_58e62082e1ff7',
						'label' => esc_html__('Picture', 'drivingschool-plugin'),
						'name' => 'picture',
						'type' => 'image',
						'column_width' => '',
						'save_format' => 'id',
						'preview_size' => 'thumbnail',
						'library' => 'all'
					)
				),
				'row_min' => '',
				'row_limit' => '',
				'layout' => 'row',
				'button_label' => esc_html__('Add Block', 'drivingschool-plugin')
			)
		),
		'location' => array(
			array(
				array(
					'param' => 'page_template',
					'operator' => '==',
					'value' => 'page-about.php',
					'order_no' => 0,
					'group_no' => 0
				)
			)
		),
		'options' => array(
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array(
				0 => 'excerpt',
				1 => 'custom_fields',
				2 => 'discussion',
				3 => 'comments',
				4 => 'revisions',
				5 => 'author',
				6 => 'format',
				7 => 'featured_image',
				8 => 'categories',
				9 => 'tags',

				10 => 'send-trackbacks'
			)
		),
		'menu_order' => 1
	));
	register_field_group(array(
		'id' => 'acf_template-contacts',
		'title' => esc_html__('Template "Contacts"', 'drivingschool-plugin'),
		'fields' => array(
			array(
				'key' => 'field_58e5fbc700203',
				'label' => esc_html__('Map', 'drivingschool-plugin'),
				'name' => 'map',
				'type' => 'repeater',
				'sub_fields' => array(
					array(
						'key' => 'field_58e5fbd400204',
						'label' => esc_html__('City', 'drivingschool-plugin'),
						'name' => 'city',
						'type' => 'text',
						'required' => 1,
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => ''
					),
					array(
						'key' => 'field_58e5fbea00205',
						'label' => esc_html__('Coordinate 1', 'drivingschool-plugin'),
						'name' => 'coordinate_1',
						'type' => 'text',
						'instructions' => 'maps.google.ru',
						'required' => 1,
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => ''
					),
					array(
						'key' => 'field_58e5fbf500206',
						'label' => esc_html__('Coordinate 2', 'drivingschool-plugin'),
						'name' => 'coordinate_2',
						'type' => 'text',
						'instructions' => 'maps.google.ru',
						'required' => 1,
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => ''
					)
				),
				'row_min' => '',
				'row_limit' => '',
				'layout' => 'row',
				'button_label' => esc_html__('Add Map', 'drivingschool-plugin')
			),
			array(
				'key' => 'field_58e60348cf331',
				'label' => esc_html__('Address', 'drivingschool-plugin'),
				'name' => 'address',
				'type' => 'repeater',
				'sub_fields' => array(
					array(
						'key' => 'field_58e60367cf332',
						'label' => esc_html__('Text 1', 'drivingschool-plugin'),
						'name' => 'text1',
						'type' => 'text',
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => ''
					),
					array(
						'key' => 'field_58e609d4cf333',
						'label' => esc_html__('Text 2', 'drivingschool-plugin'),
						'name' => 'text2',
						'type' => 'text',
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => ''
					)
				),
				'row_min' => '',
				'row_limit' => '',
				'layout' => 'row',
				'button_label' => esc_html__('Add Address', 'drivingschool-plugin')
			),
			array(
				'key' => 'field_58e609ebcf334',
				'label' => esc_html__('Email', 'drivingschool-plugin'),
				'name' => 'email',
				'type' => 'text',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => ''
			),
			array(
				'key' => 'field_58e60b7cd7659',
				'label' => esc_html__('Form', 'drivingschool-plugin'),
				'name' => 'form',
				'type' => 'select',
				'choices' => array(
					'yes' => esc_html__('Yes', 'drivingschool-plugin'),
					'no' => esc_html__('No', 'drivingschool-plugin')
				),
				'default_value' => '',
				'allow_null' => 0,
				'multiple' => 0
			)
		),
		'location' => array(
			array(
				array(
					'param' => 'page_template',
					'operator' => '==',
					'value' => 'page-contacts.php',
					'order_no' => 0,
					'group_no' => 0
				)
			)
		),
		'options' => array(
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array(
				0 => 'the_content',
				1 => 'excerpt',
				2 => 'custom_fields',
				3 => 'discussion',
				4 => 'comments',
				5 => 'revisions',
				6 => 'author',
				7 => 'format',
				8 => 'featured_image',
				9 => 'categories',
				10 => 'tags',
				11 => 'send-trackbacks'
			)
		),
		'menu_order' => 1
	));
	register_field_group(array(
		'id' => 'acf_template-courses',
		'title' => esc_html__('Template "Courses"', 'drivingschool-plugin'),
		'fields' => array(
			array(
				'key' => 'field_58e9fb53c3ada',
				'label' => esc_html__('Courses', 'drivingschool-plugin'),
				'name' => '',
				'type' => 'tab'
			),
			array(
				'key' => 'field_58e9f862718a8',
				'label' => esc_html__('Courses', 'drivingschool-plugin'),
				'name' => 'courses',
				'type' => 'repeater',
				'sub_fields' => array(
					array(
						'key' => 'field_58e9f998718a9',
						'label' => esc_html__('Title', 'drivingschool-plugin'),
						'name' => 'title',
						'type' => 'text',
						'required' => 1,
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => ''
					),
					array(
						'key' => 'field_58e9f9a4718aa',
						'label' => esc_html__('Duration', 'drivingschool-plugin'),
						'name' => 'duration',
						'type' => 'text',
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => ''
					),
					array(
						'key' => 'field_58e9f9b9718ab',
						'label' => esc_html__('Automatic', 'drivingschool-plugin'),
						'name' => 'automatic',
						'type' => 'text',
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => ''
					),
					array(
						'key' => 'field_58e9f9be718ac',
						'label' => esc_html__('Mechanics', 'drivingschool-plugin'),
						'name' => 'mechanics',
						'type' => 'text',
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => ''
					),
					array(
						'key' => 'field_58e9f9de718ad',
						'label' => esc_html__('Texts', 'drivingschool-plugin'),
						'name' => 'texts',
						'type' => 'repeater',
						'column_width' => '',
						'sub_fields' => array(
							array(
								'key' => 'field_58e9f9ef718ae',
								'label' => esc_html__('Text', 'drivingschool-plugin'),
								'name' => 'text',
								'type' => 'text',
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'formatting' => 'html',
								'maxlength' => ''
							)
						),
						'row_min' => '',
						'row_limit' => '',
						'layout' => 'table',
						'button_label' => esc_html__('Add text', 'drivingschool-plugin')
					),
					array(
						'key' => 'field_58e9fa20718af',
						'label' => esc_html__('Picture', 'drivingschool-plugin'),
						'name' => 'picture',
						'type' => 'image',
						'column_width' => '',
						'save_format' => 'id',
						'preview_size' => 'medium',
						'library' => 'all'
					),
					array(
						'key' => 'field_58e9fc2728e2e',
						'label' => esc_html__('Icon', 'drivingschool-plugin'),
						'name' => 'icon_form',
						'type' => 'image',
						'column_width' => '',
						'save_format' => 'url',
						'preview_size' => 'thumbnail',
						'library' => 'all'
					),
					array(
						'key' => 'field_58e9fb09718b0',
						'label' => esc_html__('Form', 'drivingschool-plugin'),
						'name' => 'form',
						'type' => 'select',
						'column_width' => '',
						'choices' => array(
							'yes' => esc_html__('Yes', 'drivingschool-plugin'),
							'no' => esc_html__('No', 'drivingschool-plugin')
						),
						'default_value' => '',
						'allow_null' => 0,
						'multiple' => 0
					)
				),
				'row_min' => '',
				'row_limit' => '',
				'layout' => 'row',
				'button_label' => esc_html__('Add Course', 'drivingschool-plugin')
			),
			array(
				'key' => 'field_58ea06c6d21b9',
				'label' => esc_html__('Blocks', 'drivingschool-plugin'),
				'name' => '',
				'type' => 'tab'
			),
			array(
				'key' => 'field_58ea06d0d21ba',
				'label' => esc_html__('Blocks', 'drivingschool-plugin'),
				'name' => 'blocks',
				'type' => 'repeater',
				'sub_fields' => array(
					array(
						'key' => 'field_58ea0716d21bb',
						'label' => esc_html__('Text', 'drivingschool-plugin'),
						'name' => 'text',
						'type' => 'text',
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => ''
					),
					array(
						'key' => 'field_58ea0756d21bc',
						'label' => esc_html__('Background icon', 'drivingschool-plugin'),
						'name' => 'background_icon',
						'type' => 'select',
						'column_width' => '',
						'choices' => array(
							'course__item_none' => esc_html__('None', 'drivingschool-plugin'),
							'course__item_consultation' => esc_html__('Consultation', 'drivingschool-plugin'),
							'course__item_police' => esc_html__('Police', 'drivingschool-plugin')
						),
						'default_value' => '',
						'allow_null' => 0,
						'multiple' => 0
					)
				),
				'row_min' => '',
				'row_limit' => '',
				'layout' => 'row',
				'button_label' => esc_html__('Add Block', 'drivingschool-plugin')
			)
		),
		'location' => array(
			array(
				array(
					'param' => 'page_template',
					'operator' => '==',
					'value' => 'page-course.php',
					'order_no' => 0,
					'group_no' => 0
				)
			)
		),
		'options' => array(
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array(
				0 => 'the_content',
				1 => 'excerpt',
				2 => 'custom_fields',
				3 => 'discussion',
				4 => 'comments',
				5 => 'revisions',
				6 => 'author',
				7 => 'format',
				8 => 'featured_image',
				9 => 'categories',
				10 => 'tags',
				11 => 'send-trackbacks'
			)
		),
		'menu_order' => 1
	));
	register_field_group(array(
		'id' => 'acf_template-faq',
		'title' => esc_html__('Template "FAQ"', 'drivingschool-plugin'),
		'fields' => array(
			array(
				'key' => 'field_58e634e0eea15',
				'label' => esc_html__('Blocks', 'drivingschool-plugin'),
				'name' => 'blocks',
				'type' => 'repeater',
				'sub_fields' => array(
					array(
						'key' => 'field_58e63547eea16',
						'label' => esc_html__('Title', 'drivingschool-plugin'),
						'name' => 'title',
						'type' => 'text',
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => ''
					),
					array(
						'key' => 'field_58e63620eea17',
						'label' => esc_html__('Background image', 'drivingschool-plugin'),
						'name' => 'image',
						'type' => 'image',
						'column_width' => '',
						'save_format' => 'url',
						'preview_size' => 'thumbnail',
						'library' => 'all'
					),
					array(
						'key' => 'field_58e63699eea18',
						'label' => esc_html__('Questions', 'drivingschool-plugin'),
						'name' => 'questions',
						'type' => 'repeater',
						'column_width' => '',
						'sub_fields' => array(
							array(
								'key' => 'field_58e636cceea19',
								'label' => esc_html__('Question', 'drivingschool-plugin'),
								'name' => 'question',
								'type' => 'text',
								'required' => 1,
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'formatting' => 'html',
								'maxlength' => ''
							),
							array(
								'key' => 'field_58e636f6eea1a',
								'label' => esc_html__('Answer', 'drivingschool-plugin'),
								'name' => 'answer',
								'type' => 'textarea',
								'required' => 1,
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '',
								'maxlength' => '',
								'rows' => 4,
								'formatting' => 'html'
							),
							array(
								'key' => 'field_58e63726eea1b',
								'label' => esc_html__('Active?', 'drivingschool-plugin'),
								'name' => 'active',
								'type' => 'checkbox',
								'column_width' => '',
								'choices' => array(
									'faq__item_active' => esc_html__('Yes', 'drivingschool-plugin')
								),
								'default_value' => '',
								'layout' => 'vertical'
							)
						),
						'row_min' => '',
						'row_limit' => '',
						'layout' => 'row',
						'button_label' => esc_html__('Add question', 'drivingschool-plugin')
					)
				),
				'row_min' => '',
				'row_limit' => '',
				'layout' => 'row',
				'button_label' => esc_html__('Add Block', 'drivingschool-plugin')
			),
			array(
				'key' => 'field_58e638d2e9897',
				'label' => esc_html__('Form', 'drivingschool-plugin'),
				'name' => 'form',
				'type' => 'select',
				'choices' => array(
					'yes' => esc_html__('Yes', 'drivingschool-plugin'),
					'no' => esc_html__('No', 'drivingschool-plugin')
				),
				'default_value' => '',
				'allow_null' => 0,
				'multiple' => 0
			)
		),
		'location' => array(
			array(
				array(
					'param' => 'page_template',
					'operator' => '==',
					'value' => 'page-faq.php',
					'order_no' => 0,
					'group_no' => 0
				)
			)
		),
		'options' => array(
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array(
				0 => 'excerpt',
				1 => 'custom_fields',
				2 => 'discussion',
				3 => 'comments',
				4 => 'revisions',
				5 => 'author',
				6 => 'format',
				7 => 'featured_image',
				8 => 'categories',
				9 => 'tags',
				10 => 'send-trackbacks'
			)
		),
		'menu_order' => 1
	));
	register_field_group(array(
		'id' => 'acf_template-features',
		'title' => esc_html__('Template "Features"', 'drivingschool-plugin'),
		'fields' => array(
			array(
				'key' => 'field_58e628afdeb0a',
				'label' => esc_html__('Blocks', 'drivingschool-plugin'),
				'name' => 'blocks',
				'type' => 'repeater',
				'sub_fields' => array(
					array(
						'key' => 'field_58e629c9deb0b',
						'label' => esc_html__('Icon', 'drivingschool-plugin'),
						'name' => 'icon',
						'type' => 'text',
						'instructions' => '<a target="_blank" href="../wp-content/plugins/drivingschool-plugin/icons.php">'.esc_html__('Icons','drivingschool-plugin').'</a>',
						'required' => 1,
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => ''
					),
					array(
						'key' => 'field_58e62a0ddeb0c',
						'label' => esc_html__('Title', 'drivingschool-plugin'),
						'name' => 'title',
						'type' => 'text',
						'required' => 1,
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => ''
					),
					array(
						'key' => 'field_58e62a15deb0d',
						'label' => esc_html__('Text', 'drivingschool-plugin'),
						'name' => 'text',
						'type' => 'text',
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => ''
					)
				),
				'row_min' => '',
				'row_limit' => '',
				'layout' => 'row',
				'button_label' => esc_html__('Add Block', 'drivingschool-plugin')
			)
		),
		'location' => array(
			array(
				array(
					'param' => 'page_template',
					'operator' => '==',
					'value' => 'page-feature.php',
					'order_no' => 0,
					'group_no' => 0
				)
			)
		),
		'options' => array(
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array(
				0 => 'excerpt',
				1 => 'custom_fields',
				2 => 'discussion',
				3 => 'comments',
				4 => 'revisions',
				5 => 'author',
				6 => 'format',
				7 => 'featured_image',
				8 => 'categories',
				9 => 'tags',
				10 => 'send-trackbacks'
			)
		),
		'menu_order' => 1
	));
	register_field_group(array(
		'id' => 'acf_template-photo',
		'title' => esc_html__('Template "Photo"', 'drivingschool-plugin'),
		'fields' => array(
			array(
				'key' => 'field_58e616261e30d',
				'label' => esc_html__('Blocks', 'drivingschool-plugin'),
				'name' => 'blocks',
				'type' => 'repeater',
				'sub_fields' => array(
					array(
						'key' => 'field_58e6165a1e30e',
						'label' => esc_html__('Title', 'drivingschool-plugin'),
						'name' => 'title',
						'type' => 'text',
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => ''
					),
					array(
						'key' => 'field_58e616c81e30f',
						'label' => esc_html__('Photo', 'drivingschool-plugin'),
						'name' => 'photo',
						'type' => 'repeater',
						'column_width' => '',
						'sub_fields' => array(
							array(
								'key' => 'field_58e617181e310',
								'label' => esc_html__('Picture', 'drivingschool-plugin'),
								'name' => 'picture',
								'type' => 'image',
								'required' => 1,
								'column_width' => '',
								'save_format' => 'object',
								'preview_size' => 'thumbnail',
								'library' => 'all'
							)
						),
						'row_min' => '',
						'row_limit' => '',
						'layout' => 'row',
						'button_label' => esc_html__('Add photo', 'drivingschool-plugin')
					)
				),
				'row_min' => '',
				'row_limit' => '',
				'layout' => 'row',
				'button_label' => esc_html__('Add Block', 'drivingschool-plugin')
			)
		),
		'location' => array(
			array(
				array(
					'param' => 'page_template',
					'operator' => '==',
					'value' => 'page-photo.php',
					'order_no' => 0,
					'group_no' => 0
				)
			)
		),
		'options' => array(
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array(
				0 => 'the_content',
				1 => 'excerpt',
				2 => 'custom_fields',
				3 => 'discussion',
				4 => 'comments',
				5 => 'revisions',
				6 => 'slug',
				7 => 'author',
				8 => 'featured_image',
				9 => 'categories',
				10 => 'tags',
				11 => 'send-trackbacks'
			)
		),
		'menu_order' => 1
	));
	register_field_group(array(
		'id' => 'acf_template-price',
		'title' => esc_html__('Template "Price"', 'drivingschool-plugin'),
		'fields' => array(
			array(
				'key' => 'field_58e64df6ec047',
				'label' => esc_html__('Tariff plans', 'drivingschool-plugin'),
				'name' => '',
				'type' => 'tab'
			),
			array(
				'key' => 'field_58e64e02ec048',
				'label' => esc_html__('Display?', 'drivingschool-plugin'),
				'name' => 'display',
				'type' => 'select',
				'choices' => array(
					'yes' => esc_html__('Yes', 'drivingschool-plugin'),
					'no' => esc_html__('No', 'drivingschool-plugin')
				),
				'default_value' => '',
				'allow_null' => 0,
				'multiple' => 0
			),
			array(
				'key' => 'field_58e6503c5a895',
				'label' => esc_html__('Plan 1', 'drivingschool-plugin'),
				'name' => '',
				'type' => 'tab'
			),
			array(
				'key' => 'field_58e650b74a087',
				'label' => esc_html__('Name', 'drivingschool-plugin'),
				'name' => 'name1',
				'type' => 'text',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => ''
			),
			array(
				'key' => 'field_58e651364a088',
				'label' => esc_html__('Price', 'drivingschool-plugin'),
				'name' => 'price1',
				'type' => 'text',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => ''
			),
			array(
				'key' => 'field_58e652fc5f193',
				'label' => esc_html__('Discount', 'drivingschool-plugin'),
				'name' => 'discount1',
				'type' => 'text',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => ''
			),
			array(
				'key' => 'field_58e651614a089',
				'label' => esc_html__('Description', 'drivingschool-plugin'),
				'name' => 'description1',
				'type' => 'repeater',
				'sub_fields' => array(
					array(
						'key' => 'field_58e651de4a08a',
						'label' => esc_html__('Text', 'drivingschool-plugin'),
						'name' => 'text',
						'type' => 'text',
						'column_width' => '',
						'default_value' => '',

						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => ''
					)
				),
				'row_min' => '',
				'row_limit' => '',
				'layout' => 'table',
				'button_label' => esc_html__('Add Row', 'drivingschool-plugin')
			),
			array(
				'key' => 'field_58e6520a4a08b',
				'label' => esc_html__('Form', 'drivingschool-plugin'),
				'name' => 'form1',
				'type' => 'select',
				'choices' => array(
					'yes' => esc_html__('Yes', 'drivingschool-plugin'),
					'no' => esc_html__('No', 'drivingschool-plugin')
				),
				'default_value' => '',
				'allow_null' => 0,
				'multiple' => 0
			),
			array(
				'key' => 'field_58e6535d0bd50',
				'label' => esc_html__('Plan 2', 'drivingschool-plugin'),
				'name' => '',
				'type' => 'tab'
			),
			array(
				'key' => 'field_58e653670bd51',
				'label' => esc_html__('Name', 'drivingschool-plugin'),
				'name' => 'name2',
				'type' => 'text',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => ''
			),
			array(
				'key' => 'field_58e653710bd52',
				'label' => esc_html__('Price', 'drivingschool-plugin'),
				'name' => 'price2',
				'type' => 'text',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => ''
			),
			array(
				'key' => 'field_58e653790bd53',
				'label' => esc_html__('Discount', 'drivingschool-plugin'),
				'name' => 'discount2',
				'type' => 'text',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => ''
			),
			array(
				'key' => 'field_58e653840bd54',
				'label' => esc_html__('Description', 'drivingschool-plugin'),
				'name' => 'description2',
				'type' => 'repeater',
				'sub_fields' => array(
					array(
						'key' => 'field_58e653900bd55',
						'label' => esc_html__('Text', 'drivingschool-plugin'),
						'name' => 'text',
						'type' => 'text',
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => ''
					)
				),
				'row_min' => '',
				'row_limit' => '',
				'layout' => 'table',
				'button_label' => esc_html__('Add Text', 'drivingschool-plugin')
			),
			array(
				'key' => 'field_58e6539b0bd56',
				'label' => esc_html__('Form', 'drivingschool-plugin'),
				'name' => 'form2',
				'type' => 'select',
				'choices' => array(
					'yes' => esc_html__('Yes', 'drivingschool-plugin'),
					'no' => esc_html__('No', 'drivingschool-plugin')
				),
				'default_value' => '',
				'allow_null' => 0,
				'multiple' => 0
			),
			array(
				'key' => 'field_58e6546731ca5',
				'label' => esc_html__('Plan 3', 'drivingschool-plugin'),
				'name' => '',
				'type' => 'tab'
			),
			array(
				'key' => 'field_58e6547831ca6',
				'label' => esc_html__('Name', 'drivingschool-plugin'),
				'name' => 'name3',
				'type' => 'text',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => ''
			),
			array(
				'key' => 'field_58e6548531ca7',
				'label' => esc_html__('Price', 'drivingschool-plugin'),
				'name' => 'price3',
				'type' => 'text',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => ''
			),
			array(
				'key' => 'field_58e6548c31ca8',
				'label' => esc_html__('Discount', 'drivingschool-plugin'),
				'name' => 'discount3',
				'type' => 'text',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => ''
			),
			array(
				'key' => 'field_58e6549631ca9',
				'label' => esc_html__('Description', 'drivingschool-plugin'),
				'name' => 'description3',
				'type' => 'repeater',
				'sub_fields' => array(
					array(
						'key' => 'field_58e654a031caa',
						'label' => esc_html__('Text', 'drivingschool-plugin'),
						'name' => 'text',
						'type' => 'text',
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => ''
					)
				),
				'row_min' => '',
				'row_limit' => '',
				'layout' => 'table',
				'button_label' => esc_html__('Add Text', 'drivingschool-plugin')
			),
			array(
				'key' => 'field_58e654a931cab',
				'label' => esc_html__('Form', 'drivingschool-plugin'),
				'name' => 'form3',
				'type' => 'select',
				'choices' => array(
					'yes' => esc_html__('Yes', 'drivingschool-plugin'),
					'no' => esc_html__('No', 'drivingschool-plugin')
				),
				'default_value' => '',
				'allow_null' => 0,
				'multiple' => 0
			),
			array(
				'key' => 'field_58e663af47898',
				'label' => esc_html__('Offer', 'drivingschool-plugin'),
				'name' => '',
				'type' => 'tab'
			),
			array(
				'key' => 'field_58e663ce47899',
				'label' => esc_html__('Display?', 'drivingschool-plugin'),
				'name' => 'display2',
				'type' => 'select',
				'choices' => array(
					'yes' => esc_html__('Yes', 'drivingschool-plugin'),
					'no' => esc_html__('No', 'drivingschool-plugin')
				),
				'default_value' => '',
				'allow_null' => 0,
				'multiple' => 0
			),
			array(
				'key' => 'field_58e67566f4d5b',
				'label' => esc_html__('Background image', 'drivingschool-plugin'),
				'name' => 'image',
				'type' => 'image',
				'save_format' => 'url',
				'preview_size' => 'thumbnail',
				'library' => 'all'
			),
			array(
				'key' => 'field_58e673654789a',
				'label' => esc_html__('Title', 'drivingschool-plugin'),
				'name' => 'title',
				'type' => 'text',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => ''
			),
			array(
				'key' => 'field_58e6737d4789b',
				'label' => esc_html__('Text', 'drivingschool-plugin'),
				'name' => 'text',
				'type' => 'text',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => ''
			),
			array(
				'key' => 'field_58e6738b4789c',
				'label' => esc_html__('Form', 'drivingschool-plugin'),
				'name' => 'form4',
				'type' => 'select',
				'choices' => array(
					'yes' => esc_html__('Yes', 'drivingschool-plugin'),
					'no' => esc_html__('No', 'drivingschool-plugin')
				),
				'default_value' => '',
				'allow_null' => 0,
				'multiple' => 0
			),
			array(
				'key' => 'field_58e673c94789d',
				'label' => esc_html__('Name plan', 'drivingschool-plugin'),
				'name' => 'name4',
				'type' => 'text',
				'conditional_logic' => array(
					'status' => 1,
					'rules' => array(
						array(
							'field' => 'field_58e6738b4789c',
							'operator' => '==',
							'value' => 'yes'
						)
					),
					'allorany' => 'all'
				),
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => ''
			),
			array(
				'key' => 'field_58e673ec4789e',
				'label' => esc_html__('Price', 'drivingschool-plugin'),
				'name' => 'price4',
				'type' => 'text',
				'conditional_logic' => array(
					'status' => 1,
					'rules' => array(
						array(
							'field' => 'field_58e6738b4789c',
							'operator' => '==',
							'value' => 'yes'
						)
					),
					'allorany' => 'all'
				),
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => ''
			),
			array(
				'key' => 'field_58e6741c4789f',
				'label' => esc_html__('Bestsellers', 'drivingschool-plugin'),
				'name' => 'bestsellers',
				'type' => 'select',
				'conditional_logic' => array(
					'status' => 1,
					'rules' => array(
						array(
							'field' => 'field_58e6738b4789c',
							'operator' => '==',
							'value' => 'yes'
						)
					),
					'allorany' => 'all'
				),
				'choices' => array(
					'yes' => esc_html__('Yes', 'drivingschool-plugin'),
					'no' => esc_html__('No', 'drivingschool-plugin')
				),
				'default_value' => '',
				'allow_null' => 0,
				'multiple' => 0
			),
			array(
				'key' => 'field_58e76b6de4619',
				'label' => esc_html__('Course', 'drivingschool-plugin'),
				'name' => '',
				'type' => 'tab'
			),
			array(
				'key' => 'field_58e76b79e461a',
				'label' => esc_html__('Display?', 'drivingschool-plugin'),
				'name' => 'display3',
				'type' => 'select',
				'choices' => array(
					'yes' => esc_html__('Yes', 'drivingschool-plugin'),
					'no' => esc_html__('No', 'drivingschool-plugin')
				),
				'default_value' => '',
				'allow_null' => 0,
				'multiple' => 0
			),
			array(
				'key' => 'field_58e76bbde461b',
				'label' => esc_html__('Title', 'drivingschool-plugin'),
				'name' => 'title2',
				'type' => 'text',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => ''
			),
			array(
				'key' => 'field_58e76befe461c',
				'label' => esc_html__('Text', 'drivingschool-plugin'),
				'name' => 'text2',
				'type' => 'text',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => ''
			),
			array(
				'key' => 'field_58e76cc0c8e7b',
				'label' => esc_html__('Courses', 'drivingschool-plugin'),
				'name' => 'courses',
				'type' => 'repeater',
				'sub_fields' => array(
					array(
						'key' => 'field_58e76e92d4abc',
						'label' => esc_html__('Block type', 'drivingschool-plugin'),
						'name' => 'block_type',
						'type' => 'select',
						'column_width' => '',
						'choices' => array(
							'text' => esc_html__('Title and text', 'drivingschool-plugin'),
							'title' => esc_html__('Title', 'drivingschool-plugin')
						),
						'default_value' => '',
						'allow_null' => 0,
						'multiple' => 0
					),
					array(
						'key' => 'field_58e76d3fc8e7c',
						'label' => esc_html__('Title', 'drivingschool-plugin'),
						'name' => 'title',
						'type' => 'text',
						'required' => 1,
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => ''
					),
					array(
						'key' => 'field_58e76d5ac8e7d',
						'label' => esc_html__('Icon', 'drivingschool-plugin'),
						'name' => 'icon',
						'type' => 'text',
						'instructions' => '<a target="_blank" href="../wp-content/plugins/drivingschool-plugin/icons.php">'.esc_html__('Icons','drivingschool-plugin').'</a>',
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => ''
					),
					array(
						'key' => 'field_58e76dd6c8e7e',
						'label' => esc_html__('Duration', 'drivingschool-plugin'),
						'name' => 'duration',
						'type' => 'text',
						'conditional_logic' => array(
							'status' => 1,
							'rules' => array(
								array(
									'field' => 'field_58e76e92d4abc',
									'operator' => '==',
									'value' => 'text'
								)
							),
							'allorany' => 'all'
						),
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => ''
					),
					array(
						'key' => 'field_58e76e11c8e7f',
						'label' => esc_html__('Automatic', 'drivingschool-plugin'),
						'name' => 'automatic',
						'type' => 'text',
						'conditional_logic' => array(
							'status' => 1,
							'rules' => array(
								array(
									'field' => 'field_58e76e92d4abc',
									'operator' => '==',
									'value' => 'text'
								)
							),
							'allorany' => 'all'
						),
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => ''
					),
					array(
						'key' => 'field_58e76e23c8e80',
						'label' => esc_html__('Mechanics', 'drivingschool-plugin'),
						'name' => 'mechanics',
						'type' => 'text',
						'conditional_logic' => array(
							'status' => 1,
							'rules' => array(
								array(
									'field' => 'field_58e76e92d4abc',
									'operator' => '==',
									'value' => 'text'
								)
							),
							'allorany' => 'all'
						),
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => ''
					),
					array(
						'key' => 'field_58e7700fe046d',
						'label' => esc_html__('Link', 'drivingschool-plugin'),
						'name' => 'link',
						'type' => 'text',
						'conditional_logic' => array(
							'status' => 1,
							'rules' => array(
								array(
									'field' => 'field_58e76e92d4abc',
									'operator' => '==',
									'value' => 'text'
								)
							),
							'allorany' => 'all'
						),
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => ''
					),
					array(
						'key' => 'field_58e7707ee046e',
						'label' => esc_html__('Form', 'drivingschool-plugin'),
						'name' => 'form',
						'type' => 'select',
						'conditional_logic' => array(
							'status' => 1,
							'rules' => array(
								array(
									'field' => 'field_58e76e92d4abc',
									'operator' => '==',
									'value' => 'text'
								)
							),
							'allorany' => 'all'
						),
						'column_width' => '',
						'choices' => array(
							'yes' => esc_html__('Yes', 'drivingschool-plugin'),
							'no' => esc_html__('No', 'drivingschool-plugin')
						),
						'default_value' => '',
						'allow_null' => 0,
						'multiple' => 0
					),
					array(
						'key' => 'field_58e775328164c',
						'label' => esc_html__('Background icon', 'drivingschool-plugin'),
						'name' => 'background_icon',
						'type' => 'select',
						'conditional_logic' => array(
							'status' => 1,
							'rules' => array(
								array(
									'field' => 'field_58e76e92d4abc',
									'operator' => '==',
									'value' => 'title'
								)
							),
							'allorany' => 'all'
						),
						'column_width' => '',
						'choices' => array(
							'course__item_none' => esc_html__('None', 'drivingschool-plugin'),
							'course__item_consultation' => esc_html__('Consultation', 'drivingschool-plugin'),
							'course__item_police' => esc_html__('Ppolice', 'drivingschool-plugin')
						),
						'default_value' => '',
						'allow_null' => 0,
						'multiple' => 0
					),
					array(
						'key' => 'field_58e7816b1ceac',
						'label' => esc_html__('Icon - form', 'drivingschool-plugin'),
						'name' => 'icon_form',
						'type' => 'image',
						'conditional_logic' => array(
							'status' => 1,
							'rules' => array(
								array(
									'field' => 'field_58e7707ee046e',
									'operator' => '==',
									'value' => 'yes'
								),
								array(
									'field' => 'field_58e76e92d4abc',
									'operator' => '==',
									'value' => 'text'
								)
							),
							'allorany' => 'all'
						),
						'column_width' => '',
						'save_format' => 'url',
						'preview_size' => 'thumbnail',
						'library' => 'all'
					),
					array(
						'key' => 'field_58e781fb1cead',
						'label' => esc_html__('Image - form', 'drivingschool-plugin'),
						'name' => 'image_form',
						'type' => 'image',
						'conditional_logic' => array(
							'status' => 1,
							'rules' => array(
								array(
									'field' => 'field_58e7707ee046e',
									'operator' => '==',
									'value' => 'yes'
								),
								array(
									'field' => 'field_58e76e92d4abc',
									'operator' => '==',
									'value' => 'text'
								)
							),
							'allorany' => 'all'
						),
						'column_width' => '',
						'save_format' => 'id',
						'preview_size' => 'thumbnail',
						'library' => 'all'
					),
					array(
						'key' => 'field_58e787434aed8',
						'label' => esc_html__('Text', 'drivingschool-plugin'),
						'name' => 'texts',
						'type' => 'repeater',
						'conditional_logic' => array(
							'status' => 1,
							'rules' => array(
								array(
									'field' => 'field_58e7707ee046e',
									'operator' => '==',
									'value' => 'yes'
								),
								array(
									'field' => 'field_58e76e92d4abc',
									'operator' => '==',
									'value' => 'text'
								)
							),
							'allorany' => 'all'
						),
						'column_width' => '',
						'sub_fields' => array(
							array(
								'key' => 'field_58e7875c4aed9',
								'label' => esc_html__('Text', 'drivingschool-plugin'),
								'name' => 'text',
								'type' => 'text',
								'required' => 1,
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'formatting' => 'html',
								'maxlength' => ''
							)
						),
						'row_min' => '',
						'row_limit' => '',
						'layout' => 'row',
						'button_label' => esc_html__('Add text', 'drivingschool-plugin')
					)
				),
				'row_min' => '',
				'row_limit' => '',
				'layout' => 'row',
				'button_label' => esc_html__('Add Course', 'drivingschool-plugin')
			)
		),
		'location' => array(
			array(
				array(
					'param' => 'page_template',
					'operator' => '==',
					'value' => 'page-price.php',
					'order_no' => 0,
					'group_no' => 0
				)
			)
		),
		'options' => array(
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array(
				0 => 'excerpt',
				1 => 'custom_fields',
				2 => 'discussion',
				3 => 'comments',
				4 => 'revisions',
				5 => 'author',
				6 => 'format',
				7 => 'featured_image',
				8 => 'categories',
				9 => 'tags',
				10 => 'send-trackbacks'
			)
		),
		'menu_order' => 1
	));
	register_field_group(array(
		'id' => 'acf_template-review',
		'title' => esc_html__('Template "Review"', 'drivingschool-plugin'),
		'fields' => array(
			array(
				'key' => 'field_58ea0bc378160',
				'label' => esc_html__('Number of reviews', 'drivingschool-plugin'),
				'name' => 'number_reviews',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'min' => '',
				'max' => '',
				'step' => ''
			),
			array(
				'key' => 'field_58ea638dfb29a',
				'label' => esc_html__('Pagination navigation', 'drivingschool-plugin'),
				'name' => 'pagination',
				'type' => 'select',
				'choices' => array(
					'yes' => esc_html__('Yes', 'drivingschool-plugin'),
					'no' => esc_html__('No', 'drivingschool-plugin')
				),
				'default_value' => '',
				'allow_null' => 0,
				'multiple' => 0
			),
			array(
				'key' => 'field_58ea6413fb29b',
				'label' => esc_html__('Form', 'drivingschool-plugin'),
				'name' => 'form',
				'type' => 'select',
				'choices' => array(
					'yes' => esc_html__('Yes', 'drivingschool-plugin'),
					'no' => esc_html__('No', 'drivingschool-plugin')
				),
				'default_value' => '',
				'allow_null' => 0,
				'multiple' => 0
			)
		),
		'location' => array(
			array(
				array(
					'param' => 'page_template',
					'operator' => '==',
					'value' => 'page-review.php',
					'order_no' => 0,
					'group_no' => 0
				)
			)
		),
		'options' => array(
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array(
				0 => 'the_content',
				1 => 'excerpt',
				2 => 'custom_fields',
				3 => 'discussion',
				4 => 'comments',
				5 => 'revisions',
				6 => 'author',
				7 => 'format',
				8 => 'featured_image',
				9 => 'categories',
				10 => 'tags',
				11 => 'send-trackbacks'
			)
		),
		'menu_order' => 1
	));
	register_field_group(array(
		'id' => 'acf_template-teacher',
		'title' => esc_html__('Template «Teacher»', 'drivingschool-plugin'),
		'fields' => array(
			array(
				'key' => 'field_58ef6cb844d3d',
				'label' => esc_html__('Settings', 'drivingschool-plugin'),
				'name' => '',
				'type' => 'tab'
			),
			array(
				'key' => 'field_58ef66c8b70fa',
				'label' => esc_html__('E-mail', 'drivingschool-plugin'),
				'name' => 'e-mail',
				'type' => 'text',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => ''
			),
			array(
				'key' => 'field_58ef6cd744d3f',
				'label' => esc_html__('Rating', 'drivingschool-plugin'),
				'name' => 'rating',
				'type' => 'select',
				'choices' => array(
					5 => 5,
					4 => 4,
					3 => 3,
					2 => 2,
					1 => 1,
					'none' => esc_html__('None', 'drivingschool-plugin')
				),
				'default_value' => '',
				'allow_null' => 0,
				'multiple' => 0
			),
			array(
				'key' => 'field_58ef6f79ff7a8',
				'label' => esc_html__('Price', 'drivingschool-plugin'),
				'name' => 'price',
				'type' => 'text',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => ''
			),
			array(
				'key' => 'field_58ef6e0bd353e',
				'label' => esc_html__('Categories', 'drivingschool-plugin'),
				'name' => 'categories',
				'type' => 'text',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => ''
			),
			array(
				'key' => 'field_58ef6ed3ff7a5',
				'label' => esc_html__('Data', 'drivingschool-plugin'),
				'name' => 'data',
				'type' => 'repeater',
				'sub_fields' => array(
					array(
						'key' => 'field_58ef6f30ff7a6',
						'label' => esc_html__('Text 1', 'drivingschool-plugin'),
						'name' => 'text1',
						'type' => 'text',
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => ''
					),
					array(
						'key' => 'field_58ef6f37ff7a7',
						'label' => esc_html__('Text 2', 'drivingschool-plugin'),
						'name' => 'text2',
						'type' => 'text',
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => ''
					)
				),
				'row_min' => '',
				'row_limit' => '',
				'layout' => 'table',
				'button_label' => esc_html__('Add', 'drivingschool-plugin')
			),
			array(
				'key' => 'field_58ef6cca44d3e',
				'label' => esc_html__('Gallery', 'drivingschool-plugin'),
				'name' => '',
				'type' => 'tab'
			),
			array(
				'key' => 'field_58ef6818b70fb',
				'label' => esc_html__('Gallery', 'drivingschool-plugin'),
				'name' => 'gallery',
				'type' => 'repeater',
				'sub_fields' => array(
					array(
						'key' => 'field_58ef690bb70fc',
						'label' => esc_html__('Picture', 'drivingschool-plugin'),
						'name' => 'picture',
						'type' => 'image',
						'required' => 1,
						'column_width' => '',
						'save_format' => 'object',
						'preview_size' => 'thumbnail',
						'library' => 'all'
					)
				),
				'row_min' => '',
				'row_limit' => '',
				'layout' => 'row',
				'button_label' => esc_html__('Add Picture', 'drivingschool-plugin')
			),
			array(
				'key' => 'field_58ef7056ac254',
				'label' => esc_html__('Cars', 'drivingschool-plugin'),
				'name' => '',
				'type' => 'tab'
			),
			array(
				'key' => 'field_58ef705eac255',
				'label' => esc_html__('Cars', 'drivingschool-plugin'),
				'name' => 'cars',
				'type' => 'repeater',
				'sub_fields' => array(
					array(
						'key' => 'field_58ef7166ac257',
						'label' => esc_html__('Car', 'drivingschool-plugin'),
						'name' => 'car',
						'type' => 'text',
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => ''
					),
					array(
						'key' => 'field_58ef7195ac258',
						'label' => esc_html__('Transmission', 'drivingschool-plugin'),
						'name' => 'transmission',
						'type' => 'select',
						'column_width' => '',
						'choices' => array(
							'Automat' => esc_html__('Automat', 'drivingschool-plugin'),
							'Mechanics' => esc_html__('Mechanics', 'drivingschool-plugin')
						),
						'default_value' => '',
						'allow_null' => 0,
						'multiple' => 0
					),
					array(
						'key' => 'field_58ef7213ac259',
						'label' => esc_html__('Rating', 'drivingschool-plugin'),
						'name' => 'rating',
						'type' => 'select',
						'column_width' => '',
						'choices' => array(
							5 => 5,
							4 => 4,
							3 => 3,
							2 => 2,
							1 => 1,
							'none' => esc_html__('None', 'drivingschool-plugin')
						),
						'default_value' => '',
						'allow_null' => 0,
						'multiple' => 0
					),
					array(
						'key' => 'field_58ef72f4ac25a',
						'label' => esc_html__('Picture', 'drivingschool-plugin'),
						'name' => 'picture',
						'type' => 'image',
						'column_width' => '',
						'save_format' => 'id',
						'preview_size' => 'thumbnail',
						'library' => 'all'
					)
				),
				'row_min' => '',
				'row_limit' => '',
				'layout' => 'row',
				'button_label' => esc_html__('Add Car', 'drivingschool-plugin')
			)
		),
		'location' => array(
			array(
				array(
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'teachers',
					'order_no' => 0,
					'group_no' => 0
				)
			)
		),
		'options' => array(
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array()
		),
		'menu_order' => 1
	));
}