<?php

if ( !defined('ABSPATH') ) {
	require_once( dirname( __FILE__ ) . '/../../../wp-load.php' );
}

add_action( 'init', 'drivingschool_teachers' );
function drivingschool_teachers() {
register_post_type( 'teachers', array(
  'labels' => array(
    'name' => esc_html__("Teachers","drivingschool-plugin"),
    'singular_name' => 'teachers',
   ),
  'description' => esc_html__("Teachers","drivingschool-plugin"),
  'public' => true,
  'menu_position' => 20,
  'menu_icon' => 'dashicons-clipboard', 
  'supports' => array( 'title','editor','thumbnail','comments' ),
  'rewrite'  => array( "slug" => false )
));
}

function drivingschool_add_page_option() {
    if(get_theme_mod('drivingschool_id_page_teachers') == '') {
            $teachers_data = array(
			    'post_title'    => esc_html__("Teachers 2","drivingschool-plugin"),
			    'post_status'   => 'publish',
 			    'post_author'   => 1,
			    'post_type'     => 'page'
			);
			$teachers_id = wp_insert_post( $teachers_data );
			if($teachers_id ) {set_theme_mod ('drivingschool_id_page_teachers', $teachers_id); }
	}
}
add_action( 'init', 'drivingschool_add_page_option' );

function prevent_default_theme_deletion($allcaps, $caps, $args) {
    $post_id = get_theme_mod('drivingschool_id_page_teachers');
    if ( isset( $args[0] ) && isset( $args[2] ) && $args[2] == $post_id && $args[0] == 'delete_post' ) {
        $allcaps[ $caps[0] ] = false;
    }
    return $allcaps;
}
add_filter ('user_has_cap', 'prevent_default_theme_deletion', 10, 3);

$update_t = false;
function drivingschool_add_teacher ( $post_id, $post, $update_t){
	 $typpost = get_post_type($post_id);     
	 if($typpost == "teachers") { 
	    $criterion1 = get_post_meta($post_id, 'field_1', true);
	    $criterion2 = get_post_meta($post_id, 'field_2', true);
	    $criterion3 = get_post_meta($post_id, 'field_3', true);
	    $criterion4 = get_post_meta($post_id, 'field_4', true);
		if($criterion1 != "") {  update_post_meta($post_id, 'criterion1', implode(",", $criterion1)); }
	    if($criterion2 != "") { update_post_meta($post_id, 'criterion2', implode(",", $criterion2)); }
	    if($criterion3 != "") {  update_post_meta($post_id, 'criterion3', implode(",", $criterion3)); }
	    if($criterion4 != "") { update_post_meta($post_id, 'criterion4', implode(",", $criterion4)); }
	 }
}
add_action( 'save_post', 'drivingschool_add_teacher', 10, 3  );

add_filter('template_include', 'drivingschool_teacher_template');
function drivingschool_teacher_template( $template ) {
	global $post;
	if(isset($post)) {
	if( $post->ID == get_theme_mod('drivingschool_id_page_teachers') ){
		return get_template_directory(). '/page-teachers.php';
	}
	}
	return $template;
}

add_action('wp_head','drivingschool_teacher_js');
function drivingschool_teacher_js() {
	global $post;
	if(isset($post)) {
	if(get_post_type($post->ID) == "teachers") {
	?>
	<script type="text/javascript">
	    jQuery(document).ready(function() {
			jQuery( ".nav__list li" ).each(function( indexx ) {
			    if(jQuery(this).find("a").attr('href') == "<?php echo get_permalink(get_theme_mod('drivingschool_id_page_teachers')); ?>") {
				    jQuery(this).addClass( "current-post-ancestor" );
			    }
			});
		});
    </script>
    <?php
	}
	}
}


function drivingschool_teachers_settings_admin() {
    global $submenu;
    $url = home_url( '/' ).'wp-admin/post.php?post='.get_theme_mod('drivingschool_id_page_teachers').'&action=edit';
    $submenu['edit.php?post_type=teachers'][] = array('Settings', 'manage_options', $url);
}
add_action('admin_menu', 'drivingschool_teachers_settings_admin');

add_action( 'load-post.php', 'drivingschool_hide_specific' );
function drivingschool_hide_specific()
{   
    if(isset($_GET['post'])) {    
        if( get_theme_mod('drivingschool_id_page_teachers') == $_GET['post'] && 'edit' == $_GET['action'] ) {
            add_action('admin_enqueue_scripts', 'drivingschool_teacher_css_admin_id');
	    }
	}
}


function drivingschool_teacher_css_admin_id() { 
?>
    <style>
	    #pageparentdiv, .misc-pub-section, .composer-switch, #screen-options-link-wrap, #contextual-help-link-wrap { 
		display: none !important;}
		#adminmenu #menu-posts-teachers .wp-submenu { position: relative; top: auto; left: auto;}
		#adminmenu #menu-posts-teachers > a  { background: #0073aa; color: #fff; position: relative;} 
		#adminmenu #menu-posts-teachers .wp-menu-image:before, #adminmenu #menu-posts-teachers li:last-child a { color: #fff;}
		#adminmenu #menu-posts-teachers >a:after {right: 0; border: 8px solid transparent;content: " ";height: 0;width: 0; position: absolute;pointer-events: none; border-right-color: #f1f1f1;top: 50%;margin-top: -8px;}
		#adminmenu #menu-pages > a { background: none; color: #eee;}
		#adminmenu #menu-pages .wp-menu-image:before {color: rgba(240,245,250,.6); }
		#adminmenu #menu-pages .wp-submenu  { position:absolute; top: -1000em; left: 160px; }
		#adminmenu #menu-pages:hover .wp-submenu  {  top: 0;  }
		#adminmenu #menu-pages:hover > a, #adminmenu #menu-pages:hover .wp-menu-image:before { color: #00b9eb; }
		#adminmenu #menu-pages > a { background: none; color: #eee;}
		#adminmenu #menu-pages >a:after {border-right-color: #23282d;}
		#adminmenu #menu-pages:hover >a:after { border-right-color: #32373c;}
		@media only screen and (max-width: 960px) {
		#adminmenu #menu-posts-teachers .wp-submenu { position: absolute;top: -1000em;  left: 160px;}
		#adminmenu #menu-posts-teachers >a:after {border-width: 4px; margin-top: -4px;}
		#adminmenu #menu-posts-teachers:hover >a:after { display:none;}
		#adminmenu #menu-posts-teachers:hover .wp-submenu { display:block !important; position: absolute; top: 0;  left: 36px;}
		#adminmenu #menu-posts-teachers .wp-submenu-head  { background: #0073aa; color: #fff; position: relative;}
		#adminmenu #menu-pages:hover .wp-submenu { display:block !important; position: absolute; top: 0;  left: 36px;}
		#adminmenu #menu-pages .wp-submenu-head { background:none !important;}
        }	
        @media screen and (max-width: 782px) {
		#adminmenu #menu-posts-teachers >a:after {border-width: 8px; margin-top: -8px;}
		#adminmenu #menu-posts-teachers .wp-submenu, 
		#adminmenu #menu-posts-teachers:hover .wp-submenu { position: relative;display: block;top: 0;left: -1px;}
		#adminmenu #menu-pages .wp-submenu, #adminmenu #menu-pages:hover .wp-submenu { display:none !important;}
		#adminmenu #menu-pages.selected .wp-submenu { display:block !important; position: relative; top: 0;left: -1px; display: block !important;}
		#adminmenu #menu-pages.selected> a, #adminmenu #menu-pages.selected .wp-menu-image:before { color: #00b9eb;background:#191e23; }
		#adminmenu #menu-pages:hover >a:after { display:none;}
        }
    </style>
   
<?php
}


function drivingschool_teacher_css_admin() { 
    if(get_theme_mod('drivingschool_id_page_teachers') != '') {
?>
    <style>#the-list #post-<?php echo get_theme_mod('drivingschool_id_page_teachers'); ?> { display: none !important;}</style>
<?php
	}
}
add_action('admin_print_styles', 'drivingschool_teacher_css_admin');

function drivingschool_form_filter_teachers($color = '') {
	$idpage = get_theme_mod('drivingschool_id_page_teachers');
?>
                <div class="teacher-filter<?php if($color == '') { echo " teacher-filter_theme_dark"; } ?>">
					<div class="container">
						<div class="row">
                            <form action="<?php echo esc_url(get_permalink($idpage)); ?>" method="get">
                            <?php if(have_rows('fieldvalue1', $idpage)): ?>
							<div class="teacher-filter__row col-md-3">
								<label class="lbl" for="gender"><?php echo get_post_meta($idpage, 'field1', true); ?></label>
								<select class="select<?php if($color == '') { echo " select_theme_dark"; } ?>" id="gender" name="field1">
                                    <option value=""><?php esc_html_e('Select', 'drivingschool-plugin'); ?></option>
                                    <?php while(have_rows('fieldvalue1', $idpage)) : the_row(); ?>
									<option<?php if(isset($_GET['field1']) and $_GET['field1'] == get_sub_field('value')) { echo ' selected="selected"'; } ?> value="<?php esc_html(the_sub_field('value')); ?>"><?php esc_html(the_sub_field('value')); ?></option>
                                    <?php endwhile;?>
								</select>
							</div>
                            <?php endif; ?>
                            <?php if(have_rows('fieldvalue2', $idpage)): ?>
							<div class="teacher-filter__row col-md-3">
								<label class="lbl" for="car"><?php echo get_post_meta($idpage, 'field2', true); ?></label>
								<select class="select<?php if($color == '') { echo " select_theme_dark"; } ?>" id="car" name="field2">
                                    <option value=""><?php esc_html_e('Select', 'drivingschool-plugin'); ?></option>
									<?php while(have_rows('fieldvalue2', $idpage)) : the_row(); ?>
									<option<?php if(isset($_GET['field2']) and $_GET['field2'] == get_sub_field('value')) { echo ' selected="selected"'; } ?> value="<?php esc_html(the_sub_field('value')); ?>"><?php esc_html(the_sub_field('value')); ?></option>
                                    <?php endwhile;?>
								</select>
							</div>
                            <?php endif; ?>
                            <?php if(have_rows('fieldvalue3', $idpage)): ?>
							<div class="teacher-filter__row col-md-3">
								<label class="lbl" for="trs"><?php echo get_post_meta($idpage, 'field3', true); ?></label>
								<select class="select<?php if($color == '') { echo " select_theme_dark"; } ?>" id="trs" name="field3">
                                    <option value=""><?php esc_html_e('Select', 'drivingschool-plugin'); ?></option>
									<?php while(have_rows('fieldvalue3', $idpage)) : the_row(); ?>
									<option<?php if(isset($_GET['field3']) and $_GET['field3'] == get_sub_field('value')) { echo ' selected="selected"'; } ?> value="<?php esc_html(the_sub_field('value')); ?>"><?php esc_html(the_sub_field('value')); ?></option>
                                    <?php endwhile; ?>
								</select>
							</div>
                            <?php endif; ?>
                            <?php if(have_rows('fieldvalue4', $idpage)): ?>
							<div class="teacher-filter__row col-md-2">
								<label class="lbl" for="category"><?php echo get_post_meta($idpage, 'field4', true); ?></label>
								<select class="select<?php if($color == '') { echo " select_theme_dark"; } ?>" id="category" name="field4">
                                    <option value=""><?php esc_html_e('Select', 'drivingschool-plugin'); ?></option>
									<?php while(have_rows('fieldvalue4', $idpage)) : the_row(); ?>
									<option<?php if(isset($_GET['field4']) and $_GET['field4'] == get_sub_field('value')) { echo ' selected="selected"'; } ?> value="<?php esc_html(the_sub_field('value')); ?>"><?php esc_html(the_sub_field('value')); ?></option>
                                    <?php endwhile; ?>
								</select>
							</div>
                            <?php endif; ?>
							<div class="col-md-1">
								<button class="btn btn_fullwidth teacher-filter__btn" type="submit">
									<span class="btn__text">
										<svg class="teacher-filter__icon"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_search"></use></svg>
									</span>
								</button>
							</div>
                            </form>
						</div>
					</div>
				</div>
<?php 
}

function drivingschool_serch_field(){
	$filter_fields = array('relation' => 'AND');
	if(isset($_GET['field1']) and $_GET['field1'] != '') {
	    $filter_fields[] = array('key' => 'criterion1','value' => htmlspecialchars($_GET['field1']),'compare' => 'REGEXP');
	}
	if(isset($_GET['field2']) and $_GET['field2'] != '') {
	    $filter_fields[] = array('key' => 'criterion2','value' => htmlspecialchars($_GET['field2']),'compare' => 'REGEXP');
	}
	if(isset($_GET['field3']) and $_GET['field3'] != '') {
	    $filter_fields[] = array('key' => 'criterion3','value' => htmlspecialchars($_GET['field3']),'compare' => 'REGEXP');
	}
	if(isset($_GET['field4']) and $_GET['field4'] != '') {
	    $filter_fields[] = array('key' => 'criterion4','value' => htmlspecialchars($_GET['field4']),'compare' => 'REGEXP');
	}
	return $filter_fields;
}


if(function_exists("register_field_group") and get_theme_mod('drivingschool_id_page_teachers') != '')
{
	register_field_group(array (
		'id' => 'acf_template-teachers',
		'title' => esc_html__('Template «Teachers»','drivingschool-plugin'),
		'fields' => array (
			array (
				'key' => 'field_58ef48c4c9564',
				'label' => esc_html__('Number of teachers','drivingschool-plugin'),
				'name' => 'number_teachers',
				'type' => 'number',
				'required' => 1,
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'min' => '',
				'max' => '',
				'step' => '',
			),
			array (
				'key' => 'field_58ef50910db49',
				'label' => esc_html__('Filter','drivingschool-plugin'),
				'name' => 'filter',
				'type' => 'select',
				'choices' => array (
					'no' => esc_html__('No','drivingschool-plugin'),
					'yes' => esc_html__('Yes','drivingschool-plugin'),
				),
				'default_value' => '',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_58ef52f10db4a',
				'label' => esc_html__('Field 1','drivingschool-plugin'),
				'name' => 'field1',
				'type' => 'text',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_58ef53320db4b',
				'label' => esc_html__('Field value 1','drivingschool-plugin'),
				'name' => 'fieldvalue1',
				'type' => 'repeater',
				'sub_fields' => array (
					array (
						'key' => 'field_58ef53a80db4c',
						'label' => esc_html__('Value','drivingschool-plugin'),
						'name' => 'value',
						'type' => 'text',
						'required' => 1,
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => '',
					),
				),
				'row_min' => '',
				'row_limit' => '',
				'layout' => 'row',
				'button_label' => esc_html__('Add value','drivingschool-plugin'),
			),
			array (
				'key' => 'field_58ef5a142c6c8',
				'label' => esc_html__('Field 2','drivingschool-plugin'),
				'name' => 'field2',
				'type' => 'text',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_58ef5a352c6cb',
				'label' => esc_html__('Field value 2','drivingschool-plugin'),
				'name' => 'fieldvalue2',
				'type' => 'repeater',
				'sub_fields' => array (
					array (
						'key' => 'field_58ef5a582c6ce',
						'label' => esc_html__('Value','drivingschool-plugin'),
						'name' => 'value',
						'type' => 'text',
						'required' => 1,
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => '',
					),
				),
				'row_min' => '',
				'row_limit' => '',
				'layout' => 'row',
				'button_label' => esc_html__('Add value','drivingschool-plugin'),
			),
			array (
				'key' => 'field_58ef5a202c6c9',
				'label' => esc_html__('Field 3','drivingschool-plugin'),
				'name' => 'field3',
				'type' => 'text',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_58ef5a3e2c6cc',
				'label' => esc_html__('Field value 3','drivingschool-plugin'),
				'name' => 'fieldvalue3',
				'type' => 'repeater',
				'sub_fields' => array (
					array (
						'key' => 'field_58ef5a5e2c6cf',
						'label' => esc_html__('Value','drivingschool-plugin'),
						'name' => 'value',
						'type' => 'text',
						'required' => 1,
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => '',
					),
				),
				'row_min' => '',
				'row_limit' => '',
				'layout' => 'row',
				'button_label' => esc_html__('Add value','drivingschool-plugin'),
			),
			array (
				'key' => 'field_58ef5a2a2c6ca',
				'label' => esc_html__('Field 4','drivingschool-plugin'),
				'name' => 'field4',
				'type' => 'text',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_58ef5a482c6cd',
				'label' => esc_html__('Field value 4','drivingschool-plugin'),
				'name' => 'fieldvalue4',
				'type' => 'repeater',
				'sub_fields' => array (
					array (
						'key' => 'field_58ef5a642c6d0',
						'label' => esc_html__('Value','drivingschool-plugin'),
						'name' => 'value',
						'type' => 'text',
						'required' => 1,
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => '',
					),
				),
				'row_min' => '',
				'row_limit' => '',
				'layout' => 'row',
				'button_label' => esc_html__('Add value','drivingschool-plugin'),
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'page',
					'operator' => '==',
					'value' => get_theme_mod('drivingschool_id_page_teachers'),
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
				0 => 'the_content',
				1 => 'excerpt',
				2 => 'custom_fields',
				3 => 'discussion',
				4 => 'comments',
				5 => 'revisions',
				6 => 'slug',
				7 => 'author',
				8 => 'format',
				9 => 'featured_image',
				10 => 'categories',
				11 => 'tags',
				12 => 'send-trackbacks',
			),
		),
		'menu_order' => 1,
	));
}


if(function_exists("register_field_group") and get_theme_mod('drivingschool_id_page_teachers') != "")
{
	$idpage = get_theme_mod('drivingschool_id_page_teachers');
	
	$field_1 = array();
    if(have_rows('fieldvalue1', $idpage)): while(have_rows('fieldvalue1', $idpage)) : the_row();
		    $field_1[get_sub_field('value')] = get_sub_field('value');                            
    endwhile; endif;
	
	$field_2 = array();
    if(have_rows('fieldvalue2', $idpage)): while(have_rows('fieldvalue2', $idpage)) : the_row();
		    $field_2[get_sub_field('value')] = get_sub_field('value');                            
    endwhile; endif;
	
	$field_3 = array();
    if(have_rows('fieldvalue3', $idpage)): while(have_rows('fieldvalue3', $idpage)) : the_row();
		    $field_3[get_sub_field('value')] = get_sub_field('value');                            
    endwhile; endif;
	
	$field_4 = array();
    if(have_rows('fieldvalue4', $idpage)): while(have_rows('fieldvalue4', $idpage)) : the_row();
		    $field_4[get_sub_field('value')] = get_sub_field('value');                            
    endwhile; endif;
	
	
	register_field_group(array (
		'id' => 'acf_filter',
		'title' => 'Filter',
		'fields' => array (
			array (
				'key' => 'field_58ef89e16b740',
				'label' => get_post_meta($idpage, 'field1', true),
				'name' => 'field_1',
				'type' => 'select',
				'choices' => $field_1,
				'default_value' => '',
				'allow_null' => 1,
				'multiple' => 1,
			),
			array (
				'key' => 'field_58ef8a256b741',
				'label' => get_post_meta($idpage, 'field2', true),
				'name' => 'field_2',
				'type' => 'select',
				'choices' => $field_2,
				'default_value' => '',
				'allow_null' => 1,
				'multiple' => 1,
			),
			array (
				'key' => 'field_58ef8a396b742',
				'label' => get_post_meta($idpage, 'field3', true),
				'name' => 'field_3',
				'type' => 'select',
				'choices' => $field_3,
				'default_value' => '',
				'allow_null' => 1,
				'multiple' => 1,
			),
			array (
				'key' => 'field_58ef8a476b743',
				'label' => get_post_meta($idpage, 'field4', true),
				'name' => 'field_4',
				'type' => 'select',
				'choices' => $field_4,
				'default_value' => '',
				'allow_null' => 1,
				'multiple' => 1,
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'teachers',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'side',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
}


?>