<?php 

require_once ABSPATH.WPINC.'/class-wp-customize-control.php';

class Customize_Textarea_Control extends WP_Customize_Control {
    public $type = 'textarea';
    public function render_content() {
        ?>
            <label>
                <span class="customize-control-title"><?php echo esc_html($this->label); ?></span>
                <textarea rows="5" style="width:100%;" <?php $this->link(); ?>><?php echo esc_textarea($this->value()); ?></textarea>
            </label>
        <?php
    }
}

class Customize_Number_Control extends WP_Customize_Control {
    public $type = 'number';
    public function render_content() {
        ?>
            <label>
                <span class="customize-control-title"><?php echo esc_html($this->label); ?></span>
                <input type="number" style="width:100%;"  <?php $this->link(); ?> value="<?php echo esc_textarea($this->value()); ?>"/ >
            </label>
        <?php
    }
}


function drivingschool_sanitize($atr) {
	return $atr;
}

function drivingschool_settings($customizer){
    $customizer->add_section(
        'drivingschool_example_section0',
        array(
            'title' => esc_html__( 'Settings', 'drivingschool' ),
            'description' => "",
            'priority' => 1,
        )
    );
	$customizer->add_setting('drivingschool_logo_h');
	$customizer->add_control(
         new WP_Customize_Upload_Control(
             	$customizer,
                'drivingschool_logo_h',
                array(
           	        'label' => esc_html__( 'Logo - Header', 'drivingschool' ),
           	        'section' => 'drivingschool_example_section0',
           	        'settings' => 'drivingschool_logo_h',
       	  	   )
    	  )
	  );
	  $customizer->add_setting('drivingschool_logo_f');
	  $customizer->add_control(
         new WP_Customize_Upload_Control(
             	$customizer,
                'drivingschool_logo_f',
                array(
           	        'label' => esc_html__( 'Logo - Footer', 'drivingschool' ),
           	        'section' => 'drivingschool_example_section0',
           	        'settings' => 'drivingschool_logo_f',
       	  	   )
    	  )
	  );
	  $customizer->add_setting('drivingschool_address');
	  $customizer->add_control(
        'drivingschool_address',
            array(
            'label' => esc_html__( 'Address', 'drivingschool' ),
            'section' => 'drivingschool_example_section0',
            'type' => 'text',
        )
    );
	$customizer->add_setting('drivingschool_phone');
	$customizer->add_control(
        'drivingschool_phone',
            array(
            'label' => esc_html__( 'Phone', 'drivingschool' ),
            'section' => 'drivingschool_example_section0',
            'type' => 'text',
        )
    );
	$customizer->add_setting('drivingschool_call_me',array('default' => 'yes'));
	$customizer->add_control(
  	  'drivingschool_call_me',
  	   array(
   	         'type' => 'select',
             'label' => esc_html__( 'Form - Call me', 'drivingschool' ),
             'section' => 'drivingschool_example_section0',
             'choices' => array(
                 'yes' => esc_html__( 'Enable', 'drivingschool' ),
                 'no' => esc_html__( 'Disable', 'drivingschool' ),
             ),
      	)
    );
	$customizer->add_setting('drivingschool_map_key');
	$customizer->add_control(
        'drivingschool_map_key',
            array(
            'label' => esc_html__( 'Api key (google.com)', 'drivingschool' ),
            'section' => 'drivingschool_example_section0',
            'type' => 'text',
        )
    );
	$customizer->add_setting('drivingschool_pagination',array('default' => 'no'));
	$customizer->add_control(
  	  'drivingschool_pagination',
  	   array(
   	         'type' => 'select',
             'label' => esc_html__( 'Ajax pagination', 'drivingschool' ),
             'section' => 'drivingschool_example_section0',
             'choices' => array(
			     'no' => esc_html__( 'No', 'drivingschool' ),
                 'yes' => esc_html__( 'Yes', 'drivingschool' ),
             ),
      	)
    );
}
add_action('customize_register','drivingschool_settings');


add_action('customize_register','drivingschool_heander');
function drivingschool_heander($customizer){
    $customizer->add_section(
        'drivingschool_example_section1',
        array(
            'title' => esc_html__( 'Header', 'drivingschool' ),
            'description' => "",
            'priority' => 2,
        )
    );
	$customizer->add_setting('drivingschool_upper_block_h',array('default' => 'yes'));
	$customizer->add_control(
  	  'drivingschool_upper_block_h',
  	   array(
   	         'type' => 'select',
             'label' => esc_html__( 'Upper block', 'drivingschool' ),
             'section' => 'drivingschool_example_section1',
             'choices' => array(
                 'yes' => esc_html__( 'Enable', 'drivingschool' ),
                 'no' => esc_html__( 'Disable', 'drivingschool' ),
             ),
      	)
    );
	$customizer->add_setting('drivingschool_text_h');
	$customizer->add_control(
        'drivingschool_text_h',
            array(
            'label' => esc_html__( 'Text', 'drivingschool' ),
            'section' => 'drivingschool_example_section1',
            'type' => 'text',
        )
    );
	$customizer->add_setting('drivingschool_soc_url1');
	$customizer->add_control(
        'drivingschool_soc_url1',
            array(
            'label' => esc_html__( 'Link to vk.com', 'drivingschool' ),
            'section' => 'drivingschool_example_section1',
            'type' => 'text',
        )
    );
	$customizer->add_setting('drivingschool_soc_url2');
	$customizer->add_control(
        'drivingschool_soc_url2',
            array(
            'label' => esc_html__( 'Link to facebook.com', 'drivingschool' ),
            'section' => 'drivingschool_example_section1',
            'type' => 'text',
        )
    );
	$customizer->add_setting('drivingschool_soc_url3');
	$customizer->add_control(
        'drivingschool_soc_url3',
            array(
            'label' => esc_html__( 'Link to twitter.com', 'drivingschool' ),
            'section' => 'drivingschool_example_section1',
            'type' => 'text',
        )
    );
	$customizer->add_setting('drivingschool_soc_url4');
	$customizer->add_control(
        'drivingschool_soc_url4',
            array(
            'label' => esc_html__( 'Link to instagram.com', 'drivingschool' ),
            'section' => 'drivingschool_example_section1',
            'type' => 'text',
        )
    );
}


add_action('customize_register','drivingschool_footer');
function drivingschool_footer($customizer){
    $customizer->add_section(
        'drivingschool_example_section2',
        array(
            'title' => esc_html__( 'Footer', 'drivingschool' ),
            'description' => "",
            'priority' => 3,
        )
    );
	$customizer->add_setting('drivingschool_header_f1');
	$customizer->add_control(
        'drivingschool_header_f1',
            array(
            'label' => esc_html__( 'Header', 'drivingschool' ),
            'section' => 'drivingschool_example_section2',
            'type' => 'text',
        )
    );
	$customizer->add_setting('drivingschool_text_f');
	$customizer->add_control(
        'drivingschool_text_f',
            array(
            'label' => esc_html__( 'Text', 'drivingschool' ),
            'section' => 'drivingschool_example_section2',
            'type' => 'text',
        )
    );
	$customizer->add_setting('drivingschool_copyright');
	$customizer->add_control(
        'drivingschool_copyright',
            array(
            'label' => esc_html__( 'Copyright', 'drivingschool' ),
            'section' => 'drivingschool_example_section2',
            'type' => 'text',
        )
    );
	$customizer->add_setting('drivingschool_lower_block',array('default' => 'no'));
	$customizer->add_control(
  	  'drivingschool_lower_block',
  	   array(
   	         'type' => 'select',
             'label' => esc_html__( 'Lower block', 'drivingschool' ),
             'section' => 'drivingschool_example_section2',
             'choices' => array(
                 'yes' => esc_html__( 'Enable', 'drivingschool' ),
                 'no' => esc_html__( 'Disable', 'drivingschool' ),
             ),
      	)
    );
	$customizer->add_setting('drivingschool_header_f2');
	$customizer->add_control(
        'drivingschool_header_f2',
            array(
            'label' => esc_html__( 'Header - Lower block', 'drivingschool' ),
            'section' => 'drivingschool_example_section2',
            'type' => 'text',
        )
    );
	$customizer->add_setting('drivingschool_picture1');
	$customizer->add_control(
         new WP_Customize_Upload_Control(
             	$customizer,
                'drivingschool_picture1',
                array(
           	        'label' => esc_html__( 'Picture 1', 'drivingschool' ),
           	        'section' => 'drivingschool_example_section2',
           	        'settings' => 'drivingschool_picture1',
       	  	   )
    	  )
	  );
	  $customizer->add_setting('drivingschool_picture2');
	  $customizer->add_control(
         new WP_Customize_Upload_Control(
             	$customizer,
                'drivingschool_picture2',
                array(
           	        'label' => esc_html__( 'Picture 2', 'drivingschool' ),
           	        'section' => 'drivingschool_example_section2',
           	        'settings' => 'drivingschool_picture2',
       	  	   )
    	  )
	  );
	  $customizer->add_setting('drivingschool_picture3');
	  $customizer->add_control(
         new WP_Customize_Upload_Control(
             	$customizer,
                'drivingschool_picture3',
                array(
           	        'label' => esc_html__( 'Picture 3', 'drivingschool' ),
           	        'section' => 'drivingschool_example_section2',
           	        'settings' => 'drivingschool_picture3',
       	  	   )
    	  )
	  );
	  $customizer->add_setting('drivingschool_picture4');
	  $customizer->add_control(
         new WP_Customize_Upload_Control(
             	$customizer,
                'drivingschool_picture4',
                array(
           	        'label' => esc_html__( 'Picture 4', 'drivingschool' ),
           	        'section' => 'drivingschool_example_section2',
           	        'settings' => 'drivingschool_picture4',
       	  	   )
    	  )
	  );
	  $customizer->add_setting('drivingschool_picture5');
	  $customizer->add_control(
         new WP_Customize_Upload_Control(
             	$customizer,
                'drivingschool_picture5',
                array(
           	        'label' => esc_html__( 'Picture 5', 'drivingschool' ),
           	        'section' => 'drivingschool_example_section2',
           	        'settings' => 'drivingschool_picture5',
       	  	   )
    	  )
	  );
	  $customizer->add_setting('drivingschool_picture6');
	  $customizer->add_control(
         new WP_Customize_Upload_Control(
             	$customizer,
                'drivingschool_picture6',
                array(
           	        'label' => esc_html__( 'Picture 6', 'drivingschool' ),
           	        'section' => 'drivingschool_example_section2',
           	        'settings' => 'drivingschool_picture6',
       	  	   )
    	  )
	  );
}


add_action('customize_register','drivingschool_subscription');
function drivingschool_subscription($customizer){
    $customizer->add_section(
        'drivingschool_example_section3',
        array(
            'title' => esc_html__( 'Subscription', 'drivingschool' ),
            'description' => esc_html__( 'mailchimp.com', 'drivingschool'),
            'priority' => 4,
        )
    );
	$customizer->add_setting('drivingschool_url_subs');
	$customizer->add_control(
        'drivingschool_url_subs',
            array(
            'label' => esc_html__( 'URL action form (required)', 'drivingschool' ),
            'section' => 'drivingschool_example_section3',
            'type' => 'text',
        )
    );
	$customizer->add_setting('drivingschool_cat_subs',array('default' => 'no'));
	$customizer->add_control(
  	  'drivingschool_cat_subs',
  	   array(
   	         'type' => 'select',
             'label' => esc_html__( 'Categories', 'drivingschool' ),
             'section' => 'drivingschool_example_section3',
             'choices' => array(
			     'no' => esc_html__( 'No', 'drivingschool' ),
                 'yes' => esc_html__( 'Yes', 'drivingschool' ),
             ),
      	)
    );
	$customizer->add_setting('drivingschool_home_subs',array('default' => 'no'));
	$customizer->add_control(
  	  'drivingschool_home_subs',
  	   array(
   	         'type' => 'select',
             'label' => esc_html__( 'Main', 'drivingschool' ),
             'section' => 'drivingschool_example_section3',
             'choices' => array(
			     'no' => esc_html__( 'No', 'drivingschool' ),
                 'yes' => esc_html__( 'Yes', 'drivingschool' ),
             ),
      	)
    );
	$customizer->add_setting('drivingschool_post',array('sanitize_callback' => 'drivingschool_sanitize'));
	$customizer->add_control(
        new Customize_Number_Control(
            $customizer,
             'drivingschool_post',
                  array(
                 'label' => esc_html__( 'Post number', 'drivingschool' ),
                 'section' => 'drivingschool_example_section3',
                 'type' => 'drivingschool_post'
             )
         )
    );
	$customizer->add_setting('drivingschool_post_subs',array('default' => 'no'));
	$customizer->add_control(
  	  'drivingschool_post_subs',
  	   array(
   	         'type' => 'select',
             'label' => esc_html__( 'Posts', 'drivingschool' ),
             'section' => 'drivingschool_example_section3',
             'choices' => array(
			     'no' => esc_html__( 'No', 'drivingschool' ),
                 'yes' => esc_html__( 'Yes', 'drivingschool' ),
             ),
      	)
    );
	$customizer->add_setting('drivingschool_title_subs');
	$customizer->add_control(
        'drivingschool_title_subs',
            array(
            'label' => esc_html__( 'Title', 'drivingschool' ),
            'section' => 'drivingschool_example_section3',
            'type' => 'text',
        )
    );
	$customizer->add_setting('drivingschool_text_subs');
	$customizer->add_control(
        'drivingschool_text_subs',
            array(
            'label' => esc_html__( 'Text', 'drivingschool' ),
            'section' => 'drivingschool_example_section3',
            'type' => 'text',
        )
    );
	 $customizer->add_setting('drivingschool_background_subs');
	  $customizer->add_control(
         new WP_Customize_Upload_Control(
             	$customizer,
                'drivingschool_background_subs',
                array(
           	        'label' => esc_html__( 'Background image', 'drivingschool' ),
           	        'section' => 'drivingschool_example_section3',
           	        'settings' => 'drivingschool_background_subs',
       	  	   )
    	  )
	  );

}

/**
 * Contact Forms
 */
function drivingschool_customize_contact_forms( $customizer ) {
    
    $section = 'drivingschool_contact_forms';
    
    $customizer->add_section(
        'drivingschool_contact_forms',
        array(
            'title'       => esc_html__( 'Contact Forms', 'drivingschool' ),
            'priority'    => 5,
        )
    );

    // Email
	$customizer->add_setting( 'drivingschool_form_email', array(
        'default' => get_bloginfo( 'admin_email' ),
    ) );
	$customizer->add_control( 'drivingschool_form_email', array(
        'section' => $section,
        'label'   => esc_html__( 'Email for receiving messages', 'drivingschool' ),
        'type'    => 'text',
    ) );
    
    // Captcha
    $customizer->add_setting( 'drivingschool_form_captcha', [
        'default' => '',
    ] );

    $customizer->add_control( 'drivingschool_form_captcha', [
        'section' => $section,
        'label'   => esc_html__( 'Enable Google reCAPTCHA v3', 'drivingschool' ),
        'type'    => 'checkbox', 
    ] );
    
    // reCAPTCHA Key
	$customizer->add_setting( 'drivingschool_captcha_key', array(
        'default' => '',
    ) );
	$customizer->add_control( 'drivingschool_captcha_key', array(
        'section' => $section,
        'label'   => esc_html__( 'reCAPTCHA Key', 'drivingschool' ),
        'type'    => 'text',
    ) );
    
    // reCAPTCHA Key
	$customizer->add_setting( 'drivingschool_captcha_secret_key', array(
        'default' => '',
    ) );
	$customizer->add_control( 'drivingschool_captcha_secret_key', array(
        'section'     => $section,
        'label'       => esc_html__( 'reCAPTCHA Secret Key', 'drivingschool' ),
        'description' => '<a href="https://www.google.com/recaptcha/admin/create" target="_blank">' . esc_html__( 'Register a reCAPTCHA v3 Key and Secret', 'drivingschool' ) . '</a>',
        'type'        => 'text',
    ) );
    
}
add_action( 'customize_register', 'drivingschool_customize_contact_forms' );
