<?php
/**
 * Include the TGM_Plugin_Activation class
 */

require get_theme_file_path( '/include/tgmpa/class-tgm-plugin-activation.php' );

/**
 * Register the required plugins for this theme.
 */
function drivingschool_register_required_plugins(){
	/**
	 * Array of plugin arrays. Required keys are name and slug.
	 * If the source is NOT from the .org repo, then source is also required.
	 */
	$plugins = array(
	
		array(
			'name'      => esc_html__('Driving School Plugin', 'drivingschool'), 
			'slug'      => 'drivingschool-plugin',
			'source'    => get_template_directory().'/plugins/drivingschool-plugin.zip',
			'version'   => '1.4.8',
			'required'  => true
		),
		array(
			'name'      => esc_html__('Visual Composer', 'drivingschool'), 
			'slug'      => 'js_composer',
			'source'    => get_template_directory().'/plugins/js_composer.zip',
			'version'   => '6.6.0',
			'required'	=> false
		),

	);

	$config = array(
		'id'           => 'drivingschool',
		'is_automatic' => true,  // Automatically activate plugins after installation or not.
	);

	tgmpa($plugins, $config);
}
add_action('tgmpa_register', 'drivingschool_register_required_plugins');
