<?php

/*

Template Name: Course

*/

drivingschool_on_ff();
?>
<?php get_header();  ?>
	<?php while (have_posts()) : the_post(); ?>
			<div class="head-page">
		<div class="container">
			<div class="row">
				<div class="col-md-8">
					<h1 class="title-page"><?php the_title(); ?></h1>
					<div class="breadcrumbs">
						<ul class="breadcrumbs__list">
							<li class="breadcrumbs__item">
								<a href="<?php echo esc_url( home_url('/') ); ?>" class="breadcrumbs__link"><?php esc_html_e('Index', 'drivingschool'); ?></a>
							</li>
							<?php if (drivingschool_is_subpage()) { ?>
							<li class="breadcrumbs__item">
								<a href="<?php echo get_permalink($post->post_parent); ?>" class="breadcrumbs__link"><?php echo get_the_title($post->post_parent); ?></a>
							</li>
							<?php } ?>
							<li class="breadcrumbs__item"><?php the_title(); ?></li>
						</ul>
					</div>
				</div>
				<div class="col-md-4">
					<?php get_search_form(); ?>
				</div>
			</div>
		</div>
	</div>
	<div class="content">
		<?php if( have_rows('courses') ): ?>
		<ul class="card-list">
			<?php while( have_rows('courses') ) : the_row(); ?>
			<li class="card-list__item">
				<div class="card card_theme_cover">
					<div class="container">
						<div class="row">
							<?php
							   $thumb_url = wp_get_attachment_image_src(get_sub_field('picture'),'drivingschool_about-thumb', true);
								if(get_sub_field('picture') == '') { 
									$thumb_url[0] = ''; 
								} else {
							?>
							<div class="col-md-3">
								<figure class="card__fig">
									<img src="<?php echo esc_url($thumb_url[0]); ?>" alt="<?php esc_html(the_sub_field('title')); ?>" />
								</figure>
							</div>
							<?php } ?>
							<div class="col-md-9">
								<?php if(get_sub_field('icon_form') != '') { ?>
								<div class="popup_protect__def__img col">
									<img src="<?php esc_url(the_sub_field('icon_form')); ?>" alt="<?php esc_html_e('Icon','drivingschool');?>">
								</div>
								<?php } ?>
								<div<?php if(get_sub_field('icon_form') != '') { ?> class="card__head"<?php } ?>>
									<h3 class="card__name"><?php esc_html(the_sub_field('title')); ?></h3>
									<div class="card__period"><?php esc_html(the_sub_field('duration')); ?></div>
								</div>
								<?php if( have_rows('texts') ): ?>
								<div class="card__body">
									<ul class="card__feature">
										<?php  while( have_rows('texts') ) : the_row(); ?>
										<li class="card__feature-item"><?php esc_url(the_sub_field('text')); ?></li>
										<?php endwhile; ?> 
									</ul>
								</div>
								<?php endif; ?>  
								<div class="card__footer">
									<div class="row">
										<div class="card__price col-md-7 col-lg-6">
											<div class="card__price-item">
											<?php if(get_sub_field('automatic') != '') { ?>
												<span class="card__price-value"><?php esc_html(the_sub_field('automatic')); ?> </span><?php esc_html_e('Automatic', 'drivingschool'); ?></div>
											<?php } ?>
                                            </div>
											<div class="card__price-item">
											<?php if(get_sub_field('mechanics') != '') { ?>
												<span class="card__price-value"><?php esc_html(the_sub_field('mechanics')); ?> </span><?php esc_html_e('Mechanics', 'drivingschool'); ?></div>
											<?php } ?>
                                            </div>
										</div>
										<div class="card__btn-wrap col-md-5 col-lg-6">
										<?php if(get_sub_field('form') != 'no') { ?>
											<a class="btn card__btn popup-protect-btn" href="#">
												<span class="btn__text"><?php esc_html_e('buy now', 'drivingschool'); ?></span>
												<div class="data-form" data-title="<?php esc_html(the_sub_field('title')); ?>" data-duration="<?php esc_html(the_sub_field('duration')); ?>" data-icon="<?php esc_url(the_sub_field('icon_form')); ?>" data-img="<?php echo esc_url($thumb_url[0]); ?>"> </div>
											</a>
											<?php if( have_rows('texts') ): ?>
											<ul class="data-form form-li"> 
												<?php  while( have_rows('texts') ) : the_row(); ?>
												<li class="popup_protect__list-item"><?php esc_url(the_sub_field('text')); ?></li>
												<?php endwhile; ?> 
											</ul>
											<?php endif; ?> 
										 <?php } ?>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</li>
			<?php endwhile; ?>
		</ul>
		<?php
			if(function_exists("drivingschool_form_course")) {
				drivingschool_form_course();
			}
		?>
		<?php endif; ?>
		<?php if( have_rows('blocks') ): ?>
		<div class="course course_addition">
			<div class="container">
				<ul class="course__list row">
					<?php  while( have_rows('blocks') ) : the_row(); ?>
					<li class="course__list-item col-md-6">
						<div class="course__item <?php esc_html(the_sub_field('background_icon')); ?>">
							<div class="course__item-head course__item-head_cover">
								<h3 class="course__item-name"><?php esc_url(the_sub_field('text')); ?></h3>
							</div>
						</div>
					</li>
					<?php endwhile; ?> 
				</ul>
			</div>
		</div>
		<?php endif; ?>
		<?php endwhile; ?>
	</div>
<?php get_footer(); ?>