<?php

/*

Template Name: FAQ

*/

drivingschool_on_ff();
?>
<?php get_header();  ?>
	<?php while (have_posts()) : the_post(); ?>
	<div class="head-page">
		<div class="container">
			<div class="row">
				<div class="col-md-8">
					<h1 class="title-page"><?php the_title(); ?></h1>
					<div class="breadcrumbs">
						<ul class="breadcrumbs__list">
							<li class="breadcrumbs__item">
								<a href="<?php echo esc_url( home_url('/') ); ?>" class="breadcrumbs__link"><?php esc_html_e('Index', 'drivingschool'); ?></a>
							</li>
							<?php if (drivingschool_is_subpage()) { ?>
							<li class="breadcrumbs__item">
								<a href="<?php echo get_permalink($post->post_parent); ?>" class="breadcrumbs__link"><?php echo get_the_title($post->post_parent); ?></a>
							</li>
							<?php } ?>
							<li class="breadcrumbs__item"><?php the_title(); ?></li>
						</ul>
					</div>
				</div>
				<div class="col-md-4">
					<?php get_search_form(); ?>
				</div>
			</div>
		</div>
	</div>
	<div class="content">
		<div class="text">
			<div class="container">
				<div class="row">
					<div class="col-md-12">
						<?php the_content(); ?>
					</div>
				</div>
			</div>
		</div>
		<?php if( have_rows('blocks') ): while( have_rows('blocks') ) : the_row(); ?>
		<div class="faq faq_theme_page"<?php if(get_sub_field('image') != '') { ?> style="background: #f9fafb url(<?php esc_url(the_sub_field('image')); ?>) 100% 100% no-repeat !important;"<?php } ?>>
			<div class="container">
				<?php if(get_sub_field('title') != '') { ?>
				<h2 class="title"><?php echo wp_kses(get_sub_field('title'),array('strong'=> array())); ?></h2>
				<?php } ?>
				<?php if( have_rows('questions') ): ?>
				<ul class="faq__list">
					<?php while( have_rows('questions') ) : the_row(); ?>
					<li class="faq__item <?php esc_html(the_sub_field('active')); ?> row">
						<div class="col-md-7">
							<div class="faq__question"><?php esc_html(the_sub_field('question')); ?></div>
							<div class="faq__answer"><?php esc_html(the_sub_field('answer')); ?></div>
						</div>
					</li>
					<?php endwhile; ?>
				</ul>
				<?php endif; ?>
			</div>
		</div>
		<?php endwhile; endif; ?>
		<?php
			if(function_exists("drivingschool_form_question") and get_post_meta($post->ID, 'form', true) != "no") {
				drivingschool_form_question();
			}
		?>
		<?php endwhile; ?>
	</div>
<?php get_footer(); ?>