<?php

/*

Template Name: Price

*/

drivingschool_on_ff();
?>
<?php get_header();  ?>
        <?php while (have_posts()) : the_post(); ?>
		<div class="head-page">
			<div class="container">
				<div class="row">
					<div class="col-md-8">
						<h1 class="title-page"><?php the_title(); ?></h1>
						<div class="breadcrumbs">
							<ul class="breadcrumbs__list">
								<li class="breadcrumbs__item">
									<a href="<?php echo esc_url( home_url('/') ); ?>" class="breadcrumbs__link"><?php esc_html_e('Index', 'drivingschool'); ?></a>
								</li>
                                <?php if (drivingschool_is_subpage()) { ?>
                                <li class="breadcrumbs__item">
									<a href="<?php echo get_permalink($post->post_parent); ?>" class="breadcrumbs__link"><?php echo get_the_title($post->post_parent); ?></a>
								</li>
                                <?php } ?>
								<li class="breadcrumbs__item"><?php the_title(); ?></li>
							</ul>
						</div>
					</div>
					<div class="col-md-4">
						<?php get_search_form(); ?>
					</div>
				</div>
			</div>
		</div>
		<div class="content">
			<div class="text">
				<div class="container">
					<div class="row">
						<div class="col-md-12">
                            <?php the_content(); ?>
						</div>
					</div>
				</div>
			</div>
            <?php if(get_post_meta($post->ID, 'display', true) != 'no' or get_post_meta($post->ID, 'display2', true) != 'no' ) { ?>
			<div class="container">
                <?php if(get_post_meta($post->ID, 'display', true) != 'no') { ?>
				<div class="price-table">
					<div class="price-table__list row">
                    
						<div class="col-md-4 col-md-push-4">
							<div class="price-table__item price-table__item_best">
								<div class="price-table__best">
									<svg class="price-table__star"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_star"></use></svg> <?php esc_html_e('bestsellers', 'drivingschool'); ?> <svg class="price-table__star"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_star"></use></svg>
								</div>
								<div class="price-table__value"><?php echo esc_html(get_post_meta($post->ID, 'price2', true)); ?> <?php if(get_post_meta($post->ID, 'discount2', true) != '') { ?><span class="price-table__discount"><?php echo esc_html(get_post_meta($post->ID, 'discount2', true)); ?></span><?php } ?></div>
								<h3 class="price-table__name"><?php echo esc_html(get_post_meta($post->ID, 'name2', true)); ?></h3>
                                <?php if( have_rows('description2') ): ?>
								<ul class="price-table__feature-list">
                                    <?php while( have_rows('description2') ) : the_row(); ?>
									<li class="price-table__feature-item"><?php esc_html(the_sub_field('text')); ?></li>
                                    <?php endwhile; ?> 
								</ul>
                                <?php endif; ?> 
								<?php if(get_post_meta($post->ID, 'form2', true) != 'no') { ?>
								<a class="btn price-table__btn popup-bestsellers-btn" href="#">
									<span class="btn__text"><?php esc_html_e('send request', 'drivingschool'); ?></span>
                                    <div class="data-form" data-price="<?php echo esc_html(get_post_meta($post->ID, 'price2', true)); ?>" data-name="<?php echo esc_html(get_post_meta($post->ID, 'name2', true)); ?>" data-active="yes"> </div>
								</a>
                                <?php } ?>
								<div class="price-table__stars">
									<svg class="price-table__star"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_star"></use></svg>
									<svg class="price-table__star"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_star"></use></svg>
									<svg class="price-table__star"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_star"></use></svg>
								</div>
							</div>
						</div>

						<div class="col-md-4 col-md-pull-4">
							<div class="price-table__item">
								<div class="price-table__value"><?php echo esc_html(get_post_meta($post->ID, 'price1', true)); ?> <?php if(get_post_meta($post->ID, 'discount1', true) != '') { ?><span class="price-table__discount"><?php echo esc_html(get_post_meta($post->ID, 'discount1', true)); ?></span><?php } ?></div>
								<h3 class="price-table__name"><?php echo esc_html(get_post_meta($post->ID, 'name1', true)); ?></h3>
                                <?php if( have_rows('description1') ): ?>
								<ul class="price-table__feature-list">
                                    <?php while( have_rows('description1') ) : the_row(); ?>
									<li class="price-table__feature-item"><?php esc_html(the_sub_field('text')); ?></li>
                                    <?php endwhile; ?> 
								</ul>
                                <?php endif; ?> 
                                <?php if(get_post_meta($post->ID, 'form1', true) != 'no') { ?>
								<a class="btn price-table__btn popup-bestsellers-btn" href="#">
									<span class="btn__text"><?php esc_html_e('send request', 'drivingschool'); ?></span>
                                    <div class="data-form" data-price="<?php echo esc_html(get_post_meta($post->ID, 'price1', true)); ?>" data-name="<?php echo esc_html(get_post_meta($post->ID, 'name1', true)); ?>" data-active="no"> </div>
								</a>
                                <?php } ?>
							</div>
						</div>
 
						<div class="col-md-4">
							<div class="price-table__item">
								<div class="price-table__value"><?php echo esc_html(get_post_meta($post->ID, 'price3', true)); ?> <?php if(get_post_meta($post->ID, 'discount3', true) != '') { ?><span class="price-table__discount"><?php echo esc_html(get_post_meta($post->ID, 'discount3', true)); ?></span><?php } ?></div>
								<h3 class="price-table__name"><?php echo esc_html(get_post_meta($post->ID, 'name3', true)); ?></h3>
								<?php if( have_rows('description3') ): ?>
								<ul class="price-table__feature-list">
                                    <?php while( have_rows('description3') ) : the_row(); ?>
									<li class="price-table__feature-item"><?php esc_html(the_sub_field('text')); ?></li>
                                    <?php endwhile; ?> 
								</ul>
                                <?php endif; ?> 
                                <?php if(get_post_meta($post->ID, 'form3', true) != 'no') { ?>
								<a class="btn price-table__btn popup-bestsellers-btn" href="#">
									<span class="btn__text"><?php esc_html_e('send request', 'drivingschool'); ?></span>
                                    <div class="data-form" data-price="<?php echo esc_html(get_post_meta($post->ID, 'price3', true)); ?>" data-name="<?php echo esc_html(get_post_meta($post->ID, 'name3', true)); ?>" data-active="no"> </div>
								</a>
                                <?php } ?>
							</div>
						</div>
                        
					</div>
				</div>
                
                <?php } ?>
                
                <?php if(get_post_meta($post->ID, 'display2', true) != 'no') { ?>
				<div class="offer"<?php if(get_field('image') != '') { ?> style="background: #041320 url(<?php esc_url(the_field('image')); ?>) 50% no-repeat !important; background-size: cover;"<?php } ?>>
					<div class="offer__title"><?php echo esc_html(get_post_meta($post->ID, 'title', true)); ?></div>
					<div class="offer__value"><?php echo esc_html(get_post_meta($post->ID, 'text', true)); ?></div>
                    <?php if(get_post_meta($post->ID, 'form4', true) != 'no') { ?>
					<div class="offer__btn-wrap">
						<a class="btn offer__btn popup-bestsellers-btn" href="">
							<span class="btn__text"><?php esc_html_e('send request', 'drivingschool'); ?></span>
                            <div class="data-form" data-price="<?php echo esc_html(get_post_meta($post->ID, 'price4', true)); ?>" data-name="<?php echo esc_html(get_post_meta($post->ID, 'name4', true)); ?>" data-active="<?php echo esc_html(get_post_meta($post->ID, 'bestsellers', true)); ?>"> </div>
						</a>
					</div>
                    <?php } ?>
				</div>
                <?php } ?>
                
                <?php if(function_exists("drivingschool_form_plan")) { drivingschool_form_plan(); } ?>
                
			</div>
            <?php } ?>
            <?php if(get_post_meta($post->ID, 'display3', true) != 'no') { ?>
			<div class="course course_theme_light">
				<div class="container">
                    <?php if(get_post_meta($post->ID, 'title2', true) != '') { ?>
					<h2 class="title"><?php echo wp_kses(get_post_meta($post->ID, 'title2', true),array('strong'=> array())); ?></h2>
                    <?php } ?>
					<p class="desc course__desc"><?php echo wp_kses(get_post_meta($post->ID, 'text2', true),array('strong'=> array())); ?></p>
                    <?php if( have_rows('courses') ): ?> 
					<ul class="course__list row">
                        <?php while( have_rows('courses') ) : the_row(); ?>
                        <?php if(get_sub_field('block_type') == 'text') { ?>
						<li class="course__list-item col-md-4">
							<div class="course__item">
								<div class="course__item-head">
									<svg class="course__icon-guard"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#<?php esc_html(the_sub_field('icon')); ?>"></use></svg>
									<h3 class="course__item-name"><?php esc_html(the_sub_field('title')); ?></h3>
								</div>
								<div class="course__price">
                                    <?php if(get_sub_field('automatic') != '') { ?>
									<div class="course__price-item">
										<div class="course__price-kind"><?php esc_html_e('Automatic', 'drivingschool'); ?></div>
										<div class="course__price-value"><?php esc_html(the_sub_field('automatic')); ?></div>
									</div>
                                    <?php } if(get_sub_field('mechanics') != '') { ?>
									<div class="course__price-item">
										<div class="course__price-kind"><?php esc_html_e('Mechanics', 'drivingschool'); ?></div>
										<div class="course__price-value"><?php esc_html(the_sub_field('mechanics')); ?></div>
									</div>
                                    <?php } ?>
								</div>
								<div class="course__item-popup">
									<div class="course__item-popup-name"><?php esc_html(the_sub_field('title')); ?></div>
									<div class="course__item-popup-action">
										<div class="course__item-popup-period"><?php esc_html(the_sub_field('duration')); ?></div>
                                        <?php if(get_sub_field('link') != '') { ?>
										<a class="btn" href="<?php esc_url(the_sub_field('link')); ?>">
											<span class="btn__text"><?php esc_html_e('more info', 'drivingschool'); ?></span>
										</a>
                                        <?php 
										    } if(get_sub_field('form') != 'no') { 
											$thumb_url = wp_get_attachment_image_src(get_sub_field('image_form'),'drivingschool_about-thumb', true);
											if(get_sub_field('image_form') == '') { $thumb_url[0] = ''; }
										?>
										<a class="btn popup-protect-btn" href="#">
											<span class="btn__text"><?php esc_html_e('buy', 'drivingschool'); ?></span>
                                            <div class="data-form" data-title="<?php esc_html(the_sub_field('title')); ?>" data-duration="<?php esc_html(the_sub_field('duration')); ?>" data-icon="<?php esc_url(the_sub_field('icon_form')); ?>" data-img="<?php echo esc_url($thumb_url[0]); ?>"> </div>
										</a>
                                        <?php if( have_rows('texts') ): ?>
                                        <ul class="data-form form-li"> 
                                            <?php  while( have_rows('texts') ) : the_row(); ?>
                                            <li class="popup_protect__list-item"><?php esc_url(the_sub_field('text')); ?></li>
                                            <?php endwhile; ?> 
                                        </ul>
                                        <?php endif; ?>  
                                        <?php } ?>
									</div>
								</div>
							</div>
						</li>
                        <?php } else { ?>
                        <li class="course__list-item col-md-4">
							<div class="course__item <?php esc_html(the_sub_field('background_icon')); ?>">
								<div class="course__item-head course__item-head_cover">
									<svg class="course__icon-comment"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#<?php esc_html(the_sub_field('icon')); ?>"></use></svg>
									<h3 class="course__item-name"><?php esc_html(the_sub_field('title')); ?></h3>
								</div>
							</div>
						</li>
                        <?php } ?>
                        <?php endwhile; ?> 
					</ul>
                    <?php endif; ?>  
				</div>
			</div>
            <?php
                if(function_exists("drivingschool_form_course")) {
			        drivingschool_form_course();
		        }
		    ?>
            <?php } ?>
		<?php endwhile; ?>
	</div>
<?php get_footer();