<?php

/*

Template Name: Review

*/

drivingschool_on_ff();
?>
<?php get_header();  ?>
	<?php while (have_posts()) : the_post(); ?>
	<div class="head-page">
		<div class="container">
			<div class="row">
				<div class="col-md-8">
					<h1 class="title-page"><?php the_title(); ?></h1>
					<div class="breadcrumbs">
						<ul class="breadcrumbs__list">
							<li class="breadcrumbs__item">
								<a href="<?php echo esc_url( home_url('/') ); ?>" class="breadcrumbs__link"><?php esc_html_e('Index', 'drivingschool'); ?></a>
							</li>
							<?php if (drivingschool_is_subpage()) { ?>
							<li class="breadcrumbs__item">
								<a href="<?php echo get_permalink($post->post_parent); ?>" class="breadcrumbs__link"><?php echo get_the_title($post->post_parent); ?></a>
							</li>
							<?php } ?>
							<li class="breadcrumbs__item"><?php the_title(); ?></li>
						</ul>
					</div>
				</div>
				<div class="col-md-4">
					<?php get_search_form(); ?>
				</div>
			</div>
		</div>
	</div>
	<?php endwhile; ?>
	<div class="content">
		<div class="review-list">
		<?php 
			$number_reviews = 5;
			$paged = get_query_var( 'paged' ) ? absint( get_query_var( 'paged' ) ) : 1;
			if(get_field( "number_reviews" ) != '') { $number_reviews = get_field( "number_reviews" ); }
			$custom_query = new WP_Query(array('post_type' => 'review', 
											   'post_status' => 'publish', 
											   'posts_per_page' => $number_reviews,
											   'paged' => $paged
			)); 
			while($custom_query->have_posts()) : $custom_query->the_post(); 
		?>
			<blockquote class="quote">
				<div class="container">
					<div class="quote__header">
						<?php 
							if(get_field( "avatar" ) != "") { 
							$thumb_url = wp_get_attachment_image_src(get_field( "avatar" ),'drivingschool_ava-thumb', true);
						?>
						<figure class="quote__fig">
							<img src="<?php echo esc_url($thumb_url[0]); ?>" alt="<?php the_title(); ?>" />
						</figure>
						<?php } ?>
						<div class="quote__author"><?php the_title(); ?></div>
						<div class="quote__rating"></div>
					</div>
					<div class="quote__body"><?php echo esc_html(get_post_meta($post->ID, 'feedback', true)); ?></div>
				</div>
			</blockquote>
		<?php endwhile; wp_reset_postdata(); ?>   
		</div>
		<?php 
			if( get_post_meta($post->ID, 'agination', true) != 'no' ) {
				drivingschool_paginat($custom_query->max_num_pages); 
			}
			if(function_exists("drivingschool_form_review") and get_post_meta($post->ID, 'form', true) != "no") {                    drivingschool_form_review(); 
			} 
		?>
	</div>
<?php get_footer(); ?>