<?php drivingschool_on_ff();?>
<?php get_header();  ?>

<?php while (have_posts()) : the_post(); ?>
	<div class="head-page">
		<div class="container">
			<div class="row">
				<div class="col-md-8">
					<h1 class="title-page"><?php the_title(); ?></h1>
					<div class="breadcrumbs">
						<ul class="breadcrumbs__list">
							<li class="breadcrumbs__item">
								<a href="<?php echo esc_url( home_url('/') ); ?>" class="breadcrumbs__link"><?php esc_html_e('Index', 'drivingschool'); ?></a>
							</li>
							<?php if (drivingschool_is_subpage()) { ?>
							<li class="breadcrumbs__item">
								<a href="<?php echo get_permalink($post->post_parent); ?>" class="breadcrumbs__link"><?php echo get_the_title($post->post_parent); ?></a>
							</li>
							<?php } ?>
							<li class="breadcrumbs__item"><?php the_title(); ?></li>
						</ul>
					</div>
				</div>
				<div class="col-md-4">
					<?php get_search_form(); ?>
				</div>
			</div>
		</div>
	</div>
	<?php endwhile; ?>
	<div class="content">
		<div class="teacher">
			<?php 
				if(function_exists("drivingschool_form_filter_teachers") and  get_post_meta($post->ID, 'filter', true) == "yes") { 
					drivingschool_form_filter_teachers(); 
				} 
			?>
			<div class="teacher-list">
				<div class="container">
					<h2 class="title"><span class="title__mark"><?php esc_html_e('Search', 'drivingschool'); ?> </span><?php esc_html_e('Result', 'drivingschool'); ?></h2>
					<ul class="teacher-list__list row">
					<?php 
						$number_teachers = 12;
						if(function_exists("drivingschool_serch_field")) {
							$filter_fields = drivingschool_serch_field();
						} else {
							$filter_fields = '';
						}
						if(get_field( "number_teachers" ) != '') { $number_teachers = get_field( "number_teachers" ); }
						$custom_query = new WP_Query(array('post_type' => 'teachers', 
														  'post_status' => 'publish', 
														  'meta_query' => $filter_fields,
														  'posts_per_page' => $number_teachers
						)); 
					 while($custom_query->have_posts()) : $custom_query->the_post(); 
					?>
						<li class="teacher-list__item col-md-4">
							<div class="badge">
								<a href="<?php the_permalink();?>" class="badge__wrap">
									<div class="badge__head">
										<?php if( has_post_thumbnail() ) { ?>
										<div class="badge__fig">
											<?php the_post_thumbnail('drivingschool_teacher-thumb'); ?>
										</div>
										<?php } ?>
										<div class="badge__head-body">
											<div class="badge__name"><?php the_title(); ?></div>
											<?php if(have_rows('cars')): ?>
											<div class="badge__car">
											<?php 
												$car = ""; while(have_rows('cars')) : the_row(); $car .= get_sub_field('car').', ';  endwhile; 
												$car = trim($car, ', ');
												echo esc_html($car);
											?>
											</div>
											<?php endif; ?>
											<div class="badge__category"><?php echo esc_html(get_post_meta($post->ID, 'categories', true)); ?></div>
										</div>
									</div>
									<?php if(have_rows('data')): ?>
									<div class="badge__body">
										<?php while(have_rows('data')) : the_row(); ?>
										<div class="badge__data">
											<span class="badge__data-term"><?php esc_html(the_sub_field('text1')); ?></span>
											<span class="badge__data-separ"></span>
											<span class="badge__data-desc"><?php esc_html(the_sub_field('text2')); ?></span>
										</div>
										<?php endwhile; ?>
									</div>
									<?php endif; ?>
								</a>
							</div>
						</li>
					  <?php 
						  endwhile; wp_reset_postdata();
						  if (  $custom_query->max_num_pages == 0) { 
							  echo '<li  class="no_matches">'.esc_html__("No matches found.","drivingschool").'</li>'; 
						  }
					  ?>
					  </ul>
					  
					  <?php if(get_theme_mod('drivingschool_pagination') == "yes") { ?>
					  <ul class="teacher-list__list row loadmore_container"> </ul>
					  <?php 
							if (  $custom_query->max_num_pages > 1) :
								echo drivingschool_ajax_cat(
										 serialize($custom_query->query_vars),
										 (get_query_var('paged')) ? get_query_var('paged') : 1, 
										 $custom_query ->max_num_pages,
										 2
							); 
					  ?>
							<div class="teacher-list__load">
								<a class="btn btn_theme_blue btn_fullwidth" id="true_loadmore" href="javascript:void(0);">
									<span class="btn__text"><?php esc_html_e('load more', 'drivingschool'); ?></span>
								</a>
							</div>
					<?php 
						  endif; 
						  } else {
							  drivingschool_paginat(); 
						  }
					?>
				</div>
			</div>
		</div>
	</div>
<?php get_footer(); ?>