<?php get_header(); ?>
	<div class="head-page">
		<div class="container">
			<div class="row">
				<div class="col-md-8">
					<h1 class="title-page"><?php single_tag_title(); ?></h1>
					<div class="breadcrumbs">
						<ul class="breadcrumbs__list">
							<li class="breadcrumbs__item">
								<a href="<?php echo esc_url( home_url('/') ); ?>" class="breadcrumbs__link"><?php esc_html_e('Index', 'drivingschool'); ?></a>
							</li>
							<li class="breadcrumbs__item"><?php single_tag_title(); ?></li>
						</ul>
					</div>
				</div>
				<div class="col-md-4">
					<?php get_search_form(); ?>
				</div>
			</div>
		</div>
	</div>
	<div class="content">
		<div class="blog">
			<div class="container">
				<div class="row">
				
				<div class="col-md-9">
					<div class="post-list">
					<?php $i = 0; if ( have_posts() ) : while ( have_posts() ) : the_post(); $i++; ?>
						<article class="post">
							<div class="row">
                                <?php $column = '12'; ?>
								<?php if( has_post_thumbnail() ) { ?>
								<div class="col-md-3">
									<figure class="post__fig">											
									   <a href="<?php the_permalink();?>"><?php the_post_thumbnail('drivingschool_posts-thumb'); ?></a> 
									</figure>
									<time datetime="<?php echo get_the_date( DATE_W3C );?>" class="post__date"><?php the_date(); ?></time>
								</div>
								<?php $column = '9'; } ?>
									<div class="col-md-<?php echo esc_attr( $column ); ?>">
									<h3 class="post__title">
										<a href="<?php the_permalink();?>" class="post__title-link"><?php the_title(); ?></a>
									</h3>
									<p class="post__text"><?php echo drivingschool_get_excerpt(190); ?></p>
									<div class="post__meta">
										<div class="post__meta-item">
											<a href="<?php the_permalink();?>#respond" class="post__meta-comments"><?php comments_number(esc_html__("0 comments","drivingschool"),esc_html__("1 comment","drivingschool"),esc_html__("% comments","drivingschool")); ?></a>
										</div>
										<?php if( function_exists('drivingschool_postviews')){?>
											<div class="post__meta-item">
												<div class="post__meta-view"><?php drivingschool_postviews($post->ID); ?></div>
											</div>
										<?php } ?>
									</div>
								</div>
							</div>
						</article>
						<?php 
							endwhile;  
							if(get_theme_mod('drivingschool_pagination') == "yes") {
						?>
						<div class="loadmore_container"> </div>
						<?php 
							if (  $wp_query->max_num_pages > 1 and get_theme_mod('thecrazy_pogination_on')!="numbers") :
							echo drivingschool_ajax_cat(
									 serialize($wp_query->query_vars),
									 (get_query_var('paged')) ? get_query_var('paged') : 1, 
									 $wp_query->max_num_pages
							); 
						?>
						<div class="post-list__more">
							<a class="btn btn_theme_blue btn_fullwidth" id="true_loadmore" href="javascript:void(0);">
								<span class="btn__text"><?php esc_html_e('load more', 'drivingschool'); ?></span>
							</a>
						</div>
						<?php 
							endif; 
							} else {
								drivingschool_paginat(); 
							}
							endif; 
						?>
					</div>
				</div>
                    
                <?php get_sidebar(); ?>

			</div>
		</div>
	</div>
<?php get_footer();
