<?php

function about1_shortcode($atts, $content = null ) {
    extract( shortcode_atts( array(
		'title1' => '',
		'title2' => '',
		'link' => '',
		'textlink' => '',
		'picture' => '',
		'title3' => '',
		'title4' => '',
		'text' => '',
		'year' => '',
		'month' => '',
		'date' => '',
		'hours' => '',
		'minutes' => '',
		'link2' => '',
		'textlink2' => '',
	), $atts ) );
	$thumb_url = wp_get_attachment_image_src($picture,'full', true);
	
	$default_year = ($year != '' ) ? $year : date('Y');
	$default_month = ($year != '' ) ? $month : date('n');
	$days_in_month = cal_days_in_month(CAL_GREGORIAN, $default_month, $default_year);
	$default_days = ($date != '' ) ? $date : $days_in_month;
	$default_hours = ($hours != '' ) ? $hours : 23;
	$default_minutes = ($minutes != '' ) ? $minutes : 59;
	
	$until = $default_year . ',' . $default_month . ',' . $default_days . ',' . $default_hours . ',' . $default_minutes;
	$data_until = $until;
    
    ob_start();

?>
		<div class="about"<?php if($picture != '') { ?> style="background: url(<?php echo $thumb_url[0]; ?>) 50% no-repeat; background-size: cover;"<?php } ?>>
			<div class="container">
				<div class="row">
					<div class="col-md-7">
						<div class="about__body">
							<div class="about__body-inner">
                                <?php if($title1 != "" or $title2 != "") { ?><h2 class="title"><?php if($title1 != "") { ?><span class="title__mark"><?php echo $title1; ?> </span><?php  } echo $title2; ?></h2><?php } ?>
                                <?php echo do_shortcode(str_replace(array("[p]", "[/p]"),array("<p>", "</p>", "fiber"), $content)); ?>
                                <?php if($link != "") { ?>
								<a class="btn about__btn" href="<?php echo $link; ?>">
									<span class="btn__text"><?php echo $textlink; ?></span>
								</a>
                                <?php } ?>
							</div>
						</div>
					</div>
					<div class="col-md-5">
						<div class="discount">
                            <?php if($title3 != "" and $title4 != "") { ?>
							<h2 class="title discount__title"><?php if($title3 != "") { ?><span class="title__mark"><?php echo $title3; ?> </span><?php  } echo $title4; ?></h2>
                            <?php } ?>
							<div class="discount__body">
								<p class="discount__desc"><?php echo $text; ?></p>
								<div class="countdown discount__countdown">
									<div id="countdown" class="countdown__timer" data-until="<?php echo $data_until;?>">
										<span id="countdownLayout">
											<span class="countdown__item">
												<span>{dn}</span>
											</span>
											<span class="countdown__item">
												<span>{hn}</span>
											</span>
											<span class="countdown__item">
												<span>{mn}</span>
											</span>
											<span class="countdown__item">
												<span>{sn}</span>
											</span>
										</span>
									</div>
									
									<div class="countdown__section">
										<div class="countdown__item-wrap">
											<input type="text" data-min="0" data-max="356" value="{dn}" data-width="52" data-bgColor="#000e1b" data-fgColor="#ffea00" data-thickness=".08" class="countdown__item-d" />
										</div>
										<span class="countdown__period"><?php esc_html_e('Days', 'drivingschool-plugin'); ?></span>
									</div>
									
									<div class="countdown__section">
										<div class="countdown__item-wrap">
											<input type="text" data-min="0" data-max="24" value="{hn}" data-width="52" data-bgColor="#000e1b" data-fgColor="#ffea00" data-thickness=".08" class="countdown__item-h" />
										</div>
										<span class="countdown__period"><?php esc_html_e('Hours', 'drivingschool-plugin'); ?></span>
									</div>
									<div class="countdown__section">
										<div class="countdown__item-wrap">
											<input type="text" data-min="0" data-max="60" value="{mn}" data-width="52" data-bgColor="#000e1b" data-fgColor="#ffea00" data-thickness=".08" class="countdown__item-m" />
										</div>
										<span class="countdown__period"><?php esc_html_e('Minutes', 'drivingschool-plugin'); ?></span>
									</div>
									<div class="countdown__section">
										<div class="countdown__item-wrap">
											<input type="text" data-min="0" data-max="60" value="{sn}" data-width="52" data-bgColor="#000e1b" data-fgColor="#ffea00" data-thickness=".08" class="countdown__item-s" />
										</div>
										<span class="countdown__period"><?php esc_html_e('seconds', 'drivingschool-plugin'); ?></span>
									</div>
								</div>
                                <?php if($link2 != "") { ?>
								<a class="btn about__btn" href="<?php echo $link2; ?>">
									<span class="btn__text"><?php echo $textlink; ?></span>
								</a>
                                <?php } ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
<?php
    $output = ob_get_contents();
	ob_end_clean();
	return $output;
}

add_shortcode('about1', 'about1_shortcode');
add_action( 'vc_before_init', 'about1_integrateWithVC' );
function about1_integrateWithVC() {
	
	$dropdown_years = array(date('Y') => date('Y'));
	foreach (range(date('Y'), date('Y') + 10) as $year) {
		$dropdown_years[$year] = $year;
	}
	
	$dropdown_months = array();
	foreach (range(1, 12) as $month) {
		$dropdown_months[$month] = $month;
	}
	
	$dropdown_days = array();
	foreach (range(1, 31) as $day) {
		$dropdown_days[$day] = $day;
	}
	
	$dropdown_hours = array();
	foreach (range(1, 23) as $hour) {
		$dropdown_hours[$hour] = $hour;
	}
	$dropdown_minutes = array();
	foreach (range(1, 59) as $minute) {
		$dropdown_minutes[$minute] = $minute;
	}
	
    vc_map( array(
        "name" => esc_html__("About 1","drivingschool-plugin"),
        "base" => "about1",
        "category" => esc_html__('Shortcodes "DrivingSchool"','drivingschool-plugin'),
        "params" => array(
		     array(
                "type" => "",
                "heading" => '<a target="_blank" href="'.esc_url( home_url() ).'/wp-content/plugins/drivingschool-plugin/composer/scrin/s3.png">'.esc_html__('Аppearance of block','drivingschool-plugin').'</a>',
                "param_name" => "scrin_vot",
                "value" => ""
             ),
			 array(
                 'type' => 'attach_image',
                 'value' => '',
                 'heading' => esc_html__("Background picture","drivingschool-plugin"),
                 'param_name' => 'picture',
             ),
			 array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Title 1","drivingschool-plugin"),
                "param_name" => "title1",
                "value" => ""
            ),
			array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Title 2","drivingschool-plugin"),
                "param_name" => "title2",
                "value" => ""
            ),
			array(
                "type" => "textarea",
                "class" => "",
                "heading" => esc_html__("Text","drivingschool-plugin"),
                "param_name" => "content",
                "value" => ""
            ),
			array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Link","drivingschool-plugin"),
                "param_name" => "link",
                "value" => ""
            ),
			array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Text link","drivingschool-plugin"),
                "param_name" => "textlink",
                "value" => ""
            ),
			array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Title 1 - Side","drivingschool-plugin"),
                "param_name" => "title3",
                "value" => ""
            ),
			array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Title 2 - Side","drivingschool-plugin"),
                "param_name" => "title4",
                "value" => ""
            ),
			array(
                "type" => "textarea",
                "class" => "",
                "heading" => esc_html__("Text - Side","drivingschool-plugin"),
                "param_name" => "text",
                "value" => ""
            ),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Year - Side","drivingschool-plugin"),
				"param_name" => "year",
				"value" => $dropdown_years
			),
			array(
				"type" => "dropdown",
				"class" => "",
                "heading" => esc_html__("Month - Side","drivingschool-plugin"),
                "param_name" => "month",
				"value" => $dropdown_months
			),
			array(
				"type" => "dropdown",
				"class" => "",
                "heading" => esc_html__("Date - Side","drivingschool-plugin"),
                "param_name" => "date",
				"value" => $dropdown_days
			),
			array(
				"type" => "dropdown",
				"class" => "",
                "heading" => esc_html__("Hours - Side","drivingschool-plugin"),
                "param_name" => "hours",
				"value" => $dropdown_hours
			),
			array(
				"type" => "dropdown",
				"class" => "",
                "heading" => esc_html__("Minutes - Side","drivingschool-plugin"),
                "param_name" => "minutes",
				"value" => $dropdown_minutes
			),
			array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Link - Side","drivingschool-plugin"),
                "param_name" => "link2",
                "value" => ""
            ),
			array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Text link - Side","drivingschool-plugin"),
                "param_name" => "textlink2",
                "value" => ""
            ),

        )
    ));
}

?>