<?php

function best1_shortcode($atts, $content = null ) {
    extract( shortcode_atts( array(
		'title1' => '',
		'title2' => '',
		'blocks' => '',
    ), $atts ) );
	if(!empty($atts['blocks'])) {
	    $blocks = vc_param_group_parse_atts( $atts['blocks'] );
    } else { $blocks = ''; }
    
    ob_start();
?>
        <div class="best">
			<div class="container">
				<div class="row">
                    <?php if($title1 != "" or $title2 != "") { ?>
					<div class="best__title col-md-12">
						<h2 class="title"><?php if($title1 != "") { ?><span class="title__mark"><?php echo $title1; ?> </span><?php  } echo $title2; ?></h2>
					</div>
                    <?php } ?>
                    <?php if(!empty($blocks)) {  ?>
					<ul class="best__list">
                        <?php  foreach ( $blocks as $b_value ) { ?>
						<li class="best__item col-md-4">
							<svg class="best__male"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#<?php if(!empty($b_value['icon'])) { echo $b_value['icon']; } ?>"></use></svg>
                            <?php if(!empty($b_value['title'])) { ?>
							<h3 class="best__item-title"><?php echo $b_value['title'];?></h3>
                            <?php } ?>
							<p class="best__item-desc"><?php if(!empty($b_value['text'])) { echo $b_value['text']; } ?></p>
                            <?php if(!empty($b_value['link'])) { ?>
							<a href="<?php echo $b_value['link']; ?>" class="best__item-more"><?php echo $b_value['textlink'];?></a>
                            <?php } ?>
						</li>
                        <?php } ?>
					</ul>
                    <?php } ?>
				</div>
			</div>
		</div>
<?php
    $output = ob_get_contents();
	ob_end_clean();
	return $output;
}

add_shortcode('best1', 'best1_shortcode');
add_action( 'vc_before_init', 'best1_integrateWithVC' );
function best1_integrateWithVC() {
    vc_map( array(
        "name" => esc_html__("Best","drivingschool-plugin"),
        "base" => "best1",
        "category" => esc_html__('Shortcodes "DrivingSchool"','drivingschool-plugin'),
        "params" => array(
		     array(
                "type" => "",
                "heading" => '<a target="_blank" href="'.esc_url( home_url() ).'/wp-content/plugins/drivingschool-plugin/composer/scrin/s2.png">'.esc_html__('Аppearance of block','drivingschool-plugin').'</a>',
                "param_name" => "scrin_vot",
                "value" => ""
             ),
			 array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Title 1","drivingschool-plugin"),
                "param_name" => "title1",
                "value" => ""
            ),
			array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Title 2","drivingschool-plugin"),
                "param_name" => "title2",
                "value" => ""
            ),
			 array(
                'type' => 'param_group',
                'value' => '',
			    'heading' => esc_html__("Blocks","drivingschool-plugin"),
                'param_name' => 'blocks',
                'params' => array(
					array(
                        "type" => "textfield",
                        "class" => "",
                        "heading" => esc_html__("Title","drivingschool-plugin"),
                        "param_name" => "title",
                        "value" => ""
                   ),
				   array(
                        "type" => "textfield",
                        "class" => "",
                        "heading" => esc_html__("Text","drivingschool-plugin"),
                        "param_name" => "text",
                        "value" => ""
                   ),
				   array(
                        "type" => "textfield",
                        "class" => "",
                        "heading" => esc_html__("Icon","drivingschool-plugin"),
						"description" => '<a target="_blank" href="'.esc_url( home_url() ).'/wp-content/plugins/drivingschool-plugin/icons.php">'.esc_html__('Icons','drivingschool-plugin').'</a>',
                        "param_name" => "icon",
                        "value" => ""
                   ),
				   array(
                        "type" => "textfield",
                        "class" => "",
                        "heading" => esc_html__("Link","drivingschool-plugin"),
                        "param_name" => "link",
                        "value" => ""
                   ),
				   array(
                        "type" => "textfield",
                        "class" => "",
                        "heading" => esc_html__("Text link","drivingschool-plugin"),
                        "param_name" => "textlink",
                        "value" => ""
                   ),
					
			    )
            ),

        )
    ));
}

?>