<?php

function contact1_shortcode($atts, $content = null ) {
    extract( shortcode_atts( array(
		'address' => '',
		'phone' => '',
		'coordinate1' => '',
		'coordinate2' => '',
    ), $atts ) );
    
    ob_start();
    
	if($coordinate1 != "" and $coordinate2 != "")  {
?>
		<div class="contact">
			<div id="contactMap" data-lat="<?php echo $coordinate1; ?>" data-lng="<?php echo $coordinate2; ?>" class="contact__map"></div>
			<div class="contact__inner">
				<form action="<?php bloginfo('url'); ?>/wp-content/plugins/drivingschool-plugin/sendmail.php" id="message_form"  class="form contact__form">
					<div class="contact__head">
						<div class="form__row row">
                            <?php if($address != "") { ?>
							<div class="col-md-6">
								<div class="contact__adr">
									<div class="contact__head-icon">
										<svg class="contact__icon-pin"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_pin"></use></svg>
									</div><?php echo $address; ?></div>
							</div>
                            <?php } if($phone != "") { ?>
							<div class="col-md-6">
								<div class="contact__phone">
									<div class="contact__head-icon">
										<svg class="contact__icon-phone"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_phone"></use></svg>
									</div><?php echo $phone; ?></div>
							</div>
                            <?php } ?>
						</div>
					</div>
					<div class="form__row row">
						<div class="form__row-mobile col-md-6">
							<div class="control-group control-group_fullwidth">
								<span class="control-remark control-group__item">
									<svg class="control-remark__icon"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_users"></use></svg>
								</span>
								<span class="inp">
									<span class="inp__box">
										<input class="inp__control control-group__item mand" type="text" name="your-name" placeholder="<?php esc_html_e('Enter your name', 'drivingschool-plugin'); ?>" />
									</span>
								</span>
							</div>
						</div>
						<div class="col-md-6">
							<div class="control-group control-group_fullwidth">
								<span class="control-remark control-group__item">
									<svg class="control-remark__icon"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_mail"></use></svg>
								</span>
								<span class="inp">
									<span class="inp__box">
										<input class="inp__control control-group__item mand" type="email" name="email" placeholder="<?php esc_html_e('Enter your E-Mail', 'drivingschool-plugin'); ?>" />
									</span>
								</span>
							</div>
						</div>
					</div>
					<div class="form__row row">
						<div class="col-md-12">
							<textarea class="textarea textarea_fullwidth mand" placeholder="<?php esc_html_e('Enter your message', 'drivingschool-plugin'); ?>" name="message"></textarea>
						</div>
					</div>
					<div class="form__row row">
						<div class="col-md-12">
							<button class="btn btn_fullwidth" type="submit">
								<span class="btn__text"><?php esc_html_e('send request', 'drivingschool-plugin'); ?></span>
							</button>
						</div>
					</div>
                    <input type="hidden" name="nonce" class="nonce" value="<?php echo wp_create_nonce('contacts'); ?>">
                    <input name="typform" type="hidden" class="nonce" value="typ2">
                    <div class="results-ajax"> </div>
				</form>
			</div>
		</div>
<?php
    }
    $output = ob_get_contents();
	ob_end_clean();
	return $output;
}

add_shortcode('contact1', 'contact1_shortcode');
add_action( 'vc_before_init', 'contact1_integrateWithVC' );
function contact1_integrateWithVC() {
    vc_map( array(
        "name" => esc_html__("Contact","drivingschool-plugin"),
        "base" => "contact1",
        "category" => esc_html__('Shortcodes "DrivingSchool"','drivingschool-plugin'),
        "params" => array(
		     array(
                "type" => "",
                "heading" => '<a target="_blank" href="'.esc_url( home_url() ).'/wp-content/plugins/drivingschool-plugin/composer/scrin/s12.png">'.esc_html__('Аppearance of block','drivingschool-plugin').'</a>',
                "param_name" => "scrin_vot",
                "value" => ""
             ),
			 array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Address","drivingschool-plugin"),
                "param_name" => "address",
                "value" => ""
            ),
			array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Phone","drivingschool-plugin"),
                "param_name" => "phone",
                "value" => ""
            ),
			array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Latitude","drivingschool-plugin"),
                "param_name" => "coordinate1",
				"description" => "maps.google.com",
                "value" => ""
            ),
			array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Longitude","drivingschool-plugin"),
                "param_name" => "coordinate2",
				"description" => "maps.google.com",
                "value" => ""
            ),
			

        )
    ));
}

?>