<?php

function course1_shortcode($atts, $content = null ) {
    extract( shortcode_atts( array(
		'title' => '',
		'picture' => '',
		'course' => '',
    ), $atts ) );
	$thumb_url = wp_get_attachment_image_src($picture,'full', true);
	if(!empty($atts['course'])) {
	$course = vc_param_group_parse_atts( $atts['course'] );
	} else { $course = ''; }
    
    ob_start();
?>
		<div class="course course_index"<?php if($picture != '') { ?> style="background: #001a33 url(<?php echo $thumb_url[0]; ?>) 50% no-repeat;"<?php } ?>>
			<div class="container">
                <?php if($title != "") { ?>
				<h2 class="title title_theme_white">
					<span class="title__mark"><?php echo $title; ?> </span>
				</h2>
                <?php } if($content != "") { ?>
				<p class="desc course__desc"><?php echo $content; ?></p>
                <?php } if(!empty($course)) {  ?>
				<ul class="course__list row">
                <?php 
				    foreach ( $course as $c_value ) { 
					if(!empty($c_value['picture'])) {
						    $picture = wp_get_attachment_image_src($c_value['picture'],'drivingschool_about-thumb', true);
					} else { $picture[0] = ''; }
					if(!empty($c_value['form_icon'])) {
						    $form_icon = wp_get_attachment_image_src($c_value['form_icon'],'full', true);
					} else { $form_icon[0] = ''; }
					if($c_value['type'] == 'default') {
						 if(!empty($c_value['texts'] )) { 
						    $texts = vc_param_group_parse_atts( $c_value['texts'] );
						 } else { $texts = ''; }
				?>
					<li class="course__list-item col-md-4">
						<div class="course__item">
							<div class="course__item-head">
								<svg class="course__<?php if(!empty($c_value['icon'])) { echo str_replace("icon_", "icon-", $c_value['icon']); } ?>"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#<?php if(!empty($c_value['icon'])) { echo $c_value['icon']; } ?>"></use></svg>
								<h3 class="course__item-name"><?php if(!empty($c_value['name'])) { echo $c_value['name']; } ?></h3>
							</div>
							<div class="course__price">
                                <?php if(!empty($c_value['automatic'])) { ?>
								<div class="course__price-item">
									<div class="course__price-kind"><?php esc_html_e('Automatic', 'drivingschool-plugin'); ?></div>
									<div class="course__price-value"><?php echo $c_value['automatic']; ?></div>
								</div>
                                <?php } if(!empty($c_value['mechanics'])) { ?>
								<div class="course__price-item">
									<div class="course__price-kind"><?php esc_html_e('Mechanics', 'drivingschool-plugin'); ?></div>
									<div class="course__price-value"><?php echo $c_value['mechanics']; ?></div>
								</div>
                                <?php }  ?>
							</div>
							<div class="course__item-popup">
								<div class="course__item-popup-name"><?php if(!empty($c_value['name'])) { echo $c_value['name']; } ?></div>
								<div class="course__item-popup-action">
									<div class="course__item-popup-period"><?php if(!empty($c_value['duration'])) { echo $c_value['duration']; } ?></div>
                                    <?php if(!empty($c_value['link'])) { ?>
									<a class="btn" href="<?php echo $c_value['link']; ?>">
										<span class="btn__text"><?php esc_html_e('more info', 'drivingschool-plugin'); ?></span>
									</a>
                                    <?php } if($c_value['form'] != 'no') {   ?>
									<a class="btn popup-protect-btn" href="#">
										<span class="btn__text"><?php esc_html_e('buy', 'drivingschool-plugin'); ?></span>
                                        <div class="data-form" data-title="<?php if(!empty($c_value['name'])) { echo $c_value['name']; } ?>" data-duration="<?php if(!empty($c_value['duration'])) { echo $c_value['duration']; } ?>" data-icon="<?php echo $form_icon[0]; ?>" data-img="<?php echo $picture[0]; ?>"> </div>
									</a>
                                    <?php if(!empty($texts)) {  ?>
                                    <ul class="data-form form-li"> 
                                        <?php  foreach ( $texts as $t_value ) { ?>
                                        <?php if(!empty($t_value['text'])) { ?><li class="popup_protect__list-item"><?php  echo $t_value['text']; ?></li><?php } ?>
                                        <?php } ?> 
                                     </ul>
                                     <?php } ?> 
                                    <?php } ?>
								</div>
							</div>
						</div>
					</li>
                <?php } elseif($c_value['type'] == 'consultation') { ?>
					<li class="course__list-item col-md-4">
						<div class="course__item course__item_consultation">
							<div class="course__item-head course__item-head_cover">
                                <svg class="course__<?php if(!empty($c_value['icon'])) { echo str_replace("icon_", "icon-", $c_value['icon']); } ?>"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#<?php if(!empty($c_value['icon'])) { echo $c_value['icon']; } ?>"></use></svg>
								<h3 class="course__item-name"><?php if(!empty($c_value['name'])) { echo $c_value['name']; } ?></h3>
							</div>
						</div>
					</li>
                    <?php } elseif($c_value['type'] == 'police') { ?>
					<li class="course__list-item col-md-4">
						<div class="course__item course__item_police">
							<div class="course__item-head course__item-head_cover">
								<svg class="course__<?php if(!empty($c_value['icon'])) { echo str_replace("icon_", "icon-", $c_value['icon']); } ?>"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#<?php if(!empty($c_value['icon'])) { echo $c_value['icon']; } ?>"></use></svg>
								<h3 class="course__item-name"><?php if(!empty($c_value['name'])) { echo $c_value['name']; } ?></h3>
							</div>
						</div>
					</li>
                    <?php } ?> 
                <?php } ?> 
			    </ul>
             <?php } ?>
			</div>
		</div>
        <?php drivingschool_form_course(); ?>
<?php
    $output = ob_get_contents();
	ob_end_clean();
	return $output;
}

add_shortcode('course1', 'course1_shortcode');
add_action( 'vc_before_init', 'course1_integrateWithVC' );
function course1_integrateWithVC() {
    vc_map( array(
        "name" => esc_html__("Course 1","drivingschool-plugin"),
        "base" => "course1",
        "category" => esc_html__('Shortcodes "DrivingSchool"','drivingschool-plugin'),
        "params" => array(
		     array(
                "type" => "",
                "heading" => '<a target="_blank" href="'.esc_url( home_url() ).'/wp-content/plugins/drivingschool-plugin/composer/scrin/s8.png">'.esc_html__('Аppearance of block','drivingschool-plugin').'</a>',
                "param_name" => "scrin_vot",
                "value" => ""
             ),
			 array(
                 'type' => 'attach_image',
                 'value' => '',
                 'heading' => esc_html__("Background picture","drivingschool-plugin"),
                 'param_name' => 'picture',
             ),
			 array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Title","drivingschool-plugin"),
                "param_name" => "title",
                "value" => ""
            ),
			array(
                "type" => "textarea",
                "class" => "",
                "heading" => esc_html__("Text","drivingschool-plugin"),
                "param_name" => "content",
                "value" => ""
            ),
			array(
                'type' => 'param_group',
                'value' => '',
			    'heading' => esc_html__("Course","drivingschool-plugin"),
                'param_name' => 'course',
                'params' => array(
					array(
                        "type" => "textfield",
                        "class" => "",
                        "heading" => esc_html__("Name","drivingschool-plugin"),
                        "param_name" => "name",
                        "value" => ""
                   ),
				   array(
                        "type" => "textfield",
                        "class" => "",
                        "heading" => esc_html__("Icon","drivingschool-plugin"),
						"description" => '<a target="_blank" href="'.esc_url( home_url() ).'/wp-content/plugins/drivingschool-plugin/icons.php">'.esc_html__('Icons','drivingschool-plugin').'</a>',
                        "param_name" => "icon",
                        "value" => ""
                   ),
				   array(
                        "type" => "textfield",
                        "class" => "",
                        "heading" => esc_html__("Automatic","drivingschool-plugin"),
                        "param_name" => "automatic",
                        "value" => ""
                   ),
				   array(
                        "type" => "textfield",
                        "class" => "",
                        "heading" => esc_html__("Mechanics","drivingschool-plugin"),
                        "param_name" => "mechanics",
                        "value" => ""
                   ),
				   array(
                        "type" => "textfield",
                        "class" => "",
                        "heading" => esc_html__("Duration","drivingschool-plugin"),
                        "param_name" => "duration",
                        "value" => ""
                   ),
				   array(
                        "type" => "textfield",
                        "class" => "",
                        "heading" => esc_html__("Link","drivingschool-plugin"),
                        "param_name" => "link",
                        "value" => ""
                   ),
				   array(
                       "type" => "dropdown",
                       "class" => "",
                       "heading" => esc_html__("Form","drivingschool-plugin"),
                       "param_name" => "form",
                       "value" => array(
				           "yes" => "Yes",
					       "no" => "No",
				       )
                   ),
				   array(
                       "type" => "dropdown",
                       "class" => "",
                       "heading" => esc_html__("Block type","drivingschool-plugin"),
                       "param_name" => "type",
                       "value" => array(
				           "Default" => "default",
					       "Consultation" => "consultation",
						   "Police" => "police",
				       )
                   ),
				   array(
                      'type' => 'param_group',
                      'value' => '',
			          'heading' => esc_html__("Texts","drivingschool-plugin"),
                      'param_name' => 'texts',
                      'params' => array(
					       array(
                               "type" => "textfield",
                               "class" => "",
                               "heading" => esc_html__("Text","drivingschool-plugin"),
                               "param_name" => "text",
                               "value" => ""
                           ),
			           )
                   ),
				   array(
                     'type' => 'attach_image',
                     'value' => '',
                     'heading' => esc_html__("Picture","drivingschool-plugin"),
                     'param_name' => 'picture',
                  ),
				  array(
                     'type' => 'attach_image',
                     'value' => '',
                     'heading' => esc_html__("Form icon","drivingschool-plugin"),
                     'param_name' => 'form_icon',
                  ),
					
			    )
            ),	

        )
    ));
}

?>