<?php

function instructor1_shortcode($atts, $content = null ) {
    extract( shortcode_atts( array(
		'title1' => '',
		'title2' => '',
		'reviews' => '',
    ), $atts ) );
	if(!empty($atts['reviews'])) {
	$reviews = vc_param_group_parse_atts( $atts['reviews'] );
	 } else { $reviews = ''; }
    
    ob_start();
?>
		<div class="instructor">
			<div class="container">
				<?php if($title1 != "" or $title2 != "") { ?><h2 class="title"><?php if($title1 != "") { ?><span class="title__mark"><?php echo $title1; ?> </span><?php  } echo $title2; ?></h2>
                <?php } if($content != "") { ?>
				<p class="desc"><?php echo $content; ?></p>
                <?php } ?>
                <?php if(!empty($reviews)) {  ?>
                <div class="instructor__list">
					<div id="instructorSlider" class="swiper-container">
                        <div class="swiper-wrapper">
                        <?php  
				            foreach ( $reviews as $r_value ) { 
					            if(!empty($r_value['picture'])) {
						            $picture = wp_get_attachment_image_src($r_value['picture'],'drivingschool_ava_big', true);
								} else { $picture[0] = ''; }
				        ?>
							<div class="swiper-slide">
								<div class="instructor__list-item row">
                                    <?php if(!empty($r_value['picture'])) { ?>
									<figure class="instructor__fig col-md-5 col-lg-6">
										<img src="<?php echo $picture[0]; ?>" alt="<?php if(!empty($r_value['name'])) { echo $r_value['name']; } ?>" />
									</figure>
                                    <?php }  ?>
									<div class="instructor__body col-md-7 col-lg-6">
										<h4 class="instructor__name"><?php if(!empty($r_value['name'])) { echo $r_value['name']; } ?></h4>
										<div class="instructor__type"><?php if(!empty($r_value['position'])) { echo $r_value['position']; } ?></div>
										<blockquote class="instructor__quote">
											<div class="instructor__quote-inner"><?php if(!empty($r_value['text'])) { echo $r_value['text']; } ?></div>
										</blockquote>
									</div>
								</div>
							</div>
                            <?php } ?> 
						</div>
					</div>
			</div>
             <?php } ?>
			<div class="col-md-6 col-md-offset-5 col-lg-offset-6">
                <?php if(!empty($reviews)) {  ?>
				<div class="instructor__pager">
                    <?php  
				        foreach ( $reviews as $r_value ) { 
					    if(!empty($r_value['avatar'])) {
						    $avatar = wp_get_attachment_image_src($r_value['avatar'],'drivingschool_ava-thumb', true);
				    ?>
					<div class="instructor__pager-item">
						<img src="<?php echo $avatar[0]; ?>" alt="<?php if(!empty($r_value['name'])) { echo $r_value['name']; } ?>" />
					</div>
                    <?php } } ?>
				</div>
                <?php } ?>
			</div>
		</div>
		</div>
<?php
    $output = ob_get_contents();
	ob_end_clean();
	return $output;
}

add_shortcode('instructor1', 'instructor1_shortcode');
add_action( 'vc_before_init', 'instructor1_integrateWithVC' );
function instructor1_integrateWithVC() {
    vc_map( array(
        "name" => esc_html__("Instructor 1","drivingschool-plugin"),
        "base" => "instructor1",
        "category" => esc_html__('Shortcodes "DrivingSchool"','drivingschool-plugin'),
        "params" => array(
		     array(
                "type" => "",
                "heading" => '<a target="_blank" href="'.esc_url( home_url() ).'/wp-content/plugins/drivingschool-plugin/composer/scrin/s11.png">'.esc_html__('Аppearance of block','drivingschool-plugin').'</a>',
                "param_name" => "scrin_vot",
                "value" => ""
             ),
			 array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Title 1","drivingschool-plugin"),
                "param_name" => "title1",
                "value" => ""
            ),
			 array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Title 2","drivingschool-plugin"),
                "param_name" => "title2",
                "value" => ""
            ),
			array(
                "type" => "textarea",
                "class" => "",
                "heading" => esc_html__("Text","drivingschool-plugin"),
                "param_name" => "content",
                "value" => ""
            ),
			array(
                'type' => 'param_group',
                'value' => '',
			    'heading' => esc_html__("Instructor","drivingschool-plugin"),
                'param_name' => 'reviews',
                'params' => array(
					array(
                        "type" => "textfield",
                        "class" => "",
                        "heading" => esc_html__("Name","drivingschool-plugin"),
                        "param_name" => "name",
                        "value" => ""
                   ),
				   array(
                        "type" => "textfield",
                        "class" => "",
                        "heading" => esc_html__("Position","drivingschool-plugin"),
                        "param_name" => "position",
                        "value" => ""
                   ),
				   array(
                       "type" => "textarea",
                       "class" => "",
                       "heading" => esc_html__("Text","drivingschool-plugin"),
                       "param_name" => "text",
                       "value" => ""
                   ),
				   array(
                       'type' => 'attach_image',
                       'value' => '',
                       'heading' => esc_html__("Photo","drivingschool-plugin"),
                       'param_name' => 'picture',
                   ),
				   array(
                       'type' => 'attach_image',
                       'value' => '',
                       'heading' => esc_html__("Avatar","drivingschool-plugin"),
                       'param_name' => 'avatar',
                   ),

			    )
            ),	

        )
    ));
}

?>