<?php

function review1_shortcode($atts, $content = null ) {
    extract( shortcode_atts( array(
		'title' => '',
		'type' => '',
		'review' => '',
    ), $atts ) );
	if(!empty($atts['review'])) {
	$review = vc_param_group_parse_atts( $atts['review'] );
	 } else { $review = ''; }
    
    ob_start();
	 
?>
		<div class="review<?php if($type == "dark") { ?> review_theme_dark<?php } ?>">
			<div class="review__container container">
				<div class="row">
                    <?php if($title != "") { ?>
					<h2 class="title review__title">
						<span class="title__mark"><?php echo $title; ?></span>
					</h2>
                    <?php } ?>
                    <?php if(!empty($review)) {  ?>
					<div class="review__pager">
                        <?php  
						    foreach ( $review as $r_value ) {
							$avatar = wp_get_attachment_image_src($r_value['avatar'],'drivingschool_ava-thumb', true);
						?>
                        <?php if(!empty($r_value['avatar'])) { ?>
						<div class="review__pager-item">
							<img src="<?php echo $avatar[0]; ?>" alt="Andry Lincoln<?php if(!empty($r_value['name'])) { echo $r_value['name']; } ?>" />
						</div>
                        <?php } } ?>
					</div>
                    <?php } ?>
                    <?php if(!empty($review)) {  ?>
					<div id="reviewSlider" class="review__list swiper-container">
						<div class="swiper-wrapper">
                            <?php  foreach ( $review as $r_value ) { ?>
							<div class="swiper-slide">
								<div class="review__list-item col-md-12 col-lg-10 col-lg-offset-1">
									<blockquote class="review__block">
										<div class="review__block-body">
											<div class="review__block-text">
												<p><?php if(!empty($r_value['text'])) { echo $r_value['text']; } ?></p>
											</div>
											<footer class="review__block-footer">
												<div class="review__author"><?php if(!empty($r_value['name'])) { echo $r_value['name']; } ?></div>
											</footer>
											<div class="review__styler">
                                            <?php if($r_value['rating'] >= 1) {  ?>
												<svg class="review__styler-icon"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_star"></use></svg>
                                           <?php } if($r_value['rating'] >= 2) {  ?>
												<svg class="review__styler-icon"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_star"></use></svg>
                                           <?php } if($r_value['rating'] >= 3) {  ?>
												<svg class="review__styler-icon"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_star"></use></svg>
                                           <?php } if($r_value['rating'] >= 4) {  ?>
												<svg class="review__styler-icon"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_star"></use></svg>
                                           <?php } if($r_value['rating'] >= 5) {  ?>
												<svg class="review__styler-icon"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_star"></use></svg>
                                            <?php } ?>
											</div>
										</div>
									</blockquote>
								</div>
							</div>
                            <?php } ?>  
						</div>
					</div>
                    <?php } ?>
				</div>
			</div>
		</div>
<?php
    $output = ob_get_contents();
	ob_end_clean();
	return $output;
}

add_shortcode('review1', 'review1_shortcode');
add_action( 'vc_before_init', 'review1_integrateWithVC' );
function review1_integrateWithVC() {
    vc_map( array(
        "name" => esc_html__("Review","drivingschool-plugin"),
        "base" => "review1",
        "category" => esc_html__('Shortcodes "DrivingSchool"','drivingschool-plugin'),
        "params" => array(
		     array(
                "type" => "",
                "heading" => '<a target="_blank" href="'.esc_url( home_url() ).'/wp-content/plugins/drivingschool-plugin/composer/scrin/s7.png">'.esc_html__('Аppearance of block','drivingschool-plugin').'</a>',
                "param_name" => "scrin_vot",
                "value" => ""
             ),
			 array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Title","drivingschool-plugin"),
                "param_name" => "title",
                "value" => ""
            ),
			array(
                       "type" => "dropdown",
                       "class" => "",
                       "heading" => esc_html__("Type","drivingschool-plugin"),
                       "param_name" => "type",
                       "value" => array(
				           "Light" => "light",
					       "Dark" => "dark",
				       )
                   ),
			 array(
                'type' => 'param_group',
                'value' => '',
			    'heading' => esc_html__("Review","drivingschool-plugin"),
                'param_name' => 'review',
                'params' => array(
					array(
                        "type" => "textfield",
                        "class" => "",
                        "heading" => esc_html__("Name","drivingschool-plugin"),
                        "param_name" => "name",
                        "value" => ""
                   ),
				   array(
                        "type" => "textfield",
                        "class" => "",
                        "heading" => esc_html__("Text","drivingschool-plugin"),
                        "param_name" => "text",
                        "value" => ""
                   ),
				   array(
                      'type' => 'attach_image',
                      'value' => '',
                      'heading' => esc_html__("Avatar","drivingschool-plugin"),
                      'param_name' => 'avatar',
                  ),
				   array(
                "type" => "dropdown",
                "class" => "",
                "heading" => esc_html__("Rating","drivingschool-plugin"),
                "param_name" => "rating",
                "value" => array(
				     "5" => "5",
					 "4" => "4",
					 "3" => "3",
					 "2" => "2",
					 "1" => "1",
				)
             ),
					
			    )
            ),

        )
    ));
}

?>