<?php

function sertificate1_shortcode($atts, $content = null ) {
    extract( shortcode_atts( array(
		'title' => '',
		'sertificate' => '',
    ), $atts ) );
	if(!empty($atts['sertificate'])) {
	$sertificate = vc_param_group_parse_atts( $atts['sertificate'] );
	} else { $sertificate = ''; }
    
    ob_start();
?>
		<div class="sertificate">
			<div class="container">
                <?php if($title != "") { ?>
				<h2 class="title title_theme_white">
					<span class="title__mark"><?php echo $title; ?></span>
				</h2>
                <?php } if(!empty($sertificate)) {  ?>
				<ul class="sertificate__list row">
                    <?php 
					    foreach ( $sertificate as $s_value ) { 
						    $thumb_url = wp_get_attachment_image_src($s_value['picture'],'drivingschool_footor-thumb', true);
							$thumb_full = wp_get_attachment_image_src($s_value['picture'],'full', true);
							$alt = get_post_meta($s_value['picture'], '_wp_attachment_image_alt', true);
					?>
					<li class="sertificate__item col-xs-6 col-md-2">
					    <div class="sertificate__thumb" data-mfp-src="<?php echo esc_url($thumb_full[0]); ?>">
						     <svg class="zoom"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_search"></use></svg>
							 <img src="<?php echo esc_url($thumb_url[0]); ?>" alt="<?php echo esc_html($alt); ?>" />
						</div>
					</li>
                    <?php }  ?>
				</ul>
                <?php }  ?>
			</div>
		</div>
<?php
    $output = ob_get_contents();
	ob_end_clean();
	return $output;
}

add_shortcode('sertificate1', 'sertificate1_shortcode');
add_action( 'vc_before_init', 'sertificate1_integrateWithVC' );
function sertificate1_integrateWithVC() {
    vc_map( array(
        "name" => esc_html__("Sertificate","drivingschool-plugin"),
        "base" => "sertificate1",
        "category" => esc_html__('Shortcodes "DrivingSchool"','drivingschool-plugin'),
        "params" => array(
		     array(
                "type" => "",
                "heading" => '<a target="_blank" href="'.esc_url( home_url() ).'/wp-content/plugins/drivingschool-plugin/composer/scrin/s18.png">'.esc_html__('Аppearance of block','drivingschool-plugin').'</a>',
                "param_name" => "scrin_vot",
                "value" => ""
             ),
			 array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Title","drivingschool-plugin"),
                "param_name" => "title",
                "value" => ""
            ),
			array(
                'type' => 'param_group',
                'value' => '',
			    'heading' => esc_html__("Sertificate","drivingschool-plugin"),
                'param_name' => 'sertificate',
                'params' => array(
					array(
                 'type' => 'attach_image',
                 'value' => '',
                 'heading' => esc_html__("Picture","drivingschool-plugin"),
                 'param_name' => 'picture',
             ),
			    )
            ),	

        )
    ));
}

?>