<?php

function slider1_shortcode($atts, $content = null ) {
    extract( shortcode_atts( array(
        'slider' => '',
		'title1' => '',
		'title2' => '',
		'description1' => '',
		'note' => '',
		'cartype' => '',
		'driving' => '',
		'time' => '',
		'btn_text' => 'Find courses',
    ), $atts ) );
	if(!empty($atts['slider'])) {
	$slider = vc_param_group_parse_atts( $atts['slider'] );
	 } else { $slider = ''; }
	if(!empty($atts['cartype'])) {
	$cartype = vc_param_group_parse_atts( $atts['cartype'] );
	 } else { $cartype = ''; }
	if(!empty($atts['driving'])) {
	$driving = vc_param_group_parse_atts( $atts['driving'] );
	 } else { $driving = ''; }
	if(!empty($atts['time'])) {
	$time = vc_param_group_parse_atts( $atts['time'] );
	 } else { $time  = ''; }
	
	$auto_play = false;
	if( isset( $atts['autoplay'] ) && $atts['autoplay'] ) {
		$auto_play = $atts['autoplay'];
	}
    
    ob_start();
?>
		<div class="tiser">
			<div id="tiserSlider" class="swiper-container" data-autoplay="<?php echo esc_attr($auto_play);?>">
				<div class="swiper-wrapper">
                <?php 
					if(!empty($slider)) {
					    foreach ( $slider as $s_value ) { 
						if(!empty($s_value['picture'])) {
						    $picture = wp_get_attachment_image_src($s_value['picture'],'full', true);
						}
				?>
					<div style="background-image:url(<?php echo $picture[0]; ?>)" class="tiser__slide swiper-slide">
						<div class="tiser__body">
							<div class="container">
								<div class="row">
									<div class="tiser__body-inner">
										<div class="tiser__title-wrap">
                                        <?php if(!empty($s_value['title'])) { ?>
											<h3 class="tiser__title"> <?php echo $s_value['title']; ?></h3>
                                        <?php } ?>
										</div>
										<p class="tiser__desc"><?php if(!empty($s_value['text'])) { echo $s_value['text']; } ?></p>
									</div>
								</div>
							</div>
						</div>
					</div>
                <?php } } ?>  
				</div>
			</div>
			<div class="tiser__pager">
				<div class="container">
                <?php 
					if(!empty($slider)) {
						$si1 = 0;
					    foreach ( $slider as $s_value ) { $si1++;
				?>
					<div class="tiser__pager-item<?php if($si1==1) { echo " tiser__pager-item_active"; } ?>">
						<svg class="tiser__car"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#<?php if(!empty($s_value['icon'])) { echo $s_value['icon']; } ?>"></use></svg>
						<div class="tiser__pager-name"><?php if(!empty($s_value['name'])) { echo $s_value['name']; } ?></div>
						<div class="tiser__pager-desc"><?php if(!empty($s_value['description'])) { echo $s_value['description']; } ?></div>
					</div>
                <?php } } ?>   
				</div>
			</div>
			<div class="tiser__find">
				<div class="container">
					<form action="<?php bloginfo('url'); ?>/wp-content/plugins/drivingschool-plugin/sendmail.php" class="form col-md-4 tiser__form" id="slader1-form">
                        <?php if($title1 != "" and $title2 != "") { ?>
						<h3 class="form__title"><?php echo $title1; ?>
                            <?php if($title2 != "") { ?>
							<span class="form__mark">
								<span class="form__mark-text"><?php echo $title2; ?> </span>
							</span>
                             <?php } ?>
						</h3>
                        <?php } ?>
						<p class="form__desc"><?php echo $description1; ?></p>
						<div class="form__row row">
							<div class="col-md-12">
								<div class="control-group control-group_fullwidth">
									<span class="control-remark control-group__item">
										<svg class="control-remark__icon"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_users"></use></svg>
									</span>
									<span class="inp">
										<span class="inp__box">
											<input class="inp__control mand" type="text" name="your-name" placeholder="<?php esc_html_e('Enter your name', 'drivingschool-plugin'); ?>" />
										</span>
									</span>
								</div>
							</div>
						</div>
						<div class="form__row row">
							<div class="col-md-12">
								<div class="control-group control-group_fullwidth">
									<span class="control-remark control-group__item">
										<svg class="control-remark__icon"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_mail"></use></svg>
									</span>
									<span class="inp">
										<span class="inp__box">
											<input class="inp__control mand" type="email" name="email" placeholder="<?php esc_html_e('Enter your E-Mail', 'drivingschool-plugin'); ?>" />
										</span>
									</span>
								</div>
							</div>
						</div>
						<div class="form__row row">
							<div class="col-md-12">
								<div class="control-group control-group_fullwidth">
									<span class="control-remark control-group__item">
										<svg class="control-remark__icon"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_phone"></use></svg>
									</span>
									<span class="inp">
										<span class="inp__box">
											<input class="inp__control mand" type="tel" name="phone" placeholder="<?php esc_html_e('Enter your Phone', 'drivingschool-plugin'); ?>" />
										</span>
									</span>
								</div>
							</div>
						</div>
						<div class="form__row row">
                        <?php if(!empty($cartype)) {  ?>
							<div class="col-xs-6">
								<select name="cartype" class="select select_iconed" data-placeholder="<?php esc_html_e('Car type', 'drivingschool-plugin'); ?>">
									<option value=""></option>
                                    <?php  foreach ( $cartype as $c_value ) { ?>
                                    <?php if(!empty($c_value['value'])) { ?>
									<option value="<?php echo $c_value['value'];?>"><?php echo $c_value['value'];?></option>
                                    <?php }} ?>
								</select>
								<svg class="for-select"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_car"></use></svg>
							</div>
                        <?php } ?>
                        <?php if(!empty($driving)) {  ?>
							<div class="<?php if(!empty($cartype)) {  echo "col-xs-6"; } else { echo "col-xs-12"; }?>">
								<select name="driving" class="select select_iconed" data-placeholder="<?php esc_html_e('Driving', 'drivingschool-plugin'); ?>">
									<option value=""></option>
                                    <?php  foreach ( $driving as $d_value ) { ?>
                                    <?php if(!empty($d_value['value'])) { ?>
									<option value="<?php echo $d_value['value'];?>"><?php echo esc_html($d_value['value']);?></option>
                                    <?php }} ?>
								</select>
								<svg class="for-select"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_news"></use></svg>
							</div>
                        <?php } ?>
						</div>
						<div class="form__row row">
							<div class="col-xs-6">
								<div class="control-group control-group_fullwidth">
									<span class="control-remark control-group__item">
										<svg class="control-remark__icon"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_calendar"></use></svg>
									</span>
									<span class="inp">
										<span class="inp__box">
											<input class="inp__control input-datepicker" type="text" id="date" name="date" placeholder="<?php esc_html_e('Date', 'drivingschool-plugin'); ?>" />
										</span>
									</span>
								</div>
							</div>
                            <?php if(!empty($time)) {  ?>
							<div class="col-xs-6">
								<select name="time" class="select select_iconed" data-placeholder="<?php esc_attr_e('Time', 'drivingschool-plugin'); ?>">
									<option value=""></option>
                                    <?php  foreach ( $time as $t_value ) { ?>
                                    <?php if(!empty($t_value['value'])) { ?>
									<option value="<?php echo esc_attr($t_value['value']);?>"><?php echo esc_html($t_value['value']);?></option>
                                    <?php } } ?>
								</select>
								<svg class="for-select"><use xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_clock"></use></svg>
							</div>
                            <?php } ?>
						</div>
						<div class="form__row row">
							<div class="col-md-12">
								<button class="btn btn_fullwidth" type="submit">
									<span class="btn__text"><?php echo esc_html_e($btn_text); ?></span>
								</button>
							</div>
                            <input type="text" name="form_info">
                            <input type="hidden" name="nonce" class="nonce" value="<?php echo wp_create_nonce('slader1'); ?>">
                            <input name="typform" type="hidden" class="nonce" value="typ9">
						</div>
                        <div class="results-ajax"> </div>
						<div class="form__row row">
							<div class="col-md-12">
								<div class="form__info"><?php echo esc_html($note); ?></div>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
<?php
    $output = ob_get_contents();
	ob_end_clean();
	return $output;
}

add_shortcode('slider1', 'slider1_shortcode');
add_action( 'vc_before_init', 'slider1_integrateWithVC' );
function slider1_integrateWithVC() {
    vc_map( array(
        "name" => esc_html__("Slider","drivingschool-plugin"),
        "base" => "slider1",
        "category" => esc_html__('Shortcodes "DrivingSchool"','drivingschool-plugin'),
        "params" => array(
		     array(
                "type" => "",
                "heading" => '<a target="_blank" href="'.esc_url( home_url() ).'/wp-content/plugins/drivingschool-plugin/composer/scrin/s1.png">'.esc_html__('Аppearance of block','drivingschool-plugin').'</a>',
                "param_name" => "scrin_vot",
                "value" => ""
             ),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("AutoPlay seconds","drivingschool-plugin"),
				"param_name" => "autoplay",
				"value" => ""
		   	),
			 
			 array(
                'type' => 'param_group',
                'value' => '',
			    'heading' => esc_html__("Slides","drivingschool-plugin"),
                'param_name' => 'slider',
                'params' => array(
                    array(
                        'type' => 'attach_image',
                        'value' => '',
                        'heading' => esc_html__("Picture","drivingschool-plugin"),
                        'param_name' => 'picture',
                    ),
					array(
                        "type" => "textfield",
                        "class" => "",
                        "heading" => esc_html__("Name","drivingschool-plugin"),
                        "param_name" => "name",
                        "value" => ""
                   ),
				   array(
                        "type" => "textfield",
                        "class" => "",
                        "heading" => esc_html__("Description","drivingschool-plugin"),
                        "param_name" => "description",
                        "value" => ""
                   ),
				   array(
                        "type" => "textfield",
                        "class" => "",
                        "heading" => esc_html__("Icon","drivingschool-plugin"),
						"description" => '<a target="_blank" href="'.esc_url( home_url() ).'/wp-content/plugins/drivingschool-plugin/icons.php">'.esc_html__('Icons','drivingschool-plugin').'</a>',
                        "param_name" => "icon",
                        "value" => ""
                   ),
				   array(
                        "type" => "textfield",
                        "class" => "",
                        "heading" => esc_html__("Title","drivingschool-plugin"),
                        "param_name" => "title",
                        "value" => ""
                   ),
				   array(
                        "type" => "textfield",
                        "class" => "",
                        "heading" => esc_html__("Text","drivingschool-plugin"),
                        "param_name" => "text",
                        "value" => ""
                   ),
					
			    )
            ),
			
			array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Title 1 - Form","drivingschool-plugin"),
                "param_name" => "title1",
                "value" => ""
            ),
			array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Title 2 - Form","drivingschool-plugin"),
                "param_name" => "title2",
                "value" => ""
            ),
			array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Description - Form","drivingschool-plugin"),
                "param_name" => "description1",
                "value" => ""
            ),
			array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Submit Button Text","drivingschool-plugin"),
                "param_name" => "btn_text",
                "value" => ""
            ),
			array(
                'type' => 'param_group',
                'value' => '',
			    'heading' => esc_html__("Car type","drivingschool-plugin"),
                'param_name' => 'cartype',
                'params' => array(
					array(
                        "type" => "textfield",
                        "class" => "",
                        "heading" => esc_html__("Value","drivingschool-plugin"),
                        "param_name" => "value",
                        "value" => ""
                   ),
			    )
            ),
			array(
                'type' => 'param_group',
                'value' => '',
			    'heading' => esc_html__("Driving","drivingschool-plugin"),
                'param_name' => 'driving',
                'params' => array(
					array(
                        "type" => "textfield",
                        "class" => "",
                        "heading" => esc_html__("Value","drivingschool-plugin"),
                        "param_name" => "value",
                        "value" => ""
                   ),
			    )
            ),
			array(
                'type' => 'param_group',
                'value' => '',
			    'heading' => esc_html__("Time","drivingschool-plugin"),
                'param_name' => 'time',
                'params' => array(
					array(
                        "type" => "textfield",
                        "class" => "",
                        "heading" => esc_html__("Value","drivingschool-plugin"),
                        "param_name" => "value",
                        "value" => ""
                   ),
			    )
            ),
			array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Note","drivingschool-plugin"),
                "param_name" => "note",
                "value" => ""
            ),

        )
    ));
}

?>