<?php

function teacher1_shortcode($atts, $content = null ) {
    extract( shortcode_atts( array(
		'title1' => '',
		'title2' => '',
		'filters' => '',
		'number' => '',
    ), $atts ) );
	if(!empty($atts['points'])) {
	$points = vc_param_group_parse_atts( $atts['points'] );
	} else { $points= ''; }

    if(function_exists("drivingschool_form_filter_teachers") and  $filters != "no") { 
	    drivingschool_form_filter_teachers('no'); 
	} 
    
    ob_start();
?>
		<div class="teacher-list">
			<div class="container">
                <?php if($title1 != "" or $title2 != "") { ?>
				<h2 class="title">
					 <?php if($title1 != "") { ?><span class="title__mark"><?php echo $title1; ?> </span><?php  } echo $title2; ?></h2>
                <?php  } ?>
				<ul class="teacher-list__list row">
                <?php 
						   $number_teachers = 12;
						   if($number != '') { $number_teachers = $number; }
			               $custom_query = new WP_Query(array('post_type' => 'teachers', 
				                                              'post_status' => 'publish', 
												              'posts_per_page' => $number_teachers
				                           )); 
			               while($custom_query->have_posts()) : $custom_query->the_post(); 
		            ?>
					<li class="teacher-list__item col-md-4">
								<div class="badge">
									<a href="<?php the_permalink();?>" class="badge__wrap">
										<div class="badge__head">
                                            <?php if( has_post_thumbnail() ) { ?>
											<div class="badge__fig">
												<?php the_post_thumbnail('drivingschool_teacher-thumb'); ?>
											</div>
                                            <?php } ?>
											<div class="badge__head-body">
												<div class="badge__name"><?php the_title(); ?></div>
                                                <?php if(have_rows('cars')): ?>
												<div class="badge__car">
											    <?php 
												    $car = ""; while(have_rows('cars')) : the_row(); $car .= get_sub_field('car').', ';  endwhile; 
													$car = trim($car, ', ');
												    echo esc_html($car);
												?>
                                                </div>
                                                <?php endif; ?>
												<div class="badge__category"><?php echo esc_html(get_post_meta(get_the_ID(), 'categories', true)); ?></div>
											</div>
										</div>
                                        <?php if(have_rows('data')): ?>
										<div class="badge__body">
                                            <?php while(have_rows('data')) : the_row(); ?>
											<div class="badge__data">
												<span class="badge__data-term"><?php esc_html(the_sub_field('text1')); ?></span>
												<span class="badge__data-separ"></span>
												<span class="badge__data-desc"><?php esc_html(the_sub_field('text2')); ?></span>
											</div>
											<?php endwhile; ?>
										</div>
                                        <?php endif; ?>
									</a>
								</div>
							</li>
				<?php  endwhile; wp_reset_postdata(); ?>
				</ul>
				<?php if(get_theme_mod('drivingschool_pagination') == "yes") { ?>
                          <ul class="teacher-list__list row loadmore_container"> </ul>
                          <?php 
							    if (  $custom_query->max_num_pages > 1) :
                                    echo drivingschool_ajax_cat(
				                             serialize($custom_query->query_vars),
									         (get_query_var('paged')) ? get_query_var('paged') : 1, 
									         $custom_query ->max_num_pages,
											 2
							    ); 
						  ?>
								<div class="teacher-list__load">
									<a class="btn btn_theme_blue btn_fullwidth" id="true_loadmore" href="javascript:void(0);">
										<span class="btn__text"><?php esc_html_e('load more', 'drivingschool-plugin'); ?></span>
									</a>
								</div>
                        <?php 
						      endif; 
							  } else {
							      drivingschool_paginat(); 
							  }
						?>
			</div>
		</div>
<?php
    $output = ob_get_contents();
	ob_end_clean();
	return $output;
}

add_shortcode('teacher1', 'teacher1_shortcode');
add_action( 'vc_before_init', 'teacher1_integrateWithVC' );
function teacher1_integrateWithVC() {
    vc_map( array(
        "name" => esc_html__("Teacher","drivingschool-plugin"),
        "base" => "teacher1",
        "category" => esc_html__('Shortcodes "DrivingSchool"','drivingschool-plugin'),
        "params" => array(
		     array(
                "type" => "",
                "heading" => '<a target="_blank" href="'.esc_url( home_url() ).'/wp-content/plugins/drivingschool-plugin/composer/scrin/s20.png">'.esc_html__('Аppearance of block','drivingschool-plugin').'</a>',
                "param_name" => "scrin_vot",
                "value" => ""
             ),
			 array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Title 1","drivingschool-plugin"),
                "param_name" => "title1",
                "value" => ""
            ),
			array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Title 2","drivingschool-plugin"),
                "param_name" => "title2",
                "value" => ""
            ),
			array(
                       "type" => "dropdown",
                       "class" => "",
                       "heading" => esc_html__("Filters","drivingschool-plugin"),
                       "param_name" => "filters",
                       "value" => array(
				           "Yes" => "yes",
					       "No" => "no",
				       )
                   ),
	      array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Number of teachers","drivingschool-plugin"),
                "param_name" => "number",
                "value" => "12"
            ),

        )
    ));
}

?>