<?php
/**
 * Forms
 */

function drivingschool_form_call_me() { ?>
        <div class="popup popup_narrow popup_callback">
			<div class="popup__container container">
				<div class="row">
					<div class="popup__wrapper col col-md-4 col-sm-6">
						<div class="popup__head clearfix">
							<div class="row">
								<div class="popup__title col-sm-6 col-xs-8"><?php esc_html_e('Call Back', 'drivingschool-plugin'); ?></div>
								<div class="popup__close col-sm-6 col-xs-4"><div class="popup__close__button"></div></div>
							</div>
						</div>
                        <form action="<?php bloginfo('url'); ?>/wp-content/plugins/drivingschool-plugin/sendmail.php" method="post" id="callme-form">
						<div class="popup__body">
							<div class="form__row row">
								<div class="col-md-12">
									<div class="control-group control-group_fullwidth">
										<span class="control-remark control-group__item">
											<svg class="control-remark__icon"><use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_users"></use></svg>
										</span>
										<span class="inp">
											<span class="inp__box">
												<input class="inp__control mand" type="text" name="your-name" placeholder="<?php esc_html_e('Enter your name', 'drivingschool-plugin'); ?>">
											</span>
										</span>
									</div>
								</div>
							</div>
							<div class="form__row row">
								<div class="col-md-12">
									<div class="control-group control-group_fullwidth">
										<span class="control-remark control-group__item">
											<svg class="control-remark__icon"><use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_mail"></use></svg>
										</span>
										<span class="inp">
											<span class="inp__box">
												<input class="inp__control mand" type="email" name="email" placeholder="<?php esc_html_e('Enter your E-Mail', 'drivingschool-plugin'); ?>">
											</span>
										</span>
									</div>
								</div>
							</div>
							<div class="form__row row">
								<div class="col-md-12">
									<div class="control-group control-group_fullwidth">
										<span class="control-remark control-group__item">
											<svg class="control-remark__icon"><use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_phone"></use></svg>
										</span>
										<span class="inp">
											<span class="inp__box">
												<input class="inp__control mand" type="tel" name="phone" placeholder="<?php esc_html_e('Enter your Phone', 'drivingschool-plugin'); ?>">
											</span>
										</span>
									</div>
								</div>
							</div>
							<div class="form__row row">
								<div class="col-md-12">
									<button class="btn btn_fullwidth" type="submit">
										<span class="btn__text"><?php esc_html_e('send', 'drivingschool-plugin'); ?></span>
									</button>
								</div>
							</div>
                            <div class="results-ajax"> </div>
						</div>
                        <input type="text" name="form_info">
                        <input type="hidden" name="nonce" class="nonce" value="<?php echo wp_create_nonce('call_me'); ?>">
                        <input name="typform" type="hidden" class="nonce" value="typ1">
                        </form>
					</div>
				</div>
			</div>
			<div class="popup__bg"></div>
		</div>
<?php
} 

function drivingschool_form_contacts() {
?>
             <div class="add-form">
				<div class="container">
					<h2 class="title">
						<span class="title__mark"><?php esc_html_e('Send', 'drivingschool-plugin'); ?> </span><?php esc_html_e('message:', 'drivingschool-plugin'); ?></h2>
					    <form action="<?php bloginfo('url'); ?>/wp-content/plugins/drivingschool-plugin/sendmail.php" class="form" id="message_form" method="post">
						<div class="form__row row">
							<div class="form__row-mobile col-md-6">
								<div class="control-group control-group_fullwidth">
									<span class="control-remark control-group__item">
										<svg class="control-remark__icon"><use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_users"></use>
									</span>
									<span class="inp">
										<span class="inp__box">
											<input class="inp__control mand" type="text" name="your-name" placeholder="<?php esc_attr_e('Enter your name', 'drivingschool-plugin'); ?>" />
										</span>
									</span>
								</div>
							</div>
							<div class="col-md-6">
								<div class="control-group control-group_fullwidth">
									<span class="control-remark control-group__item">
										<svg class="control-remark__icon"><use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_mail"></use>
									</span>
									<span class="inp">
										<span class="inp__box">
											<input class="inp__control mand" type="email" name="email" placeholder="<?php esc_attr_e('Enter your E-Mail', 'drivingschool-plugin'); ?>" />
										</span>
									</span>
								</div>
							</div>
						</div>
						<div class="form__row row">
							<div class="col-md-12">
								<textarea class="textarea textarea_fullwidth mand" name="message" placeholder="<?php esc_html_e('Enter your message', 'drivingschool-plugin'); ?>" ></textarea>
							</div>
						</div>
						<div class="form__row row">
							<div class="col-md-12">
								<button class="btn btn_fullwidth" type="submit">
									<span class="btn__text"><?php esc_html_e('send', 'drivingschool-plugin'); ?></span>
								</button>
							</div>
						</div>
                        <input type="text" name="form_info">
                        <input type="hidden" name="nonce" class="nonce" value="<?php echo wp_create_nonce('contacts'); ?>">
                        <input name="typform" type="hidden" class="nonce" value="typ2">
                        <div class="results-ajax"> </div>
					</form>
				</div>
			</div>
<?php
} 

function drivingschool_form_question() {
?>
            <div class="add-form">
				<div class="container">
					<h2 class="title">
						<span class="title__mark"><?php esc_html_e('ADD', 'drivingschool-plugin'); ?> </span><?php esc_html_e('QUESTION:', 'drivingschool-plugin'); ?></h2>
					   <form action="<?php bloginfo('url'); ?>/wp-content/plugins/drivingschool-plugin/sendmail.php" class="form" id="question_form" method="post">
						<div class="form__row row">
							<div class="form__row-mobile col-md-6">
								<div class="control-group control-group_fullwidth">
									<span class="control-remark control-group__item">
										<svg class="control-remark__icon"><use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_users"></use></svg>
									</span>
									<span class="inp">
										<span class="inp__box">
											<input class="inp__control mand" type="text" name="your-name" placeholder="<?php esc_html_e('Enter your name', 'drivingschool-plugin'); ?>" />
										</span>
									</span>
								</div>
							</div>
							<div class="col-md-6">
								<div class="control-group control-group_fullwidth">
									<span class="control-remark control-group__item">
										<svg class="control-remark__icon"><use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_mail"></use></svg>
									</span>
									<span class="inp">
										<span class="inp__box">
											<input class="inp__control mand" type="email" name="email" placeholder="<?php esc_html_e('Enter your E-Mail', 'drivingschool-plugin'); ?>" />
										</span>
									</span>
								</div>
							</div>
						</div>
						<div class="form__row row">
							<div class="col-md-12">
								<textarea class="textarea textarea_fullwidth mand" placeholder="<?php esc_html_e('Enter your message', 'drivingschool-plugin'); ?>" name="question"></textarea>
							</div>
						</div>
						<div class="form__row row">
							<div class="col-md-12">
								<button class="btn btn_fullwidth" type="submit">
									<span class="btn__text"><?php esc_html_e('send request', 'drivingschool-plugin'); ?></span>
								</button>
							</div>
						</div>
                        <input type="text" name="form_info">
                        <input type="hidden" name="nonce" class="nonce" value="<?php echo wp_create_nonce('question'); ?>">
                        <input name="typform" type="hidden" class="nonce" value="typ3">
                        <div class="results-ajax"> </div>
					</form>
				</div>
			</div> 
<?php
} 

function drivingschool_form_plan() {
?>
		<div class="popup popup_narrow popup_bestsellers">
			<div class="popup__container container">
				<div class="row">
					<div class="popup__wrapper col col-md-4 col-sm-6">
						<div class="popup__head clearfix">
							<div class="row">
								<div class="popup__title col-sm-6 col-xs-8"><?php esc_html_e('send message', 'drivingschool-plugin'); ?></div>
								<div class="popup__close col-sm-6 col-xs-4"><div class="popup__close__button"></div></div>
							</div>
						</div>
						<div class="popup__body">
							<div class="row">
								<div class="col-xs-12">
									<div class="popup_bestsellers__title">
										<svg class="popup_bestsellers__title__icon left"><use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_star"></use></svg>
										<div class="popup_bestsellers__title__text"><?php esc_html_e('bestsellers','drivingschool-plugin');?></div>
										<svg class="popup_bestsellers__title__icon right"><use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_star"></use></svg>
										</div>
									<div class="popup_bestsellers__num"></div>
									<div class="popup_bestsellers__desc"></div>
								</div>
							</div>
                            <form action="<?php bloginfo('url'); ?>/wp-content/plugins/drivingschool-plugin/sendmail.php" class="form" id="plan_form" method="post">
							<div class="form__row row">
								<div class="col-md-12">
									<div class="control-group control-group_fullwidth">
										<span class="control-remark control-group__item">
											<svg class="control-remark__icon"><use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_users"></use></svg>
										</span>
										<span class="inp">
											<span class="inp__box">
												<input class="inp__control mand" type="text" name="your-name" placeholder="<?php esc_html_e('Enter your name', 'drivingschool-plugin'); ?>">
											</span>
										</span>
									</div>
								</div>
							</div>
							<div class="form__row row">
								<div class="col-md-12">
									<div class="control-group control-group_fullwidth">
										<span class="control-remark control-group__item">
											<svg class="control-remark__icon"><use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_mail"></use></svg>
										</span>
										<span class="inp">
											<span class="inp__box">
												<input class="inp__control mand" type="email" name="email" placeholder="<?php esc_html_e('Enter your E-Mail', 'drivingschool-plugin'); ?>">
											</span>
										</span>
									</div>
								</div>
							</div>
							<div class="form__row row">
								<div class="col-md-12">
									<div class="control-group control-group_fullwidth">
										<span class="control-remark control-group__item">
											<svg class="control-remark__icon"><use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_phone"></use></svg>
										</span>
										<span class="inp">
											<span class="inp__box">
												<input class="inp__control mand" type="tel" name="phone" placeholder="<?php esc_html_e('Enter your Phone', 'drivingschool-plugin'); ?>">
											</span>
										</span>
									</div>
								</div>
							</div>
							<div class="form__row row">
								<div class="col-md-12">
									<button class="btn btn_fullwidth" type="submit">
										<span class="btn__text"><?php esc_html_e('send request', 'drivingschool-plugin'); ?></span>
									</button>
								</div>
							</div>
                            <input type="text" name="form_info">
                            <input type="hidden" name="nonce" class="nonce" value="<?php echo wp_create_nonce('plan'); ?>">
                            <input name="typform" type="hidden" class="nonce" value="typ4">
                            <input name="nameplan" class="nameplan-input" type="hidden" value="">
                            <div class="results-ajax"> </div>
                            </form>
						</div>
					</div>
				</div>
			</div>
			<div class="popup__bg"></div>
		</div>
<?php
} 

function drivingschool_form_course() {
?>
		<div class="popup popup_wide popup_protect">
			<div class="popup__container container">
				<div class="row">
					<div class="popup__wrapper col col-md-7 col-sm-9">
						<div class="popup__head clearfix">
							<div class="row">
								<div class="popup__title col-sm-6 col-xs-8"><?php esc_html_e('send message', 'drivingschool-plugin'); ?></div>
								<div class="popup__close col-sm-6 col-xs-4"><div class="popup__close__button"></div></div>
							</div>
						</div>
						<div class="popup__body">
							<div class="popup_protect__top row">
								<div class="popup_protect__img col col-lg-4 col-md-5"><div><img src="<?php echo get_template_directory_uri(); ?>/assets/images/card1.jpg" alt="<?php esc_html_e('Picture', 'drivingschool-plugin'); ?>"></div></div>
								<div class="popup_protect__data col-lg-8 col-md-7">
									<div class="popup_protect__def row">
										<div class="popup_protect__def__img col">
											<img src="<?php echo get_template_directory_uri(); ?>/assets/images/shield.png" alt="<?php esc_html_e('Icons', 'drivingschool-plugin'); ?>">
										</div>
										<div class="popup_protect__def__text col">
											<div class="popup_protect__def__title"></div>
											<div class="popup_protect__def__days"></div>
										</div>
									</div>
								</div>
							</div>
                            <form action="<?php bloginfo('url'); ?>/wp-content/plugins/drivingschool-plugin/sendmail.php" class="form" id="course_form" method="post">
							<div class="row">
								<div class="col-sm-6">
									<div class="form__row row">
										<div class="col-md-12">
											<div class="control-group control-group_fullwidth">
												<span class="control-remark control-group__item">
													<svg class="control-remark__icon"><use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_users"></use></svg>
												</span>
												<span class="inp">
													<span class="inp__box">
														<input class="inp__control mand" type="text" name="your-name" placeholder="<?php esc_html_e('Enter your name', 'drivingschool-plugin'); ?>">
													</span>
												</span>
											</div>
										</div>
									</div>
									<div class="form__row row">
										<div class="col-md-12">
											<div class="control-group control-group_fullwidth">
												<span class="control-remark control-group__item">
													<svg class="control-remark__icon"><use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_mail"></use></svg>
												</span>
												<span class="inp">
													<span class="inp__box">
														<input class="inp__control mand" type="email" name="email" placeholder="<?php esc_html_e('Enter your E-Mail', 'drivingschool-plugin'); ?>">
													</span>
												</span>
											</div>
										</div>
									</div>
									<div class="form__row row">
										<div class="col-md-12">
											<div class="control-group control-group_fullwidth">
												<span class="control-remark control-group__item">
													<svg class="control-remark__icon"><use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_phone"></use></svg>
												</span>
												<span class="inp">
													<span class="inp__box">
														<input class="inp__control mand" type="tel" name="phone" placeholder="<?php esc_html_e('Enter your Phone', 'drivingschool-plugin'); ?>">
													</span>
												</span>
											</div>
										</div>
									</div>
								</div>
								<div class="popup_protect__radios col-sm-6">
									<div class="popup_protect__radio radio">
										<input type="radio" name="radio" id="radio-1" value="<?php esc_html_e('Automat', 'drivingschool-plugin'); ?>">
										<label for="radio-1" class="radio__label"></label>
										<p class="radio__text"><?php esc_html_e('Automat', 'drivingschool-plugin'); ?></p>
									</div>
									<div class="popup_protect__radio radio">
										<input type="radio" checked name="radio" id="radio-2" value="<?php esc_html_e('Mechanic', 'drivingschool-plugin'); ?>">
										<label for="radio-2" class="radio__label"></label>
										<p class="radio__text"><?php esc_html_e('Mechanic', 'drivingschool-plugin'); ?></p>
									</div>
								</div>
							</div>
							
							<div class="form__row row">
								<div class="col-md-12">
									<button class="btn btn_fullwidth" type="submit">
										<span class="btn__text"><?php esc_html_e('send request', 'drivingschool-plugin'); ?></span>
									</button>
								</div>
							</div>
                            <input type="text" name="form_info">
                            <input type="hidden" name="nonce" class="nonce" value="<?php echo wp_create_nonce('course'); ?>">
                            <input name="typform" type="hidden" class="nonce" value="typ5">
                            <input name="course" class="course-input" type="hidden" value="">
                            <div class="results-ajax"> </div>
                            </form>
						</div>
					</div>
				</div>
			</div>
			<div class="popup__bg"></div>
		</div>
<?php
} 

function drivingschool_form_review() {
    require_once(ABSPATH . "wp-admin" . '/includes/image.php');
    require_once(ABSPATH . "wp-admin" . '/includes/file.php');
    require_once(ABSPATH . "wp-admin" . '/includes/media.php');
?>
            <div class="add-form">
				<div class="container">
					<h2 class="title"><span class="title__mark"><?php esc_html_e('ADD', 'drivingschool-plugin'); ?> </span><?php esc_html_e('REVIEW:', 'drivingschool-plugin'); ?></h2>
					    <form action="<?php bloginfo('url'); ?>/wp-content/plugins/drivingschool-plugin/sendmail.php" class="form" id="review_form" method="post" enctype="multipart/form-data">
						<div class="form__row row">
							<div class="form__row-mobile col-md-6">
								<div class="control-group control-group_fullwidth">
									<span class="control-remark control-group__item">
										<svg class="control-remark__icon"><use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_users"></use></svg>
									</span>
									<span class="inp">
										<span class="inp__box">
											<input class="inp__control mand" type="text" name="your-name" placeholder="<?php esc_html_e('Enter your name', 'drivingschool-plugin'); ?>" />
										</span>
									</span>
								</div>
							</div>
							<div class="col-md-6">
								<div class="control-group control-group_fullwidth">
									<span class="control-remark control-group__item">
										<svg class="control-remark__icon"><use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_mail"></use></svg>
									</span>
									<span class="inp">
										<span class="inp__box">
											<input class="inp__control mand" type="email" name="email" placeholder="<?php esc_html_e('Enter your E-Mail', 'drivingschool-plugin'); ?>" />
										</span>
									</span>
								</div>
							</div>
						</div>
						<div class="form__row row">
							<div class="col-md-12">
								<textarea class="textarea textarea_fullwidth mand" placeholder="<?php esc_html_e('Enter your message', 'drivingschool-plugin'); ?>" name="message"></textarea>
							</div>
						</div>
						<div class="form__row row">
							<div class="col-md-2">
								<div class="form__rate">
									<span class="form__rate-lbl"><?php esc_html_e('Rating:', 'drivingschool-plugin'); ?></span>
									<div class="star-rating">
									  <fieldset>
									    <input type="radio" id="star5" name="rating" value="5" /><label for="star5"><?php esc_html_e('5 stars', 'drivingschool-plugin'); ?></label>
									    <input type="radio" id="star4" name="rating" value="4" /><label for="star4"><?php esc_html_e('4 stars', 'drivingschool-plugin'); ?></label>
									    <input type="radio" id="star3" name="rating" value="3" /><label for="star3"><?php esc_html_e('3 stars', 'drivingschool-plugin'); ?></label>
									    <input type="radio" id="star2" name="rating" value="2" /><label for="star2"><?php esc_html_e('2 stars', 'drivingschool-plugin'); ?></label>
									    <input type="radio" id="star1" name="rating" value="1" /><label for="star1"><?php esc_html_e('1 star', 'drivingschool-plugin'); ?></label>
									  </fieldset>
									</div>
								</div>
							</div>
							<div class="form__row-mobile col-md-4">
								<div class="form-group">
								  <input type="file" name="ava" id="file" class="input-file">
								  <label for="file" class="btn btn-tertiary js-labelFile btn_fullwidth btn_theme_blue">
								    <span class="js-fileName btn__text"><?php esc_html_e('LOAD PHOTO', 'drivingschool-plugin'); ?></span>
								  </label>
								</div>
							</div>
							<div class="col-md-6">
								<button class="btn btn_fullwidth" type="submit">
									<span class="btn__text"><?php esc_html_e('send request', 'drivingschool-plugin'); ?></span>
								</button>
							</div>
						</div>
                        <input type="text" name="form_info">
                        <input type="hidden" name="nonce" class="nonce" value="<?php echo wp_create_nonce('review'); ?>">
                        <?php wp_nonce_field( 'ava', 'my_image_upload_nonce' ); ?>
                        <input name="typform" type="hidden" class="nonce" value="typ6">
                        <div class="results-ajax"> </div>
					</form>
				</div>
			</div>
            <script src="https://use.fontawesome.com/797d3ee8d2.js"></script>
		    <script>
		    jQuery('.star-rating label').click(function(e){
		      var target = window[this.htmlFor];
		      target.checked = !target.checked;
		      e.preventDefault();
					ratingFor = jQuery(this).attr('for');

					var stringLength = ratingFor.length;
					var ratingVal = ratingFor.charAt(4);
					console.log(ratingVal);

		    });
		   </script>
<?php
} 

function drivingschool_form_teachers($postid) {
?>
        <div class="popup popup_wide popup_teacher">
			<div class="popup__container container">
				<div class="row">
					<div class="popup__wrapper col col-md-7 col-sm-9">
						<div class="popup__head clearfix">
							<div class="row">
								<div class="popup__title col-sm-6 col-xs-8"><?php esc_html_e('send message', 'drivingschool-plugin'); ?></div>
								<div class="popup__close col-sm-6 col-xs-4"><div class="popup__close__button"></div></div>
							</div>
						</div>
						<div class="popup__body">
							<div class="popup_teacher__top row">
                                <?php if( has_post_thumbnail() ) { ?>
								<div class="popup_teacher__img col col-md-5"><div><?php the_post_thumbnail('drivingschool_teacher2-thumb'); ?></div></div>
                                <?php } ?>
								<div class="popup_teacher__profile col col-md-7">
									<div class="popup_teacher__title"><?php echo get_the_title($postid); ?></div>
                                    <?php 
								       if(get_post_meta($postid, 'rating', true) != 'none') { 
									       $rating = get_post_meta($postid, 'rating', true);
								    ?>
									<div class="popup_teacher__raring">
                                        <?php if($rating >= 1) { ?>
										<svg class="popup_teacher__raring__icon"><use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_star"></use></svg>
                                        <?php } if($rating >= 2) { ?>
										<svg class="popup_teacher__raring__icon"><use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_star"></use></svg>
                                        <?php } if($rating >= 3) { ?>
										<svg class="popup_teacher__raring__icon"><use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_star"></use></svg>
                                        <?php } if($rating >= 4) { ?>
										<svg class="popup_teacher__raring__icon"><use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_star"></use></svg>
                                        <?php } if($rating >= 5) { ?>
										<svg class="popup_teacher__raring__icon"><use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_star"></use></svg>
                                        <?php } ?>
									</div>
                                    <?php } ?>
                                    <?php if(have_rows('cars',$postid)): ?>
									<div class="popup_teacher__desc">
                                    <?php 
									    $car = ""; while(have_rows('cars',$postid)) : the_row(); $car .= get_sub_field('car').', ';  endwhile; 
										$car = trim($car, ', ');
										echo esc_html($car);
									?>
                                    </div>
                                    <?php endif; ?>
                                     <?php if(have_rows('data',$postid)): ?>
									<div class="popup_teacher__data">
                                        <?php while(have_rows('data',$postid)) : the_row(); ?>
										<div class="popup_teacher__data__item">
											<span class="popup_teacher__data__term"><?php esc_html(the_sub_field('text1')); ?></span>
											<span class="popup_teacher__data__separ"></span>
											<span class="popup_teacher__data__value"><?php esc_html(the_sub_field('text2')); ?></span>
										</div>
                                        <?php endwhile; ?>
									</div>
                                    <?php endif; ?>
								</div>
							</div>
                            <form action="<?php bloginfo('url'); ?>/wp-content/plugins/drivingschool-plugin/sendmail.php" class="form" id="teachers_form" method="post">
							<div class="row">
								<div class="col-sm-6">
									<div class="form__row row">
										<div class="col-md-12">
											<div class="control-group control-group_fullwidth">
												<span class="control-remark control-group__item">
													<svg class="control-remark__icon"><use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_users"></use></svg>
												</span>
												<span class="inp">
													<span class="inp__box">
														<input class="inp__control mand" type="text" name="your-name" placeholder="<?php esc_html_e('Enter your name', 'drivingschool-plugin'); ?>">
													</span>
												</span>
											</div>
										</div>
									</div>
									<div class="form__row row">
										<div class="col-md-12">
											<div class="control-group control-group_fullwidth">
												<span class="control-remark control-group__item">
													<svg class="control-remark__icon"><use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_mail"></use></svg>
												</span>
												<span class="inp">
													<span class="inp__box">
														<input class="inp__control mand" type="email" name="email" placeholder="<?php esc_html_e('Enter your E-Mail', 'drivingschool-plugin'); ?>">
													</span>
												</span>
											</div>
										</div>
									</div>
									<div class="form__row row">
										<div class="col-md-12">
											<div class="control-group control-group_fullwidth">
												<span class="control-remark control-group__item">
													<svg class="control-remark__icon"><use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_phone"></use></svg>
												</span>
												<span class="inp">
													<span class="inp__box">
														<input class="inp__control mand" type="tel" name="phone" placeholder="<?php esc_html_e('Enter your Phone', 'drivingschool-plugin'); ?>">
													</span>
												</span>
											</div>
										</div>
									</div>
								</div>
								<div class="col-sm-6">
									<div class="form__row row">
										<div class="col-md-12">
											<textarea class="popup_teacher__taxtarea textarea textarea_fullwidth mand" placeholder="<?php esc_html_e('Message', 'drivingschool-plugin'); ?>" name="message"></textarea>
										</div>
									</div>
								</div>
							</div>
							<div class="form__row row">
								<div class="col-md-12">
									<button class="btn btn_fullwidth" type="submit">
										<span class="btn__text"><?php esc_html_e('send request', 'drivingschool-plugin'); ?></span>
									</button>
								</div>
							</div>
                            <input type="text" name="form_info">
                            <input type="hidden" name="nonce" class="nonce" value="<?php echo wp_create_nonce('teachers'); ?>">
                            <input name="mailt" type="hidden" value="<?php echo esc_html(get_post_meta($postid, 'e-mail', true)); ?>" />
                            <input name="typform" type="hidden" class="nonce" value="typ7">
                            <div class="results-ajax"> </div>
					    </form>
						</div>
					</div>
				</div>
			</div>
			<div class="popup__bg"></div>
		</div>
<?php
} 

function drivingschool_form_teachers_message($postid, $homeemail = '') {
?>
    <div class="popup popup_narrow popup_usual">
			<div class="popup__container container">
				<div class="row">
					<div class="popup__wrapper col col-md-4 col-sm-6">
						<div class="popup__head clearfix">
							<div class="row">
								<div class="popup__title col-sm-6 col-xs-8"><?php esc_html_e('send message', 'drivingschool-plugin'); ?></div>
								<div class="popup__close col-sm-6 col-xs-4"><div class="popup__close__button"></div></div>
							</div>
						</div>
						<div class="popup__body">
                        <form action="<?php bloginfo('url'); ?>/wp-content/plugins/drivingschool-plugin/sendmail.php" class="form" id="teachers_message" method="post">
							<div class="form__row row">
								<div class="col-md-12">
									<div class="control-group control-group_fullwidth">
										<span class="control-remark control-group__item">
											<svg class="control-remark__icon"><use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_users"></use></svg>
										</span>
										<span class="inp">
											<span class="inp__box">
												<input class="inp__control mand" type="text" name="your-name" placeholder="<?php esc_html_e('Enter your name', 'drivingschool-plugin'); ?>">
											</span>
										</span>
									</div>
								</div>
							</div>
							<div class="form__row row">
								<div class="col-md-12">
									<div class="control-group control-group_fullwidth">
										<span class="control-remark control-group__item">
											<svg class="control-remark__icon"><use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_mail"></use></svg>
										</span>
										<span class="inp">
											<span class="inp__box">
												<input class="inp__control mand" type="email" name="email" placeholder="<?php esc_html_e('Enter your E-Mail', 'drivingschool-plugin'); ?>">
											</span>
										</span>
									</div>
								</div>
							</div>
							<div class="form__row row">
								<div class="col-md-12">
									<div class="control-group control-group_fullwidth">
										<span class="control-remark control-group__item">
											<svg class="control-remark__icon"><use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_phone"></use></svg>
										</span>
										<span class="inp">
											<span class="inp__box">
												<input class="inp__control mand" type="tel" name="phone" placeholder="<?php esc_html_e('Enter your Phone', 'drivingschool-plugin'); ?>">
											</span>
										</span>
									</div>
								</div>
							</div>
							<div class="form__row row">
								<div class="col-md-12">
									<textarea class="textarea textarea_fullwidth mand" placeholder="<?php esc_html_e('Message', 'drivingschool-plugin'); ?>" name="message"></textarea>
								</div>
							</div>
							<div class="form__row row">
								<div class="col-md-12">
									<button class="btn btn_fullwidth" type="submit">
										<span class="btn__text"><?php esc_html_e('send message', 'drivingschool-plugin'); ?></span>
									</button>
								</div>
							</div>
                            <input type="text" name="form_info">
                            <input type="hidden" name="nonce" class="nonce" value="<?php echo wp_create_nonce('teachers_message'); ?>">
                            <input name="mailt" type="hidden" value="<?php if($homeemail != '') { echo $homeemail; } else { echo esc_html(get_post_meta($postid, 'e-mail', true)); } ?>" />
                            <input name="typform" type="hidden" class="nonce" value="typ8">
                            <div class="results-ajax"> </div>
                        </form>
						</div>
					</div>
				</div>
			</div>
			<div class="popup__bg"></div>
		</div>
<?php
} 

function drivingschool_form_course2($email = '',$curse = '', $duration = '', $textt = '', $picture = '', $ico = '') {
?>
		<div class="popup popup_wide popup_protect">
			<div class="popup__container container">
				<div class="row">
					<div class="popup__wrapper col col-md-7 col-sm-9">
						<div class="popup__head clearfix">
							<div class="row">
								<div class="popup__title col-sm-6 col-xs-8"><?php esc_html_e('send message', 'drivingschool-plugin'); ?></div>
								<div class="popup__close col-sm-6 col-xs-4"><div class="popup__close__button"></div></div>
							</div>
						</div>
						<div class="popup__body">
							<div class="popup_protect__top row">
                                <?php if($picture != '') { ?>
								<div class="popup_protect__img col col-lg-4 col-md-5"><div><img src="<?php echo $picture; ?>" alt="<?php esc_html_e('Picture', 'drivingschool-plugin'); ?>"></div></div>
                                <?php } ?>
								<div class="popup_protect__data col-lg-8 col-md-7">
									<div class="popup_protect__def row">
                                        <?php if($ico != '') { ?>
										<div class="popup_protect__def__img col">
											<img src="<?php echo $ico; ?>" alt="<?php esc_html_e('Icons', 'drivingschool-plugin'); ?>">
										</div>
                                        <?php } ?>
										<div class="popup_protect__def__text col">
											<div class="popup_protect__def__title"><?php echo $curse; ?></div>
											<div class="popup_protect__def__days"><?php echo $duration; ?></div>
										</div>
									</div>
                                    <?php echo $textt; ?>
								</div>
							</div>
                            <form action="<?php bloginfo('url'); ?>/wp-content/plugins/drivingschool-plugin/sendmail.php" class="form" id="course_techer" method="post">
							<div class="row">
								<div class="col-sm-6">
									<div class="form__row row">
										<div class="col-md-12">
											<div class="control-group control-group_fullwidth">
												<span class="control-remark control-group__item">
													<svg class="control-remark__icon"><use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_users"></use></svg>
												</span>
												<span class="inp">
													<span class="inp__box">
														<input class="inp__control mand" type="text" name="your-name" placeholder="<?php esc_html_e('Enter your name', 'drivingschool-plugin'); ?>">
													</span>
												</span>
											</div>
										</div>
									</div>
									<div class="form__row row">
										<div class="col-md-12">
											<div class="control-group control-group_fullwidth">
												<span class="control-remark control-group__item">
													<svg class="control-remark__icon"><use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_mail"></use></svg>
												</span>
												<span class="inp">
													<span class="inp__box">
														<input class="inp__control mand" type="email" name="email" placeholder="<?php esc_html_e('Enter your E-Mail', 'drivingschool-plugin'); ?>">
													</span>
												</span>
											</div>
										</div>
									</div>
									<div class="form__row row">
										<div class="col-md-12">
											<div class="control-group control-group_fullwidth">
												<span class="control-remark control-group__item">
													<svg class="control-remark__icon"><use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="<?php echo get_template_directory_uri(); ?>/assets/images/icon.svg#icon_phone"></use></svg>
												</span>
												<span class="inp">
													<span class="inp__box">
														<input class="inp__control mand" type="tel" name="phone" placeholder="<?php esc_html_e('Enter your Phone', 'drivingschool-plugin'); ?>">
													</span>
												</span>
											</div>
										</div>
									</div>
								</div>
								<div class="popup_protect__radios col-sm-6">
									<div class="popup_protect__radio radio">
										<input type="radio" name="radio" id="radio-1" value="<?php esc_html_e('Automat', 'drivingschool-plugin'); ?>">
										<label for="radio-1" class="radio__label"></label>
										<p class="radio__text"><?php esc_html_e('Automat', 'drivingschool-plugin'); ?></p>
									</div>
									<div class="popup_protect__radio radio">
										<input type="radio" checked name="radio" id="radio-2" value="<?php esc_html_e('Mechanic', 'drivingschool-plugin'); ?>">
										<label for="radio-2" class="radio__label"></label>
										<p class="radio__text"><?php esc_html_e('Mechanic', 'drivingschool-plugin'); ?></p>
									</div>
								</div>
							</div>
							
							<div class="form__row row">
								<div class="col-md-12">
									<button class="btn btn_fullwidth" type="submit">
										<span class="btn__text"><?php esc_html_e('send request', 'drivingschool-plugin'); ?></span>
									</button>
								</div>
							</div>
                            <input type="text" name="form_info">
                            <input type="hidden" name="nonce" class="nonce" value="<?php echo wp_create_nonce('course_techer'); ?>">
                            <input name="mailt" type="hidden" value="<?php echo $email; ?>" />
                            <input name="course" class="course-input" type="hidden" value="<?php echo $curse; ?>">
                            <input name="typform" type="hidden" class="nonce" value="typ10">
                            <div class="results-ajax"> </div>
                            </form>
						</div>
					</div>
				</div>
			</div>
			<div class="popup__bg"></div>
		</div>
<?php
} 