<?php
if ( !defined('ABSPATH') ) {
	require_once( dirname( __FILE__ ) . '/../../../wp-load.php' );
}
function drivingschool_demo_data_theme_page(){
	add_theme_page(
		esc_html__('Import demo data','drivingschool-plugin'),
		esc_html__('Import demo data','drivingschool-plugin'),
		'edit_theme_options',
		'drivingschool-demo-data',
		'drivingschool_demo_data_importer'
	);
}
add_action('admin_menu', 'drivingschool_demo_data_theme_page');

function drivingschool_demo_data_importer(){

	$current_user       = wp_get_current_user();
	$current_user_email = $current_user->user_email;

	$current_user_meta         = get_user_meta( get_current_user_id() );
	$current_user_session      = $current_user_meta['session_tokens'][0];
	$current_user_login        = $current_user->user_login;
	$current_user_pass         = $current_user->user_pass;
	$current_user_nicename     = $current_user->user_nicename;
	$current_user_display_name = $current_user->display_name;

	global $_POST;
	if (isset($_POST['wfm_hidenn']) && $_POST['wfm_hidenn'] == 'wmf_hiden') {
		global $wpdb, $wp_filesystem;
		if (empty($wp_filesystem)) {
			require_once(ABSPATH . '/wp-admin/includes/file.php');
			WP_Filesystem();
		}
		$tmp_files = download_url('http://drivingschool.wpmix.net/uploads.zip');
		if (is_wp_error($tmp_files)) {
			$tmp_files->get_error_messages();
		} else {
			$destination = wp_upload_dir();
			unzip_file($tmp_files, $destination['basedir']);
		}
		global $wpdb;
		$wpdb->hide_errors();
		$filename = plugin_dir_path(__FILE__) . 'demo/drivingschool_wp.sql';
		($fp = fopen($filename, 'r'));
		$wpdb->hide_errors();
		$query = '';
		while ($line = fgets($fp)) {
			if (substr($line, 0, 2) == '--' OR trim($line) == '') {
				continue;
			}

			$query .= mb_convert_encoding($line, "UTF-8");

			$query = str_replace(
				array(
					'http_drivingschool_siteurl',
					'wp_commentmeta',
					'wp_comments',
					'wp_links',
					'wp_options',
					'wp_postmeta',
					'wp_posts',
					'wp_terms',
					'wp_termmeta',
					'wp_term_relationships',
					'wp_term_taxonomy',
					'wp_usermeta',
					'wp_users',
					'wp_user-settings-time',
					'wp_capabilities',
					'wp_user_level',
					'wp_user-settings',
					'wp_dashboard_quick_press_last_post_id',
					'wp_user_roles',
					'drivingschool_current_user_session_tokens',
					'drivingschool_user_login',
					'drivingschool_user_pass',
					'drivingschool_user_nicename',
					'drivingschool_user_display_name',
					'drivingschool_user_email',
					'admin@mail.com',
				),
				array(
					get_home_url(''),
					$wpdb->prefix . 'commentmeta',
					$wpdb->prefix . 'comments',
					$wpdb->prefix . 'links',
					$wpdb->prefix . 'options',
					$wpdb->prefix . 'postmeta',
					$wpdb->prefix . 'posts',
					$wpdb->prefix . 'terms',
					$wpdb->prefix . 'termmeta',
					$wpdb->prefix . 'term_relationships',
					$wpdb->prefix . 'term_taxonomy',
					$wpdb->prefix . 'usermeta',
					$wpdb->prefix . 'users',
					$wpdb->prefix . 'user-settings-time',
					$wpdb->prefix . 'capabilities',
					$wpdb->prefix . 'user_level',
					$wpdb->prefix . 'user-settings',
					$wpdb->prefix . 'dashboard_quick_press_last_post_id',
					$wpdb->prefix . 'user_roles',
					$current_user_session,
					$current_user_login,
					$current_user_pass,
					$current_user_nicename,
					$current_user_display_name,
					$current_user_email,
					$current_user_email,
				)
			, $query);

			if (substr(trim($query), -1) == ';') {
				$sqlA = explode("--#######--", $query);
				foreach($sqlA as $sql_item){
					$wpdb->query($sql_item);
				}
				$query = '';
			}
		}
		$foo = 2;
		$locations = array();
		$locations['primary'] = $foo;
		set_theme_mod('nav_menu_locations', $locations);
		
		set_theme_mod ('drivingschool_logo_h', get_home_url('').'/wp-content/uploads/2017/05/logo.png' );
		set_theme_mod ('drivingschool_address','Matvey street, russia' );
		set_theme_mod ('drivingschool_phone', '+ 90 888 777 5544' );
		set_theme_mod ('drivingschool_call_me', 'yes' );
		set_theme_mod ('drivingschool_map_key', 'AIzaSyBRrnhl1mCfuWpxL4Ame0cyS8fcV7xoyLk' );
		set_theme_mod ('drivingschool_pagination', 'yes' );
		set_theme_mod ('drivingschool_upper_block_h', 'yes' );
		set_theme_mod ('drivingschool_text_h', 'Lessons From just $20 Per Hour or 5 Lessons for $120 or 10 Hours For $180' );
		set_theme_mod ('drivingschool_soc_url1', '#' );
		set_theme_mod ('drivingschool_soc_url2', '#' );
		set_theme_mod ('drivingschool_soc_url3', '#' );
		set_theme_mod ('drivingschool_soc_url4', '#' );
		set_theme_mod ('drivingschool_header_f1', 'About' );
		set_theme_mod ('drivingschool_text_f', 'have been serving NYC with its 8 branches and completed 5k+ students in last 10 years. We have a team of experienced and certified trainers who will help you from the start to end of a driving lesson.' );
		set_theme_mod ('drivingschool_copyright', '<a href="http://standard-it.group">Web development standard-it.group</a>' );
		set_theme_mod ('drivingschool_lower_block', 'yes' );
		set_theme_mod ('drivingschool_header_f2', 'SERTIFICATE' );
		set_theme_mod ('drivingschool_picture1', get_home_url('').'/wp-content/uploads/2017/04/cert1.jpg' );
		set_theme_mod ('drivingschool_picture2', get_home_url('').'/wp-content/uploads/2017/04/cert2.jpg' );
		set_theme_mod ('drivingschool_picture3', get_home_url('').'/wp-content/uploads/2017/04/cert1.jpg' );
		set_theme_mod ('drivingschool_picture4', get_home_url('').'/wp-content/uploads/2017/04/cert2.jpg' );
		set_theme_mod ('drivingschool_picture5', get_home_url('').'/wp-content/uploads/2017/04/cert1.jpg' );
		set_theme_mod ('drivingschool_picture6', get_home_url('').'/wp-content/uploads/2017/04/cert2.jpg' );
		set_theme_mod ('drivingschool_url_subs', '#' );
		set_theme_mod ('drivingschool_cat_subs', 'yes' );
		set_theme_mod ('drivingschool_home_subs', 'no' );
		set_theme_mod ('drivingschool_post', '4' );
		set_theme_mod ('drivingschool_post_subs', 'yes' );
		set_theme_mod ('drivingschool_title_subs', 'GET MORE STUFF' );
		set_theme_mod ('drivingschool_text_subs', 'Subscribe to our mailing list and get interesting stuff and updates to your email inbox.' );
		set_theme_mod ('drivingschool_background_subs', get_home_url('').'/wp-content/uploads/2017/04/bg-stuff.jpg' );
		set_theme_mod ('drivingschool_id_page_teachers', '255' );
		update_option('drivingschool_demo_installed', 1 );
	
} ?>

<div class="wrap wrap-import-demo">
	<h1 class="wp-heading-inline"><?php esc_html_e('DrivingSchool Import Demo Data','drivingschool-plugin');?></h1>
	
	<?php
		if (isset($_POST['installed'])){
			if($_POST['installed'] == 'true'){?>
				<div class="notice updated is-dismissible">
					<p><?php esc_html_e('Import was successful. ReActivate all plugins!', 'drivingschool-plugin') ?></p>
					<button type="button" class="notice-dismiss"></button>
				</div>
			<?php }
		}
	?>
	
	<div class="theme-browser rendered">
		<div class="themes wp-clearfix single-theme">
			<div class="theme-overlay active">
				<div class="theme-wrap wp-clearfix" role="document">
				
					<div class="theme-about wp-clearfix">
						<div class="theme-screenshots">
							<div class="screenshot">
								<img src="http://drivingschool.wpmix.net/wp-content/themes/drivingschool/screenshot.png" alt="">
							</div>
						</div>

						<div class="theme-info">
							<h2 class="theme-name">DrivingSchool</h2>
							<p class="theme-description"><strong><?php esc_html_e('Import Demo Data', 'drivingschool-plugin'); ?></strong><br></p>
							<p class="theme-tags"><span><?php esc_html_e('Recommendation:', 'drivingschool-plugin'); ?></span></p>
							<ul>
								<li><?php esc_html_e('Press the button Import Demo Data for import.', 'drivingschool-plugin'); ?></li>
								<li class="color-red"><?php esc_html_e('All exist data will be deleted!', 'drivingschool-plugin') ?></li>
							</ul>
							<?php 
								$cur_user_id = get_current_user_id();
								if ( $cur_user_id != 1 ) {
								?>
								<ul>
									<li><?php esc_html_e('Your user id is ' . $cur_user_id . '. To correctly install, your user id must be 1.', 'drivingschool-plugin'); ?></li>
									<li class="color-red"><?php esc_html_e('Because of this after demo import you can have the following most pupular problem: "Sorry, you are not allowed to access this page."', 'drivingschool-plugin'); ?></li>
								</ul>
							<?php } ?>
							
							<?php
								$max_upload_size = wp_max_upload_size();
								$max_execution_time = ini_get( 'max_execution_time');
								$permited_max_upload_size = 10;
								$permited_max_execution_time = 31457280;
							?>
							<?php if( $max_execution_time < $permited_max_upload_size || $max_upload_size < $permited_max_execution_time){?>
							<p class="theme-tags"><span><?php esc_html_e('Demo import may have problems because:', 'drivingschool-plugin'); ?></span></p>
								
							<ol>
								<?php if($max_upload_size < $permited_max_execution_time){?>
								<li class="color-red">
									<?php esc_html_e( 'Your Maximum Upload File Size:','drivingschool' );?> <code><?php echo esc_html( size_format( $max_upload_size ) );?></code>
									<br>
									<?php esc_html_e( 'Recommended:','drivingschool' );?> <code>40 MB</code>
								</li>
								<?php } ?>
								<?php if($max_execution_time < $permited_max_upload_size){?>
								<li class="color-red">
									<?php esc_html_e( 'Your Maximum Execution Time:','drivingschool' );?> <code><?php echo esc_html( $max_execution_time );?>sec</code>
									<br>
									<?php esc_html_e( 'Recommended:','drivingschool' );?> <code>300sec</code>
								</li>
								<?php } ?>
							</ul>
							<a href="http://www.wpbeginner.com/wp-tutorials/how-to-increase-the-maximum-file-upload-size-in-wordpress/" class="button button-primary button-small" target="_blank"><?php esc_html_e('How To Fix?','drivingschool-plugin');?></a>
						<?php } ?>
								
						</div>
					</div>

					<div class="theme-actions">
					
						<form action="<?php echo admin_url( 'themes.php?page=drivingschool-demo-data');?>" method="post" class="form-load-demo-data">
							<input type="hidden" name="wfm_hidenn" value="wmf_hiden">
							<input type="hidden" name="installed" value="true">
						</form>
							<span class="spinner"></span>
							<a href="" class="button button-primary load-demo-data">
								<?php if(get_option('drivingschool_demo_installed') != 1){?>
									<?php esc_html_e('Import Demo Data','drivingschool-plugin');?>
								<?php } else { ?>
									<?php esc_html_e('ReImport Demo Data','drivingschool-plugin');?>
								<?php } ?>
							</a>
							<a class="button" href="//drivingschool.wpmix.net/" target="_blank"><?php esc_html_e('Preview','drivingschool-plugin');?></a>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<?php
}