<?php

require_once('../../../wp-load.php');

/**
 * If active captcha
 */
if ( get_theme_mod( 'drivingschool_form_captcha' ) ) {
    
    if ( ! isset( $_POST['recaptcha_response'] ) ) {
        echo '<span class="err">' . esc_html__( 'You are a robot or something went wrong.', 'drivingschool-plugin' ) . '</span>';
        return;
    } else {
        
        $recaptcha_verify   = 'https://www.google.com/recaptcha/api/siteverify';
        $recaptcha_args     = array(
            'secret' => get_theme_mod( 'drivingschool_captcha_secret_key' ),
            'response' => $_POST['recaptcha_response'],
        );
       
        $recaptcha_url      = add_query_arg( $recaptcha_args, $recaptcha_verify );
        $recaptcha_response = file_get_contents( $recaptcha_url );
        $recaptcha          = json_decode( $recaptcha_response );
    

        if ( $recaptcha->success == true && $recaptcha->score >= 0.5 && $recaptcha->action == 'contact') {
           
        } else {
            echo '<span class="err">' . esc_html__( 'Something went wrong.', 'drivingschool-plugin' ) . '<br>' . esc_html__( 'Please try again later.', 'drivingschool-plugin' ) . '</span>';
            return;
        }

    }
}

$admin_email = get_theme_mod( 'drivingschool_form_email', get_bloginfo( 'admin_email' ) );

$to = $admin_email;

$urlparts      = parse_url( home_url() );
$domain        = $urlparts['host'];
$noreplay_mail = 'no_replay@' . $domain;

function set_html_content_type() {
	return 'text/html';
}

add_filter( 'wp_mail_content_type', 'set_html_content_type' );

$nonce = htmlspecialchars($_POST['nonce']);

if($_POST['typform'] == 'typ1') {
	if( !wp_verify_nonce( $nonce, 'call_me') ) { die(); }
    
    if ( isset( $_POST['form_info'] ) && ! empty( $_POST['form_info'] ) ) {
        die();
    }
    
	if ( empty($_POST['your-name']) or empty($_POST['email']) or empty($_POST['phone']) ) { 
		echo "<span class=\"err\">".esc_html__("You did not fill all required fields!","drivingschool-plugin")."</span>";
    } else {
        $fname = htmlspecialchars($_POST['your-name']);
	    $fmail = htmlspecialchars($_POST['email']);
        $fphone = htmlspecialchars($_POST['phone']);

        if (!preg_match("|^([a-z0-9_\.\-]{1,20})@([a-z0-9\.\-]{1,20})\.([a-z]{2,4})|is",$fmail)) {
		    echo "<span class=\"err\">".esc_html__("Invalid E-mail!","drivingschool-plugin")."</span>";
        } else {
					 
			$message = esc_html__('Your Name','drivingschool-plugin') . ': ' . $fname . ' <br /><br />
						' . esc_html__('Email','drivingschool-plugin') . ': ' . $fmail . ' <br /><br />
						' . esc_html__('Phone','drivingschool-plugin').': ' . $fphone . ' ';
			
			$subject  = esc_html__('Call me -', 'drivingschool-plugin') . ' \'' . get_bloginfo('name') . '\'';
			
			$headers[] = 'From: '.$fname.' <' . $noreplay_mail . '>';
			$headers[] = 'content-type: text/html';
			$headers[] = 'Cc: '.get_bloginfo("name").' <' . $noreplay_mail . '>';
			$headers[] = 'Cc: ' . $noreplay_mail;		 
			
			$prov = wp_mail( $to, $subject, $message, $headers );

            if ($prov) { 
                 echo "<span class=\"err0\">".esc_html__("Message sent!","drivingschool-plugin")."</span>";
            } else {
                 echo "<span class=\"err\">".esc_html__("Failure on the server!","drivingschool-plugin")."</span>";
            } 
        }
    }
}


if($_POST['typform'] == 'typ2') {
	if( !wp_verify_nonce( $nonce, 'contacts') ) { die(); }
    
    if ( isset( $_POST['form_info'] ) && ! empty( $_POST['form_info'] ) ) {
        die();
    }
    
	if ( empty($_POST['your-name']) or empty($_POST['email']) or empty($_POST['message']) ) { 
		echo "<span class=\"err\">".esc_html__("You did not fill all required fields!","drivingschool-plugin")."</span>";
    } else {
        $fname = htmlspecialchars($_POST['your-name']);
	    $fmail = htmlspecialchars($_POST['email']);
        $fmessage = htmlspecialchars($_POST['message']);
        $admin_email = get_bloginfo('admin_email');
        if (!preg_match("|^([a-z0-9_\.\-]{1,20})@([a-z0-9\.\-]{1,20})\.([a-z]{2,4})|is",$fmail)) {
		    echo "<span class=\"err\">".esc_html__("Invalid E-mail!","drivingschool-plugin")."</span>";
        } else {
            $message = esc_html__("Your Name","drivingschool-plugin").": ".$fname." <br /><br />
                     ".esc_html__("Email","drivingschool-plugin").": ".$fmail." <br /><br />
                     ".esc_html__("Message","drivingschool-plugin").":<br />".$fmessage."<br />";
					 
			$subject = esc_html__("Message -","drivingschool-plugin")." '".get_bloginfo("name")."'";
			
			$headers[] = 'From: '.$fname.' <'.$noreplay_mail.'>';
			$headers[] = 'content-type: text/html';
			$headers[] = 'Cc: '.get_bloginfo("name").' <' . $noreplay_mail . '>';
			$headers[] = 'Cc: ' . $noreplay_mail;	 
			
			$prov = wp_mail( $to, $subject, $message, $headers );
			
            if ($prov) { 
                 echo "<span class=\"err0\">".esc_html__("Message sent!","drivingschool-plugin")."</span>";
            } else {
                 echo "<span class=\"err\">".esc_html__("Failure on the server!","drivingschool-plugin")."</span>";
            } 
        }
    }
}


if($_POST['typform'] == 'typ3') {
	if( !wp_verify_nonce( $nonce, 'question') ) { die(); }
    
    if ( isset( $_POST['form_info'] ) && ! empty( $_POST['form_info'] ) ) {
        die();
    }
    
	if ( empty($_POST['your-name']) or empty($_POST['email']) or empty($_POST['question']) ) { 
		echo "<span class=\"err\">".esc_html__("You did not fill all required fields!","drivingschool-plugin")."</span>";
    } else {
        $fname = htmlspecialchars($_POST['your-name']);
	    $fmail = htmlspecialchars($_POST['email']);
        $fquestion = htmlspecialchars($_POST['question']);
        $admin_email = get_bloginfo('admin_email');
        if (!preg_match("|^([a-z0-9_\.\-]{1,20})@([a-z0-9\.\-]{1,20})\.([a-z]{2,4})|is",$fmail)) {
		    echo "<span class=\"err\">".esc_html__("Invalid E-mail!","drivingschool-plugin")."</span>";
        } else {
            $message = esc_html__("Your Name","drivingschool-plugin").": ".$fname." <br /><br />
                     ".esc_html__("Email","drivingschool-plugin").": ".$fmail." <br /><br />
                     ".esc_html__("Question","drivingschool-plugin").":<br />".$fquestion."<br />";
					 
			$subject = esc_html__("Question -","drivingschool-plugin")." '".get_bloginfo("name")."'";
			
			$headers[] = 'From: '.$fname.' <'.$noreplay_mail.'>';
			$headers[] = 'content-type: text/html';
			$headers[] = 'Cc: '.get_bloginfo("name").' <' . $noreplay_mail . '>';
			$headers[] = 'Cc: ' . $noreplay_mail;	 
			
			$prov = wp_mail( $to, $subject, $message, $headers );
			
            if ($prov) { 
                 echo "<span class=\"err0\">".esc_html__("Message sent!","drivingschool-plugin")."</span>";
            } else {
                 echo "<span class=\"err\">".esc_html__("Failure on the server!","drivingschool-plugin")."</span>";
            } 
        }
    }
}


if($_POST['typform'] == 'typ4') {
	if( !wp_verify_nonce( $nonce, 'plan') ) { die(); }
    
    if ( isset( $_POST['form_info'] ) && ! empty( $_POST['form_info'] ) ) {
        die();
    }
    
	if ( empty($_POST['your-name']) or empty($_POST['email']) or empty($_POST['phone']) ) { 
		echo "<span class=\"err\">".esc_html__("You did not fill all required fields!","drivingschool-plugin")."</span>";
    } else {
        $fname = htmlspecialchars($_POST['your-name']);
	    $fmail = htmlspecialchars($_POST['email']);
        $fphone = htmlspecialchars($_POST['phone']);
		$nameplan= htmlspecialchars($_POST['nameplan']);
        $admin_email = get_bloginfo('admin_email');
        if (!preg_match("|^([a-z0-9_\.\-]{1,20})@([a-z0-9\.\-]{1,20})\.([a-z]{2,4})|is",$fmail)) {
		    echo "<span class=\"err\">".esc_html__("Invalid E-mail!","drivingschool-plugin")."</span>";
        } else {
            $message = esc_html__("Your Name","drivingschool-plugin").": ".$fname." <br /><br />
                     ".esc_html__("Email","drivingschool-plugin").": ".$fmail." <br /><br />
                     ".esc_html__("Phone","drivingschool-plugin").": ".$fphone." <br /><br />
					 ".esc_html__("Tariff plan","drivingschool-plugin").": ".$nameplan." <br /><br />";
			$subject = esc_html__("Tariff plan -","drivingschool-plugin")." '".get_bloginfo("name")."'";
			
			$headers[] = 'From: '.$fname.' <'.$noreplay_mail.'>';
			$headers[] = 'content-type: text/html';
			$headers[] = 'Cc: '.get_bloginfo("name").' <' . $noreplay_mail . '>';
			$headers[] = 'Cc: ' . $noreplay_mail;	 
			
			$prov = wp_mail( $to, $subject, $message, $headers );
			
            if ($prov) { 
                 echo "<span class=\"err0\">".esc_html__("Message sent!","drivingschool-plugin")."</span>";
            } else {
                 echo "<span class=\"err\">".esc_html__("Failure on the server!","drivingschool-plugin")."</span>";
            } 
        }
    }
}

if($_POST['typform'] == 'typ5') {
	if( !wp_verify_nonce( $nonce, 'course') ) { die(); }
    
    if ( isset( $_POST['form_info'] ) && ! empty( $_POST['form_info'] ) ) {
        die();
    }
    
	if ( empty($_POST['your-name']) or empty($_POST['email']) or empty($_POST['phone']) ) { 
		echo "<span class=\"err\">".esc_html__("You did not fill all required fields!","drivingschool-plugin")."</span>";
    } else {
        $fname = htmlspecialchars($_POST['your-name']);
	    $fmail = htmlspecialchars($_POST['email']);
        $fphone = htmlspecialchars($_POST['phone']);
		$radio = htmlspecialchars($_POST['radio']);
		$course= htmlspecialchars($_POST['course']);
        $admin_email = get_bloginfo('admin_email');
        if (!preg_match("|^([a-z0-9_\.\-]{1,20})@([a-z0-9\.\-]{1,20})\.([a-z]{2,4})|is",$fmail)) {
		    echo "<span class=\"err\">".esc_html__("Invalid E-mail!","drivingschool-plugin")."</span>";
        } else {
            $message = esc_html__("Your Name","drivingschool-plugin").": ".$fname." <br /><br />
                     ".esc_html__("Email","drivingschool-plugin").": ".$fmail." <br /><br />
                     ".esc_html__("Phone","drivingschool-plugin").": ".$fphone." <br /><br />
					 ".esc_html__("Transmission","drivingschool-plugin").": ".$radio." <br /><br />
					 ".esc_html__("Course","drivingschool-plugin").": ".$course." <br /><br />";
					 
			$subject = esc_html__("Course -","drivingschool-plugin")." '".get_bloginfo("name")."'";
			
			$headers[] = 'From: '.$fname.' <'.$noreplay_mail.'>';
			$headers[] = 'content-type: text/html';
			$headers[] = 'Cc: '.get_bloginfo("name").' <' . noreplay_mail . '>';
			$headers[] = 'Cc: ' . $noreplay_mail;	 
			
			$prov = wp_mail( $to, $subject, $message, $headers );
			
            if ($prov) { 
                 echo "<span class=\"err0\">".esc_html__("Message sent!","drivingschool-plugin")."</span>";
            } else {
                 echo "<span class=\"err\">".esc_html__("Failure on the server!","drivingschool-plugin")."</span>";
            } 
        }
    }
}


if($_POST['typform'] == 'typ6') {
	if( !wp_verify_nonce( $nonce, 'review') ) { die(); }
    
    if ( isset( $_POST['form_info'] ) && ! empty( $_POST['form_info'] ) ) {
        die();
    }
    
	if ( empty($_POST['your-name']) or empty($_POST['email']) or empty($_POST['message']) ) { 
		echo "<span class=\"err\">".esc_html__("You did not fill all required fields!","drivingschool-plugin")."</span>";
    } else {
		$rating = 0;
		$ava = 0;
        $fname = htmlspecialchars($_POST['your-name']);
	    $fmail = htmlspecialchars($_POST['email']);
        $fmessage = htmlspecialchars($_POST['message']);
		if(isset($_POST['rating'])) { $rating = htmlspecialchars($_POST['rating']); }
        $admin_email = get_bloginfo('admin_email');
        if (!preg_match("|^([a-z0-9_\.\-]{1,20})@([a-z0-9\.\-]{1,20})\.([a-z]{2,4})|is",$fmail)) {
		    echo "<span class=\"err\">".esc_html__("Invalid E-mail!","drivingschool-plugin")."</span>";
        } else {
			$types = array('image/gif', 'image/png', 'image/jpeg');
			$size = 1024000;
			if(isset($_FILES['ava']) and in_array($_FILES['ava']['type'], $types) and $_FILES['ava']['size'] < $size and wp_verify_nonce( $_POST['my_image_upload_nonce'], 'ava' )) {
				require_once( ABSPATH . 'wp-admin/includes/image.php' );
			    require_once( ABSPATH . 'wp-admin/includes/file.php' );
			    require_once( ABSPATH . 'wp-admin/includes/media.php' );
			    $ava = media_handle_upload( 'ava', 0 );
			} elseif(isset($_FILES['ava'])) {
			    echo "<span class=\"err\">".esc_html__("Allowed avatar format JPG, PNG, GIF and maximum size 1 Mb.","drivingschool-plugin")."</span>";
				die();
		    }
			$mod = 'yes';
			$p_type = 'pending';
			if(get_theme_mod('drivingschool_moderate_reviews') == 'no') { $mod = 'no'; $p_type = 'publish'; }
			$post_data = array(
			  'post_title'    => wp_strip_all_tags( $fname),
			  'post_status'   => $p_type,
 			  'post_author'   => 1,
			  'post_type'     => 'review',
			  'meta_input'    => array( 'feedback'=>$fmessage,'email'=>$fmail,'rating'=>$rating,'avatar'=>$ava )
			);
			$post_id = wp_insert_post( $post_data );
            if ($post_id) { 
			     if($mod != 'no') {
                     echo "<span class=\"err0\">".esc_html__("Review added and pending review.","drivingschool-plugin")."</span>";
				 } else {
					 echo "<span class=\"err0\">".esc_html__("Review added.","drivingschool-plugin")."</span>";
				 }
            } else {
                 echo "<span class=\"err\">".esc_html__("Failure on the server!","drivingschool-plugin")."</span>";
            } 
        }
    }
}


if($_POST['typform'] == 'typ7') {
	if( !wp_verify_nonce( $nonce, 'teachers') ) { die(); }
    
    if ( isset( $_POST['form_info'] ) && ! empty( $_POST['form_info'] ) ) {
        die();
    }
    
	if ( empty($_POST['your-name']) or empty($_POST['email']) or empty($_POST['phone']) or empty($_POST['message']) or empty($_POST['mailt']) ) { 
		echo "<span class=\"err\">".esc_html__("You did not fill all required fields!","drivingschool-plugin")."</span>";
    } else {
        $fname = htmlspecialchars($_POST['your-name']);
	    $fmail = htmlspecialchars($_POST['email']);
        $fphone = htmlspecialchars($_POST['phone']);
		$message = htmlspecialchars($_POST['message']);
		$mailt = htmlspecialchars($_POST['mailt']);
        if (!preg_match("|^([a-z0-9_\.\-]{1,20})@([a-z0-9\.\-]{1,20})\.([a-z]{2,4})|is",$fmail)) {
		    echo "<span class=\"err\">".esc_html__("Invalid E-mail!","drivingschool-plugin")."</span>";
        } else {
            $message = esc_html__("Your Name","drivingschool-plugin").": ".$fname." <br /><br />
                     ".esc_html__("Email","drivingschool-plugin").": ".$fmail." <br /><br />
                     ".esc_html__("Phone","drivingschool-plugin").": ".$fphone." <br /><br />
					 ".esc_html__("Message","drivingschool-plugin").":<br /><br />".$message." >";
			$subject = esc_html__("Order from the site -","drivingschool-plugin")." '".get_bloginfo("name")."'";
			
			$headers[] = 'From: '.$fname.' <'.$noreplay_mail.'>';
			$headers[] = 'content-type: text/html';
			$headers[] = 'Cc: '.get_bloginfo("name").' <' . $noreplay_mail . '>';
			$headers[] = 'Cc: ' . $noreplay_mail;	 
			
			$prov = wp_mail( $to, $subject, $message, $headers );
			
            if ($prov) { 
                 echo "<span class=\"err0\">".esc_html__("Message sent!","drivingschool-plugin")."</span>";
            } else {
                 echo "<span class=\"err\">".esc_html__("Failure on the server!","drivingschool-plugin")."</span>";
            } 
        }
    }
}


if($_POST['typform'] == 'typ8') {
	if( !wp_verify_nonce( $nonce, 'teachers_message') ) { die(); }
    
    if ( isset( $_POST['form_info'] ) && ! empty( $_POST['form_info'] ) ) {
        die();
    }
    
	if ( empty($_POST['your-name']) or empty($_POST['email']) or empty($_POST['phone']) or empty($_POST['message']) or empty($_POST['mailt']) ) { 
		echo "<span class=\"err\">".esc_html__("You did not fill all required fields!","drivingschool-plugin")."</span>";
    } else {
        $fname = htmlspecialchars($_POST['your-name']);
	    $fmail = htmlspecialchars($_POST['email']);
        $fphone = htmlspecialchars($_POST['phone']);
		$message = htmlspecialchars($_POST['message']);
		$mailt = htmlspecialchars($_POST['mailt']);
        if (!preg_match("|^([a-z0-9_\.\-]{1,20})@([a-z0-9\.\-]{1,20})\.([a-z]{2,4})|is",$fmail)) {
		    echo "<span class=\"err\">".esc_html__("Invalid E-mail!","drivingschool-plugin")."</span>";
        } else {
            $message = esc_html__("Your Name","drivingschool-plugin").": ".$fname." <br /><br />
                     ".esc_html__("Email","drivingschool-plugin").": ".$fmail." <br /><br />
                     ".esc_html__("Phone","drivingschool-plugin").": ".$fphone." <br /><br />
					 ".esc_html__("Message","drivingschool-plugin").":<br /><br />".$message." >";
			$subject = esc_html__("Message from the site -","drivingschool-plugin")." '".get_bloginfo("name")."'";
			
			$headers[] = 'From: '.$fname.' <'.$noreplay_mail.'>';
			$headers[] = 'content-type: text/html';
			$headers[] = 'Cc: '.get_bloginfo("name").' <' . $noreplay_mail . '>';
			$headers[] = 'Cc: ' . $noreplay_mail; 
			
			$prov = wp_mail( $to, $subject, $message, $headers );
			
            if ($prov) { 
                 echo "<span class=\"err0\">".esc_html__("Message sent!","drivingschool-plugin")."</span>";
            } else {
                 echo "<span class=\"err\">".esc_html__("Failure on the server!","drivingschool-plugin")."</span>";
            } 
        }
    }
}


if($_POST['typform'] == 'typ9') {
	if( !wp_verify_nonce( $nonce, 'slader1') ) { die(); }
    
    if ( isset( $_POST['form_info'] ) && ! empty( $_POST['form_info'] ) ) {
        die();
    }

	if ( empty($_POST['your-name']) or empty($_POST['email']) or empty($_POST['phone']) ) { 
		echo "<span class=\"err\">".esc_html__("You did not fill all required fields!","drivingschool-plugin")."</span>";
    } else {
        $fname = htmlspecialchars($_POST['your-name']);
	    $fmail = htmlspecialchars($_POST['email']);
        $fphone = htmlspecialchars($_POST['phone']);
		$cartype = htmlspecialchars($_POST['cartype']);
		$driving = htmlspecialchars($_POST['driving']);
		$date = htmlspecialchars($_POST['date']);
		$time = htmlspecialchars($_POST['time']);
		$admin_email = get_bloginfo('admin_email');
        if (!preg_match("|^([a-z0-9_\.\-]{1,20})@([a-z0-9\.\-]{1,20})\.([a-z]{2,4})|is",$fmail)) {
		    echo "<span class=\"err\">".esc_html__("Invalid E-mail!","drivingschool-plugin")."</span>";
        } else {
            $message = esc_html__("Your Name","drivingschool-plugin").": ".$fname." <br /><br />
                     ".esc_html__("Email","drivingschool-plugin").": ".$fmail." <br /><br />
                     ".esc_html__("Phone","drivingschool-plugin").": ".$fphone." <br /><br />
					 ".esc_html__("Car type","drivingschool-plugin").":".$cartype." >
					 ".esc_html__("Driving","drivingschool-plugin").":".$driving." >
					 ".esc_html__("Date","drivingschool-plugin").":".$date." >
					 ".esc_html__("Time","drivingschool-plugin").":".$time." >";
			$subject = esc_html__("Search for courses -","drivingschool-plugin")." '".get_bloginfo("name")."'";
			
			$headers[] = 'From: '.$fname.' <'.$noreplay_mail.'>';
			$headers[] = 'content-type: text/html';
			$headers[] = 'Cc: '.get_bloginfo("name").' <' . $noreplay_mail . '>';
			$headers[] = 'Cc: ' . $noreplay_mail;	 
			
			$prov = wp_mail( $to, $subject, $message, $headers );
			
            if ($prov) { 
                 echo "<span class=\"err0\">".esc_html__("Message sent!","drivingschool-plugin")."</span>";
            } else {
                 echo "<span class=\"err\">".esc_html__("Failure on the server!","drivingschool-plugin")."</span>";
            } 
        }
    }
}


if($_POST['typform'] == 'typ10') {
	if( !wp_verify_nonce( $nonce, 'course_techer') ) { die(); }
    
    if ( isset( $_POST['form_info'] ) && ! empty( $_POST['form_info'] ) ) {
        die();
    }
    
	if ( empty($_POST['your-name']) or empty($_POST['email']) or empty($_POST['phone']) ) { 
		echo "<span class=\"err\">".esc_html__("You did not fill all required fields!","drivingschool-plugin")."</span>";
    } else {
        $fname = htmlspecialchars($_POST['your-name']);
	    $fmail = htmlspecialchars($_POST['email']);
        $fphone = htmlspecialchars($_POST['phone']);
		$radio = htmlspecialchars($_POST['radio']);
		$course = htmlspecialchars($_POST['course']);
		$mailt = htmlspecialchars($_POST['mailt']);
        if (!preg_match("|^([a-z0-9_\.\-]{1,20})@([a-z0-9\.\-]{1,20})\.([a-z]{2,4})|is",$fmail)) {
		    echo "<span class=\"err\">".esc_html__("Invalid E-mail!","drivingschool-plugin")."</span>";
        } else {
            $message = esc_html__("Your Name","drivingschool-plugin").": ".$fname." <br /><br />
                     ".esc_html__("Email","drivingschool-plugin").": ".$fmail." <br /><br />
                     ".esc_html__("Phone","drivingschool-plugin").": ".$fphone." <br /><br />
					 ".esc_html__("Transmission","drivingschool-plugin").": ".$radio." <br /><br />
					 ".esc_html__("Course","drivingschool-plugin").": ".$course." <br /><br />";
			$subject = esc_html__("Course -","drivingschool-plugin")." '".get_bloginfo("name")."'";
			
			$headers[] = 'From: '.$fname.' <'.$noreplay_mail.'>';
			$headers[] = 'content-type: text/html';
			$headers[] = 'Cc: '.get_bloginfo("name").' <' . $noreplay_mail . '>';
			$headers[] = 'Cc: ' . $noreplay_mail; 
			
			$prov = wp_mail( $to, $subject, $message, $headers );
			
            if ($prov) { 
                 echo "<span class=\"err0\">".esc_html__("Message sent!","drivingschool-plugin")."</span>";
            } else {
                 echo "<span class=\"err\">".esc_html__("Failure on the server!","drivingschool-plugin")."</span>";
            } 
        }
    }
}

remove_filter( 'wp_mail_content_type', 'set_html_content_type' );
